// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; comment-column: 35; -*-

//-----------------------------------------------------------------------------
// eoFlight.h
// (c) OPAC 2007
/*
    Contact: paradiseo-help@lists.gforge.inria.fr
 */
//-----------------------------------------------------------------------------

#ifndef EOFLIGHT_H
#define EOFLIGHT_H

//-----------------------------------------------------------------------------
#include <eoFunctor.h>
#include <utils/eoRealVectorBounds.h>
//-----------------------------------------------------------------------------

/** Abstract class for PSO flight.
* All the flights must derivated from eoFlight.
*/

template < class POT > class eoFlight:public eoUF < POT &, void >
{
public:

    /**
    * Apply the flight to a whole population.
    */
    virtual void apply (eoPop < POT > &_pop)
    {
        for (unsigned i = 0; i < _pop.size (); i++)
        {
            operator  ()(_pop[i]);
        }

    }
};

#endif /*EOFLIGHT_H */
