// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; comment-column: 35; -*-

//-----------------------------------------------------------------------------
// eoVectorParticle.h
// (c) OPAC 2007
/*
    Contact: paradiseo-help@lists.gforge.inria.fr
 */
//-----------------------------------------------------------------------------

#ifndef _EOVECTORPARTICLE_H
#define _EOVECTORPARTICLE_H

#include <PO.h>

/**
 * Main class for particle representation. The positions, velocities and the best positions
 * associated to the  particle are stored as vectors. Inheriting from PO and std::vector,
 * tree templates arguments are required: the fitness type (which is also the type of the
 * particle's best fitness), the position type and the velocity type.
 */
template < class FitT, class PositionType, class VelocityType > class eoVectorParticle:public PO < FitT >,
            public std::vector <
            PositionType >
{

public:

    using PO < FitT >::invalidate;
    using
    std::vector <
    PositionType >::operator[];
    using
    std::vector <
    PositionType >::begin;
    using
    std::vector <
    PositionType >::end;
    using
    std::vector <
    PositionType >::size;

    typedef PositionType AtomType;
    typedef VelocityType ParticleVelocityType;


    /** Default constructor.
    *  @param _size Length of the tree vectors (we expect the same size), default is 0
    *  @param position
    *  @param velocity
    *  @param  bestPositions
    */
    eoVectorParticle (unsigned _size = 0,PositionType position = PositionType (), VelocityType velocity = VelocityType (), PositionType bestPositions = PositionType ()):PO < FitT > (),std::vector < PositionType > (_size, position), bestPositions (_size, bestPositions), velocities (_size,
                    velocity)
    {
    }


    // we can't have a Ctor from a std::vector, it would create ambiguity
    //  with the copy Ctor
    void
    position (const std::vector < PositionType > &_v)
    {
        if (_v.size () != size ())	// safety check
        {
            if (size ())		// NOT an initial empty std::vector
                std::
                cout <<
                "Warning: Changing position size in eoVectorParticle assignation"
                << std::endl;
            resize (_v.size ());
        }

        std::copy (_v.begin (), _v.end (), begin ());
        invalidate ();
    }

    /** Resize the tree vectors of the particle: positions, velocities and bestPositions
    * @param _size The new size for positions, velocities and bestPositions
    */
    void
    resize (unsigned _size)
    {
        std::vector < PositionType >::resize (_size);
        bestPositions.resize (_size);
        velocities.resize (_size);
    }


    /** Resize the best positions.
       * @param _size The new size for the best positions.
       */
    void
    resizeBestPositions (unsigned _size)
    {
        bestPositions.resize (_size);
    }


    /** Resize the velocities.
    * @param _size The new size for the velocities.
    */
    void
    resizeVelocities (unsigned _size)
    {
        velocities.resize (_size);
    }


    /* public attributes */
    std::vector < PositionType > bestPositions;
    std::vector < ParticleVelocityType > velocities;

};

#endif /*_EOVECTORPARTICLE_H*/
