/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;
import org.graphstream.graph.Structure;

public class Path
implements Structure {
    private Node root = null;
    Stack<Edge> edgePath = new Stack();
    Stack<Node> nodePath = new Stack();

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node root) {
        if (this.root == null) {
            this.root = root;
            this.nodePath.push(root);
        } else {
            System.err.printf("Error in org.miv.graphstream.graph.Path: root is not null. First use the clear method.%n", new Object[0]);
        }
    }

    public boolean contains(Node node) {
        return this.nodePath.contains(node);
    }

    public boolean contains(Edge edge) {
        return this.edgePath.contains(edge);
    }

    public boolean empty() {
        return this.nodePath.empty();
    }

    public int size() {
        return this.nodePath.size();
    }

    public Double getPathWeight(String characteristic) {
        double d = 0.0;
        for (Edge l : this.edgePath) {
            d += ((Double)l.getAttribute(characteristic, Number.class)).doubleValue();
        }
        return d;
    }

    public List<Edge> getEdgePath() {
        return this.edgePath;
    }

    public List<Node> getNodePath() {
        return this.nodePath;
    }

    public void add(Node from, Edge edge) {
        if (this.root == null) {
            if (from == null) {
                System.err.print("Error using org.miv.graphstream.graph.Path: Use setRoot( ) first. %n");
                System.exit(0);
            } else {
                this.setRoot(from);
            }
        }
        if (from == null) {
            from = this.nodePath.peek();
        }
        if (this.nodePath.size() == 1 || this.nodePath.peek() == from && (from == this.edgePath.peek().getSourceNode() || from == this.edgePath.peek().getTargetNode())) {
            this.nodePath.push((Node)edge.getOpposite(from));
            this.edgePath.push(edge);
        } else {
            System.err.printf("Path: Cannot add the specified edge, it cannot be part of the path! %n", new Object[0]);
        }
    }

    public void add(Edge edge) {
        if (this.nodePath.isEmpty()) {
            this.add(null, edge);
        } else {
            this.add(this.nodePath.peek(), edge);
        }
    }

    public void push(Node from, Edge edge) {
        this.add(from, edge);
    }

    public void push(Edge edge) {
        this.add(edge);
    }

    public Edge popEdge() {
        this.nodePath.pop();
        return this.edgePath.pop();
    }

    public Node popNode() {
        this.edgePath.pop();
        return this.nodePath.pop();
    }

    public Node peekNode() {
        return this.nodePath.peek();
    }

    public Edge peekEdge() {
        return this.edgePath.peek();
    }

    public void clear() {
        this.nodePath.clear();
        this.edgePath.clear();
        this.root = null;
    }

    public Path getACopy() {
        Path newPath = new Path();
        newPath.root = this.root;
        newPath.edgePath = (Stack)this.edgePath.clone();
        newPath.nodePath = (Stack)this.nodePath.clone();
        return newPath;
    }

    public void removeLoops() {
        int n = this.nodePath.size();
        int i = 0;
        while (i < n) {
            int j = n - 1;
            while (j > i) {
                if (this.nodePath.get(i) == this.nodePath.get(j)) {
                    int k = i + 1;
                    while (k <= j) {
                        this.nodePath.remove(i + 1);
                        this.edgePath.remove(i);
                        ++k;
                    }
                    n -= j - i;
                    j = i;
                }
                --j;
            }
            ++i;
        }
    }

    public boolean equals(Path p) {
        if (this.nodePath.size() != p.nodePath.size()) {
            return false;
        }
        int i = 0;
        while (i < this.nodePath.size()) {
            if (this.nodePath.get(i) != p.nodePath.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.nodePath.toString();
    }

    @Override
    public int getNodeCount() {
        return this.nodePath.size();
    }

    @Override
    public int getEdgeCount() {
        return this.edgePath.size();
    }

    @Override
    public <T extends Node> Iterator<T> getNodeIterator() {
        return this.nodePath.iterator();
    }

    @Override
    public <T extends Edge> Iterator<T> getEdgeIterator() {
        return this.edgePath.iterator();
    }

    @Override
    public <T extends Node> Iterable<? extends T> getEachNode() {
        return this.nodePath;
    }

    @Override
    public <T extends Edge> Iterable<? extends T> getEachEdge() {
        return this.edgePath;
    }

    @Override
    public <T extends Node> Collection<T> getNodeSet() {
        return this.nodePath;
    }

    @Override
    public <T extends Edge> Collection<T> getEdgeSet() {
        return this.edgePath;
    }
}

