/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.viewer.test;

import javax.swing.UIManager;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.ProxyPipe;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.spriteManager.Sprite;
import org.graphstream.ui.spriteManager.SpriteManager;
import org.graphstream.ui.swingViewer.Viewer;

public class DemoViewerJComponents {
    protected static String styleSheet = "graph {\tpadding:      60px;\tstroke-width: 1px;\tstroke-color: rgb(200,200,200);\tstroke-mode:  dots;\tfill-mode:    gradient-diagonal1;\tfill-color:   white, rgb(230,230,230);}node {\tshape:        jcomponent;\tjcomponent:   button;\tsize:         100px, 30px;\tstroke-width: 2px;\tstroke-color: rgb(180,180,180);\tfill-mode:    none;\ttext-font:    arial;\ttext-size:    11;\ttext-color:   rgb(30,30,30);\ttext-style:   bold; }node#B {\tshape:      jcomponent;\tjcomponent: text-field;\ttext-color: red;\ttext-style: italic;}node#C {\ticon:\t\turl(\"file:///home/antoine/GSLogo11a32.png\");\ticon-mode:\tat-left;}sprite#S3 {\tsize:       70, 80;\tsize-mode:\tfit;\ticon:\t\turl(\"file:///home/antoine/GSLogo11a64.png\");\ticon-mode:\tabove;}node.editable {\tshape:      jcomponent;\tjcomponent: text-field;}node:selected {\tstroke-mode: plain; stroke-width: 5px; stroke-color: red;}sprite {\tshape:      jcomponent;\tjcomponent: button;\tsize:       30px, 30px;\tfill-mode:  none;}";

    public static void main(String[] args) {
        new DemoViewerJComponents();
    }

    public DemoViewerJComponents() {
        MultiGraph graph = new MultiGraph("main graph");
        ThreadProxyPipe toSwing = new ThreadProxyPipe(graph);
        Viewer viewer = new Viewer(toSwing);
        ProxyPipe fromSwing = viewer.newThreadProxyOnGraphicGraph();
        SpriteManager sman = new SpriteManager(graph);
        fromSwing.addAttributeSink(graph);
        viewer.addDefaultView(true);
        Object A = graph.addNode("A");
        Object B = graph.addNode("B");
        Object C = graph.addNode("C");
        graph.addEdge("AB", "A", "B");
        graph.addEdge("BC", "B", "C");
        graph.addEdge("CA", "C", "A");
        A.addAttribute("xyz", 0, 1, 0);
        B.addAttribute("xyz", 1, 0, 0);
        C.addAttribute("xyz", -1, 0, 0);
        A.addAttribute("ui.label", "Quit");
        B.addAttribute("ui.label", "Editable text");
        C.addAttribute("ui.label", "Click to edit");
        graph.addAttribute("ui.stylesheet", styleSheet);
        Sprite s1 = sman.addSprite("S1");
        Sprite s2 = sman.addSprite("S2");
        Sprite s3 = sman.addSprite("S3");
        s1.attachToNode("B");
        s2.attachToEdge("BC");
        s1.setPosition(StyleConstants.Units.PX, 1.0, 0.0, 0.0);
        s2.setPosition(0.5);
        s3.setPosition(0.0, 0.5, 0.0);
        s1.addAttribute("ui.label", "1");
        s2.addAttribute("ui.label", "2");
        boolean loop = true;
        float angle = 0.0f;
        while (loop) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            fromSwing.pump();
            if (graph.hasAttribute("ui.viewClosed")) {
                loop = false;
                continue;
            }
            if (A.hasAttribute("ui.clicked")) {
                System.err.printf("A clicked (%s)%n", A.getLabel("ui.label"));
                A.removeAttribute("ui.clicked");
                loop = false;
            } else if (B.hasAttribute("ui.clicked")) {
                System.err.printf("B clicked (%s)%n", B.getLabel("ui.label"));
                B.removeAttribute("ui.clicked");
            } else if (C.hasAttribute("ui.clicked")) {
                System.err.printf("C clicked (%s)%n", C.getLabel("ui.label"));
                C.removeAttribute("ui.clicked");
                if (C.hasAttribute("ui.class")) {
                    C.removeAttribute("ui.class");
                } else {
                    C.addAttribute("ui.class", "editable");
                }
            }
            angle = (float)((double)angle + 0.01);
            if (angle > 360.0f) {
                angle = 0.0f;
            }
            s1.setPosition(StyleConstants.Units.PX, 70.0, angle, angle);
        }
        System.out.printf("Bye bye ...%n", new Object[0]);
        System.exit(0);
    }

    protected static void setLAF() {
        try {
            UIManager.LookAndFeelInfo[] installed = UIManager.getInstalledLookAndFeels();
            int i = 0;
            while (i < installed.length) {
                if (installed[i].getName().startsWith("GTK")) {
                    UIManager.setLookAndFeel(installed[i].getClassName());
                    i = installed.length;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void showSelection(Graph graph) {
        boolean selection = false;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Node node : graph) {
            if (node.hasAttribute("ui.selected")) {
                sb.append(String.format(" %s", node.getId()));
                selection = true;
            }
            if (!node.hasAttribute("ui.clicked")) continue;
            System.err.printf("node %s clicked%n", node.getId());
        }
        sb.append(" ]");
        if (selection) {
            System.err.printf("selection = %s%n", sb.toString());
        }
    }
}

