/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer.util;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.graphstream.graph.Node;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.GraphicSprite;
import org.graphstream.ui.swingViewer.View;
import org.graphstream.ui.swingViewer.util.MouseManager;

public class DefaultMouseManager
implements MouseManager {
    protected View view;
    protected GraphicGraph graph;
    protected GraphicElement curElement;
    protected float x1;
    protected float y1;

    @Override
    public void init(GraphicGraph graph, View view) {
        this.view = view;
        this.graph = graph;
        view.addMouseListener(this);
        view.addMouseMotionListener(this);
    }

    @Override
    public void release() {
        this.view.removeMouseListener(this);
        this.view.removeMouseMotionListener(this);
    }

    protected void mouseButtonPress(MouseEvent event) {
        this.view.requestFocus();
        if (!event.isShiftDown()) {
            for (Node node : this.graph) {
                if (!node.hasAttribute("ui.selected")) continue;
                node.removeAttribute("ui.selected");
            }
            for (GraphicSprite graphicSprite : this.graph.spriteSet()) {
                if (!graphicSprite.hasAttribute("ui.selected")) continue;
                graphicSprite.removeAttribute("ui.selected");
            }
        }
    }

    protected void mouseButtonRelease(MouseEvent event, ArrayList<GraphicElement> elementsInArea) {
        for (GraphicElement element : elementsInArea) {
            if (element.hasAttribute("ui.selected")) continue;
            element.addAttribute("ui.selected", new Object[0]);
        }
    }

    protected void mouseButtonPressOnElement(GraphicElement element, MouseEvent event) {
        this.view.freezeElement(element, true);
        if (event.getButton() == 3) {
            element.addAttribute("ui.selected", new Object[0]);
        } else {
            element.addAttribute("ui.clicked", new Object[0]);
        }
    }

    protected void elementMoving(GraphicElement element, MouseEvent event) {
        this.view.moveElementAtPx(element, event.getX(), event.getY());
    }

    protected void mouseButtonReleaseOffElement(GraphicElement element, MouseEvent event) {
        this.view.freezeElement(element, false);
        if (event.getButton() != 3) {
            element.removeAttribute("ui.clicked");
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.curElement = this.view.findNodeOrSpriteAt(event.getX(), event.getY());
        if (this.curElement != null) {
            this.mouseButtonPressOnElement(this.curElement, event);
        } else {
            this.x1 = event.getX();
            this.y1 = event.getY();
            this.mouseButtonPress(event);
            this.view.beginSelectionAt(this.x1, this.y1);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.curElement != null) {
            this.elementMoving(this.curElement, event);
        } else {
            this.view.selectionGrowsAt(event.getX(), event.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.curElement != null) {
            this.mouseButtonReleaseOffElement(this.curElement, event);
            this.curElement = null;
        } else {
            float t;
            float x2 = event.getX();
            float y2 = event.getY();
            if (this.x1 > x2) {
                t = this.x1;
                this.x1 = x2;
                x2 = t;
            }
            if (this.y1 > y2) {
                t = this.y1;
                this.y1 = y2;
                y2 = t;
            }
            this.mouseButtonRelease(event, this.view.allNodesOrSpritesIn(this.x1, this.y1, x2, y2));
            this.view.endSelectionAt(x2, y2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

