/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util.test;

import java.util.HashSet;
import org.graphstream.graph.Element;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.util.Filter;
import org.graphstream.util.Filters;
import org.junit.Assert;
import org.junit.Test;

public class TestFilters {
    @Test
    public void orFilter() {
        ToggleFilter f1 = new ToggleFilter();
        ToggleFilter f2 = new ToggleFilter();
        Filter<Object> or = Filters.or(f1, f2);
        f1.set(false);
        f2.set(false);
        Assert.assertFalse((boolean)or.isAvailable(null));
        f1.set(true);
        f2.set(false);
        Assert.assertTrue((boolean)or.isAvailable(null));
        f1.set(false);
        f2.set(true);
        Assert.assertTrue((boolean)or.isAvailable(null));
        f1.set(true);
        f2.set(true);
        Assert.assertTrue((boolean)or.isAvailable(null));
    }

    @Test
    public void andFilter() {
        ToggleFilter f1 = new ToggleFilter();
        ToggleFilter f2 = new ToggleFilter();
        Filter<Object> and = Filters.and(f1, f2);
        f1.set(false);
        f2.set(false);
        Assert.assertFalse((boolean)and.isAvailable(null));
        f1.set(true);
        f2.set(false);
        Assert.assertFalse((boolean)and.isAvailable(null));
        f1.set(false);
        f2.set(true);
        Assert.assertFalse((boolean)and.isAvailable(null));
        f1.set(true);
        f2.set(true);
        Assert.assertTrue((boolean)and.isAvailable(null));
    }

    @Test
    public void xorFilter() {
        ToggleFilter f1 = new ToggleFilter();
        ToggleFilter f2 = new ToggleFilter();
        Filter<Object> xor = Filters.xor(f1, f2);
        f1.set(false);
        f2.set(false);
        Assert.assertFalse((boolean)xor.isAvailable(null));
        f1.set(true);
        f2.set(false);
        Assert.assertTrue((boolean)xor.isAvailable(null));
        f1.set(false);
        f2.set(true);
        Assert.assertTrue((boolean)xor.isAvailable(null));
        f1.set(true);
        f2.set(true);
        Assert.assertFalse((boolean)xor.isAvailable(null));
    }

    @Test
    public void falseFilter() {
        Filter<Object> f = Filters.falseFilter();
        Assert.assertFalse((boolean)f.isAvailable(null));
    }

    @Test
    public void trueFilter() {
        Filter<Object> f = Filters.trueFilter();
        Assert.assertTrue((boolean)f.isAvailable(null));
    }

    @Test
    public void byAttributeFilter() {
        Filter<TestElement> f = Filters.byAttributeFilter("keyTest", "ok");
        TestElement e = new TestElement("e");
        Assert.assertFalse((boolean)f.isAvailable(e));
        e.setAttribute("keyTest", "no");
        Assert.assertFalse((boolean)f.isAvailable(e));
        e.setAttribute("keyTest", "ok");
        Assert.assertTrue((boolean)f.isAvailable(e));
    }

    @Test
    public void byIdFilter() {
        Filter<TestElement> f = Filters.byIdFilter("A.*");
        TestElement a1 = new TestElement("A1");
        TestElement a2 = new TestElement("a2");
        TestElement b1 = new TestElement("B1");
        TestElement c2 = new TestElement("C2");
        Assert.assertTrue((boolean)f.isAvailable(a1));
        Assert.assertFalse((boolean)f.isAvailable(a2));
        Assert.assertFalse((boolean)f.isAvailable(b1));
        Assert.assertFalse((boolean)f.isAvailable(c2));
    }

    @Test
    public void isContainedFilter() {
        HashSet<TestElement> elements = new HashSet<TestElement>();
        HashSet<String> elementsId = new HashSet<String>();
        Filter fObj = Filters.isContained(elements);
        Filter<TestElement> fId = Filters.isIdContained(elementsId);
        TestElement a1 = new TestElement("a1");
        TestElement a2 = new TestElement("a2");
        TestElement a3 = new TestElement("a3");
        elements.add(a1);
        elements.add(a2);
        elementsId.add("a3");
        Assert.assertTrue((boolean)fObj.isAvailable(a1));
        Assert.assertTrue((boolean)fObj.isAvailable(a2));
        Assert.assertFalse((boolean)fObj.isAvailable(a3));
        Assert.assertFalse((boolean)fId.isAvailable(a1));
        Assert.assertFalse((boolean)fId.isAvailable(a2));
        Assert.assertTrue((boolean)fId.isAvailable(a3));
    }

    static class TestElement
    extends AbstractElement {
        public TestElement(String id) {
            super(id);
        }

        @Override
        protected void attributeChanged(AbstractElement.AttributeChangeEvent event, String attribute, Object oldValue, Object newValue) {
        }

        protected String myGraphId() {
            return "test";
        }

        protected long newEvent() {
            return 0L;
        }

        @Override
        protected boolean nullAttributesAreErrors() {
            return false;
        }
    }

    static class ToggleFilter<T extends Element>
    implements Filter<T> {
        boolean flag;

        ToggleFilter() {
        }

        public void set(boolean on) {
            this.flag = on;
        }

        @Override
        public boolean isAvailable(T e) {
            return this.flag;
        }
    }
}

