/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.gml;

import java.io.IOException;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.stream.SourceBase;
import org.graphstream.stream.file.FileSourceGML;
import org.graphstream.stream.file.gml.Graphics;
import org.graphstream.stream.file.gml.KeyValues;

public class GMLContext {
    FileSourceGML gml;
    String sourceId;
    boolean directed;
    protected KeyValues nextStep = null;
    boolean inGraph = false;
    protected long edgeid = 0L;

    GMLContext(FileSourceGML gml) {
        this.gml = gml;
        this.sourceId = String.format("<GML stream %d>", System.currentTimeMillis());
    }

    void handleKeyValues(KeyValues kv) throws IOException {
        if (this.nextStep != null) {
            this.insertKeyValues(this.nextStep);
            this.nextStep = null;
        }
        try {
            if (kv != null) {
                this.insertKeyValues(kv);
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    void setNextStep(KeyValues kv) {
        this.nextStep = kv;
    }

    public void setDirected(boolean on) {
        this.directed = on;
    }

    void setIsInGraph(boolean on) {
        this.inGraph = on;
    }

    public void addNodeOrEdge(String element, KeyValues kv) {
        System.err.printf("adding %s %n", element);
    }

    protected void insertKeyValues(KeyValues kv) throws IOException {
        if (kv.key != null) {
            if (this.inGraph) {
                if (kv.key.equals("node") || kv.key.equals("add-node")) {
                    this.handleAddNode(kv);
                } else if (kv.key.equals("edge") || kv.key.equals("add-edge")) {
                    this.handleAddEdge(kv);
                } else if (kv.key.equals("del-node") || kv.key.equals("-node")) {
                    this.handleDelNode(kv);
                } else if (kv.key.equals("del-edge") || kv.key.equals("-edge")) {
                    this.handleDelEdge(kv);
                } else if (kv.key.equals("change-node") || kv.key.equals("+node")) {
                    this.handleChangeNode(kv);
                } else if (kv.key.equals("change-edge") || kv.key.equals("+edge")) {
                    this.handleChangeEdge(kv);
                } else if (kv.key.equals("step")) {
                    this.handleStep(kv);
                } else if (kv.key.equals("directed")) {
                    this.setDirected(this.getBoolean(kv.get("directed")));
                } else if (kv.key.startsWith("-")) {
                    this.gml.sendAttributeChangedEvent(this.sourceId, this.sourceId, SourceBase.ElementType.GRAPH, kv.key.substring(1), AbstractElement.AttributeChangeEvent.REMOVE, null, null);
                } else {
                    this.gml.sendAttributeChangedEvent(this.sourceId, this.sourceId, SourceBase.ElementType.GRAPH, kv.key, AbstractElement.AttributeChangeEvent.ADD, null, this.compositeAttribute(kv));
                }
            } else if (kv.key.startsWith("-")) {
                this.gml.sendAttributeChangedEvent(this.sourceId, this.sourceId, SourceBase.ElementType.GRAPH, kv.key.substring(1), AbstractElement.AttributeChangeEvent.REMOVE, null, null);
            } else {
                this.gml.sendAttributeChangedEvent(this.sourceId, this.sourceId, SourceBase.ElementType.GRAPH, kv.key, AbstractElement.AttributeChangeEvent.ADD, null, this.compositeAttribute(kv));
            }
        }
    }

    protected Object compositeAttribute(KeyValues kv) {
        if (kv.size() < 2) {
            return kv.get(kv.key);
        }
        return kv;
    }

    protected void handleAddNode(KeyValues kv) throws IOException {
        Object thing = kv.get("node");
        if (thing == null) {
            thing = kv.get("add-node");
        }
        if (thing == null) {
            kv.error("expecting a node or add-node token here");
        }
        if (thing instanceof String) {
            String id = (String)thing;
            this.gml.sendNodeAdded(this.sourceId, id);
        } else if (thing instanceof KeyValues) {
            KeyValues node = (KeyValues)thing;
            String id = node.reqStringOrNumber("id");
            this.gml.sendNodeAdded(this.sourceId, id);
            this.handleNodeAttributes(id, node);
        } else {
            kv.error("unknown token type");
        }
    }

    protected void handleAddEdge(KeyValues kv) throws IOException {
        Object thing = kv.get("edge");
        if (thing == null) {
            thing = kv.get("add-edge");
        }
        if (thing == null) {
            kv.error("expecting a edge or add-edge token here");
        }
        if (!(thing instanceof KeyValues)) {
            kv.error("expecting a set of values for the new edge");
        }
        KeyValues edge = (KeyValues)thing;
        String id = edge.optString("id");
        String src = edge.reqStringOrNumber("source");
        String trg = edge.reqStringOrNumber("target");
        if (id == null) {
            id = String.format("%s_%s_%d", src, trg, this.edgeid++);
        }
        String dir = edge.optString("directed");
        boolean directed = this.directed;
        if (dir != null) {
            directed = this.getBoolean(dir);
        }
        this.gml.sendEdgeAdded(this.sourceId, id, src, trg, directed);
        this.handleEdgeAttributes(id, edge);
    }

    protected void handleDelNode(KeyValues kv) throws IOException {
        Object thing = kv.get("del-node");
        if (thing == null) {
            thing = kv.get("-node");
        }
        if (thing == null) {
            kv.error("expecting a del-node or -node token here");
        }
        if (thing instanceof String) {
            String id = (String)thing;
            this.gml.sendNodeRemoved(this.sourceId, id);
        } else if (thing instanceof KeyValues) {
            KeyValues node = (KeyValues)thing;
            String id = node.reqString("id");
            this.gml.sendNodeRemoved(this.sourceId, id);
        } else {
            kv.error("unknown token type");
        }
    }

    protected void handleDelEdge(KeyValues kv) throws IOException {
        Object thing = kv.get("del-edge");
        if (thing == null) {
            thing = kv.get("-edge");
        }
        if (thing == null) {
            kv.error("expecting a del-edge or -edge token here");
        }
        if (thing instanceof String) {
            String id = (String)thing;
            this.gml.sendEdgeRemoved(this.sourceId, id);
        } else if (thing instanceof KeyValues) {
            KeyValues edge = (KeyValues)thing;
            String id = edge.reqString("id");
            this.gml.sendEdgeRemoved(this.sourceId, id);
        } else {
            kv.error("unknown token type");
        }
    }

    protected void handleChangeNode(KeyValues kv) throws IOException {
        Object thing = kv.get("change-node");
        if (thing == null) {
            thing = kv.get("+node");
        }
        if (thing == null) {
            kv.error("expecting a change-node or +node token here");
        }
        if (!(thing instanceof KeyValues)) {
            kv.error("expecting a set of values");
        }
        KeyValues node = (KeyValues)thing;
        String id = node.reqString("id");
        this.handleNodeAttributes(id, node);
    }

    protected void handleChangeEdge(KeyValues kv) throws IOException {
        Object thing = kv.get("change-edge");
        if (thing == null) {
            thing = kv.get("+edge");
        }
        if (thing == null) {
            kv.error("expecting a change-edge or +edge token here");
        }
        if (!(thing instanceof KeyValues)) {
            kv.error("expecting a set of values");
        }
        KeyValues edge = (KeyValues)thing;
        String id = edge.reqString("id");
        this.handleEdgeAttributes(id, edge);
    }

    protected void handleNodeAttributes(String id, KeyValues node) {
        for (String key : node.keySet()) {
            if (key.startsWith("-")) {
                if (key.equals("-label")) {
                    key = "-ui.label";
                }
                this.gml.sendAttributeChangedEvent(this.sourceId, id, SourceBase.ElementType.NODE, key.substring(1), AbstractElement.AttributeChangeEvent.REMOVE, null, null);
                continue;
            }
            if (key.equals("graphics") && node.get("graphics") instanceof KeyValues) {
                Graphics graphics = this.optNodeStyle((KeyValues)node.get("graphics"));
                if (graphics == null) continue;
                if (graphics.position != null) {
                    this.gml.sendAttributeChangedEvent(this.sourceId, id, SourceBase.ElementType.NODE, "xyz", AbstractElement.AttributeChangeEvent.ADD, null, graphics.getPosition());
                }
                if (graphics.style == null) continue;
                this.gml.sendAttributeChangedEvent(this.sourceId, id, SourceBase.ElementType.NODE, "ui.style", AbstractElement.AttributeChangeEvent.ADD, null, graphics.style);
                continue;
            }
            String k = key;
            if (key.equals("label")) {
                k = "ui.label";
            }
            this.gml.sendAttributeChangedEvent(this.sourceId, id, SourceBase.ElementType.NODE, k, AbstractElement.AttributeChangeEvent.ADD, null, node.get(key));
        }
    }

    protected void handleEdgeAttributes(String id, KeyValues edge) {
        for (String key : edge.keySet()) {
            if (key.startsWith("-")) {
                if (key.equals("-label")) {
                    key = "-ui.label";
                }
                this.gml.sendAttributeChangedEvent(this.sourceId, id, SourceBase.ElementType.EDGE, key.substring(1), AbstractElement.AttributeChangeEvent.REMOVE, null, null);
                continue;
            }
            if (key.equals("graphics") && edge.get("graphics") instanceof KeyValues) {
                Graphics graphics = this.optEdgeStyle((KeyValues)edge.get("graphics"));
                if (graphics == null || graphics.style == null) continue;
                this.gml.sendAttributeChangedEvent(this.sourceId, id, SourceBase.ElementType.EDGE, "ui.style", AbstractElement.AttributeChangeEvent.ADD, null, graphics.style);
                continue;
            }
            String k = key;
            if (key.equals("label")) {
                k = "ui.label";
            }
            this.gml.sendAttributeChangedEvent(this.sourceId, id, SourceBase.ElementType.EDGE, k, AbstractElement.AttributeChangeEvent.ADD, null, edge.get(key));
        }
    }

    protected void handleStep(KeyValues kv) throws IOException {
        this.gml.sendStepBegins(this.sourceId, kv.reqNumber("step"));
    }

    protected Graphics optNodeStyle(KeyValues kv) {
        Graphics graphics = null;
        if (kv != null) {
            StringBuffer style = new StringBuffer();
            String w = null;
            String h = null;
            String d = null;
            graphics = new Graphics();
            if (kv.get("x") != null) {
                graphics.setX(this.asDouble((String)kv.get("x")));
            }
            if (kv.get("y") != null) {
                graphics.setY(this.asDouble((String)kv.get("y")));
            }
            if (kv.get("z") != null) {
                graphics.setZ(this.asDouble((String)kv.get("z")));
            }
            if (kv.get("w") != null) {
                w = (String)kv.get("w");
            }
            if (kv.get("h") != null) {
                h = (String)kv.get("h");
            }
            if (kv.get("d") != null) {
                d = (String)kv.get("d");
            }
            if (w != null || h != null || d != null) {
                int ww = w != null ? (int)this.asDouble(w) : 0;
                int hh = h != null ? (int)this.asDouble(h) : 0;
                int dd = d != null ? (int)this.asDouble(d) : 0;
                style.append(String.format("size: %dpx, %dpx, %dpx; ", ww, hh, dd));
            }
            if (kv.get("type") != null) {
                style.append(String.format("shape: %s; ", this.asNodeShape((String)kv.get("type"))));
            }
            this.commonGraphicsAttributes(kv, style);
            graphics.style = style.toString();
        }
        return graphics;
    }

    protected Graphics optEdgeStyle(KeyValues kv) {
        Graphics graphics = null;
        if (kv != null) {
            StringBuffer style = new StringBuffer();
            String w = null;
            graphics = new Graphics();
            if (kv.get("width") != null) {
                w = (String)kv.get("width");
            } else if (kv.get("w") != null) {
                w = (String)kv.get("w");
            }
            if (w != null) {
                double ww = w != null ? this.asDouble(w) : 0.0;
                style.append(String.format("size: %fpx;", ww));
            }
            if (kv.get("type") != null) {
                style.append(String.format("shape: %s; ", this.asEdgeShape((String)kv.get("type"))));
            }
            this.commonGraphicsAttributes(kv, style);
            graphics.style = style.toString();
        }
        return graphics;
    }

    protected void commonGraphicsAttributes(KeyValues kv, StringBuffer style) {
        if (kv.get("fill") != null) {
            style.append(String.format("fill-color: %s; ", kv.get("fill")));
        }
        if (kv.get("outline") != null) {
            style.append(String.format("stroke-color: %s; ", kv.get("outline")));
        }
        if (kv.get("outline_width") != null) {
            style.append(String.format("stroke-width: %spx; ", kv.get("outline_width")));
        }
        if (kv.get("outline") != null || kv.get("outline_width") != null) {
            style.append("stroke-mode: plain; ");
        }
        if (kv.get("anchor") != null) {
            style.append(String.format("text-alginment: %s; ", this.asTextAlignment((String)kv.get("anchor"))));
        }
        if (kv.get("image") != null) {
            style.append(String.format("icon-mode: at-left; icon: %s; ", (String)kv.get("image")));
        }
        if (kv.get("arrow") != null) {
            style.append(String.format("arrow-shape: %s; ", this.asArrowShape((String)kv.get("arrow"))));
        }
        if (kv.get("font") != null) {
            style.append(String.format("font: %s; ", (String)kv.get("font")));
        }
    }

    protected double asDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    protected String asNodeShape(String type) {
        if (type.equals("ellipse") || type.equals("oval")) {
            return "circle";
        }
        if (type.equals("rectangle") || type.equals("box")) {
            return "box";
        }
        if (type.equals("rounded-box")) {
            return "rounded-box";
        }
        if (type.equals("cross")) {
            return "cross";
        }
        if (type.equals("freeplane")) {
            return "freeplane";
        }
        if (type.equals("losange") || type.equals("diamond")) {
            return "diamond";
        }
        return "circle";
    }

    protected String asEdgeShape(String type) {
        if (type.equals("line")) {
            return "line";
        }
        if (type.equals("cubic-curve")) {
            return "cubic-curve";
        }
        if (type.equals("angle")) {
            return "angle";
        }
        if (type.equals("blob")) {
            return "blob";
        }
        if (type.equals("freeplane")) {
            return "freeplane";
        }
        return "line";
    }

    protected String asTextAlignment(String anchor) {
        if (anchor.equals("c")) {
            return "center";
        }
        if (anchor.equals("n")) {
            return "above";
        }
        if (anchor.equals("ne")) {
            return "at-right";
        }
        if (anchor.equals("e")) {
            return "at-right";
        }
        if (anchor.equals("se")) {
            return "at-right";
        }
        if (anchor.equals("s")) {
            return "under";
        }
        if (anchor.equals("sw")) {
            return "at-left";
        }
        if (anchor.equals("w")) {
            return "at-left";
        }
        if (anchor.equals("nw")) {
            return "at-left";
        }
        return "center";
    }

    protected String asArrowShape(String arrow) {
        if (arrow.equals("none")) {
            return "none";
        }
        if (arrow.equals("last")) {
            return "arrow";
        }
        return "none";
    }

    protected boolean getBoolean(Object bool) {
        if (bool instanceof String) {
            return bool.equals("1") || bool.equals("true") || bool.equals("yes") || bool.equals("y");
        }
        if (bool instanceof Number) {
            return ((Number)bool).doubleValue() != 0.0;
        }
        return false;
    }
}

