/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.graphstream.stream.SourceBase;
import org.graphstream.stream.file.FileSource;

public class FileSourceGraphML
extends SourceBase
implements FileSource,
XMLStreamConstants {
    protected XMLEventReader reader;
    protected HashMap<String, Key> keys;
    protected LinkedList<Data> datas;
    protected Stack<XMLEvent> events = new Stack();
    protected Stack<String> graphId;
    protected int graphCounter = 0;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$PortAttribute;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$GraphAttribute;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$NodeAttribute;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$EdgeAttribute;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$HyperEdgeAttribute;

    public FileSourceGraphML() {
        this.keys = new HashMap();
        this.datas = new LinkedList();
        this.graphId = new Stack();
        this.sourceId = String.format("<GraphML stream %x>", System.nanoTime());
    }

    @Override
    public void readAll(String fileName) throws IOException {
        this.readAll(new FileReader(fileName));
    }

    @Override
    public void readAll(URL url) throws IOException {
        this.readAll(url.openStream());
    }

    @Override
    public void readAll(InputStream stream) throws IOException {
        this.readAll(new InputStreamReader(stream));
    }

    @Override
    public void readAll(Reader reader) throws IOException {
        this.begin(reader);
        while (this.nextEvents()) {
        }
        this.end();
    }

    @Override
    public void begin(String fileName) throws IOException {
        this.begin(new FileReader(fileName));
    }

    @Override
    public void begin(URL url) throws IOException {
        this.begin(url.openStream());
    }

    @Override
    public void begin(InputStream stream) throws IOException {
        this.begin(new InputStreamReader(stream));
    }

    @Override
    public void begin(Reader reader) throws IOException {
        this.openStream(reader);
    }

    @Override
    public boolean nextEvents() throws IOException {
        try {
            this.__graphml();
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
        return false;
    }

    @Override
    public boolean nextStep() throws IOException {
        return this.nextEvents();
    }

    @Override
    public void end() throws IOException {
        this.closeStream();
    }

    protected XMLEvent getNextEvent() throws IOException, XMLStreamException {
        this.skipWhiteSpaces();
        if (this.events.size() > 0) {
            return this.events.pop();
        }
        return this.reader.nextEvent();
    }

    protected void pushback(XMLEvent e) {
        this.events.push(e);
    }

    private XMLStreamException newParseError(XMLEvent e, String msg, Object ... args) {
        return new XMLStreamException(String.format(msg, args), e.getLocation());
    }

    private boolean isEvent(XMLEvent e, int type, String name) {
        boolean valid;
        boolean bl = valid = e.getEventType() == type;
        if (valid) {
            switch (type) {
                case 1: {
                    valid = e.asStartElement().getName().getLocalPart().equals(name);
                    break;
                }
                case 2: {
                    valid = e.asEndElement().getName().getLocalPart().equals(name);
                    break;
                }
                case 10: {
                    valid = ((Attribute)e).getName().getLocalPart().equals(name);
                }
            }
        }
        return valid;
    }

    private void checkValid(XMLEvent e, int type, String name) throws XMLStreamException {
        boolean valid = this.isEvent(e, type, name);
        if (!valid) {
            throw this.newParseError(e, "expecting %s, got %s", this.gotWhat(type, name), this.gotWhat(e));
        }
    }

    private String gotWhat(XMLEvent e) {
        String v = null;
        switch (e.getEventType()) {
            case 1: {
                v = e.asStartElement().getName().getLocalPart();
                break;
            }
            case 2: {
                v = e.asEndElement().getName().getLocalPart();
                break;
            }
            case 10: {
                v = ((Attribute)e).getName().getLocalPart();
            }
        }
        return this.gotWhat(e.getEventType(), v);
    }

    private String gotWhat(int type, String v) {
        switch (type) {
            case 1: {
                return String.format("'<%s>'", v);
            }
            case 2: {
                return String.format("'</%s>'", v);
            }
            case 10: {
                return String.format("attribute '%s'", v);
            }
            case 13: {
                return "namespace";
            }
            case 3: {
                return "processing instruction";
            }
            case 5: {
                return "comment";
            }
            case 7: {
                return "document start";
            }
            case 8: {
                return "document end";
            }
            case 11: {
                return "dtd";
            }
            case 4: {
                return "characters";
            }
        }
        return "UNKNOWN";
    }

    private Object getValue(Data data) {
        switch (data.key.type) {
            case BOOLEAN: {
                return Boolean.parseBoolean(data.value);
            }
            case INT: {
                return Integer.parseInt(data.value);
            }
            case LONG: {
                return Long.parseLong(data.value);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(data.value));
            }
            case DOUBLE: {
                return Double.parseDouble(data.value);
            }
            case STRING: {
                return data.value;
            }
        }
        return data.value;
    }

    private Object getDefaultValue(Key key) {
        switch (key.type) {
            case BOOLEAN: {
                return Boolean.TRUE;
            }
            case INT: {
                if (key.def != null) {
                    return Integer.valueOf(key.def);
                }
                return 0;
            }
            case LONG: {
                if (key.def != null) {
                    return Long.valueOf(key.def);
                }
                return 0L;
            }
            case FLOAT: {
                if (key.def != null) {
                    return Float.valueOf(key.def);
                }
                return Float.valueOf(0.0f);
            }
            case DOUBLE: {
                if (key.def != null) {
                    return Double.valueOf(key.def);
                }
                return 0.0;
            }
            case STRING: {
                if (key.def != null) {
                    return key.def;
                }
                return "";
            }
        }
        return key.def != null ? key.def : Boolean.TRUE;
    }

    private void skipWhiteSpaces() throws IOException, XMLStreamException {
        XMLEvent e;
        while (this.isEvent(e = this.events.size() > 0 ? this.events.pop() : this.reader.nextEvent(), 4, null) && e.asCharacters().getData().matches("^\\s*$")) {
        }
        this.pushback(e);
    }

    protected void openStream(Reader stream) throws IOException {
        if (this.reader != null) {
            this.closeStream();
        }
        try {
            this.reader = XMLInputFactory.newInstance().createXMLEventReader(stream);
            XMLEvent e = this.getNextEvent();
            this.checkValid(e, 7, null);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new IOException(e);
        }
    }

    protected void closeStream() throws IOException {
        try {
            try {
                this.reader.close();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }
        finally {
            this.reader = null;
        }
    }

    protected String toConstantName(Attribute a) {
        return this.toConstantName(a.getName().getLocalPart());
    }

    protected String toConstantName(String value) {
        return value.toUpperCase().replaceAll("\\W", "_");
    }

    private void __graphml() throws IOException, XMLStreamException {
        XMLEvent e = this.getNextEvent();
        this.checkValid(e, 1, "graphml");
        e = this.getNextEvent();
        if (this.isEvent(e, 1, "desc")) {
            this.pushback(e);
            this.__desc();
            e = this.getNextEvent();
        }
        while (this.isEvent(e, 1, "key")) {
            this.pushback(e);
            this.__key();
            e = this.getNextEvent();
        }
        while (this.isEvent(e, 1, "data") || this.isEvent(e, 1, "graph")) {
            this.pushback(e);
            if (this.isEvent(e, 1, "data")) {
                this.__data();
            } else {
                this.__graph();
            }
            e = this.getNextEvent();
        }
        this.checkValid(e, 2, "graphml");
    }

    private String __characters() throws IOException, XMLStreamException {
        StringBuilder buffer = new StringBuilder();
        XMLEvent e = this.getNextEvent();
        while (e.getEventType() == 4) {
            buffer.append(e.asCharacters());
            e = this.getNextEvent();
        }
        this.pushback(e);
        return buffer.toString();
    }

    private String __desc() throws IOException, XMLStreamException {
        XMLEvent e = this.getNextEvent();
        this.checkValid(e, 1, "desc");
        String desc = this.__characters();
        e = this.getNextEvent();
        this.checkValid(e, 2, "desc");
        return desc;
    }

    private Locator __locator() throws IOException, XMLStreamException {
        XMLEvent e = this.getNextEvent();
        this.checkValid(e, 1, "locator");
        Iterator<Attribute> attributes = e.asStartElement().getAttributes();
        Locator loc = new Locator();
        while (attributes.hasNext()) {
            Attribute a = attributes.next();
            try {
                LocatorAttribute attribute = LocatorAttribute.valueOf(this.toConstantName(a));
                switch (attribute) {
                    case XMLNS_XLINK: {
                        loc.xlink = a.getValue();
                        break;
                    }
                    case XLINK_HREF: {
                        loc.href = a.getValue();
                        break;
                    }
                    case XLINK_TYPE: {
                        loc.type = a.getValue();
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                throw this.newParseError(e, "invalid locator attribute '%s'", a.getName().getLocalPart());
            }
        }
        e = this.getNextEvent();
        this.checkValid(e, 2, "locator");
        if (loc.href == null) {
            throw this.newParseError(e, "locator requires an href", new Object[0]);
        }
        return loc;
    }

    private void __key() throws IOException, XMLStreamException {
        XMLEvent e = this.getNextEvent();
        this.checkValid(e, 1, "key");
        Iterator<Attribute> attributes = e.asStartElement().getAttributes();
        String id = null;
        KeyDomain domain = KeyDomain.ALL;
        KeyAttrType type = KeyAttrType.STRING;
        String name = null;
        String def = null;
        while (attributes.hasNext()) {
            Attribute a = attributes.next();
            try {
                KeyAttribute attribute = KeyAttribute.valueOf(this.toConstantName(a));
                switch (attribute) {
                    case ID: {
                        id = a.getValue();
                        break;
                    }
                    case FOR: {
                        try {
                            domain = KeyDomain.valueOf(this.toConstantName(a.getValue()));
                            break;
                        }
                        catch (IllegalArgumentException ex) {
                            throw this.newParseError(e, "invalid key domain '%s'", a.getValue());
                        }
                    }
                    case ATTR_TYPE: {
                        try {
                            type = KeyAttrType.valueOf(this.toConstantName(a.getValue()));
                            break;
                        }
                        catch (IllegalArgumentException ex) {
                            throw this.newParseError(e, "invalid key type '%s'", a.getValue());
                        }
                    }
                    case ATTR_NAME: {
                        name = a.getValue();
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                throw this.newParseError(e, "invalid key attribute '%s'", a.getName().getLocalPart());
            }
        }
        e = this.getNextEvent();
        if (this.isEvent(e, 1, "default")) {
            def = this.__characters();
            e = this.getNextEvent();
            this.checkValid(e, 2, "default");
            e = this.getNextEvent();
        }
        this.checkValid(e, 2, "key");
        if (id == null) {
            throw this.newParseError(e, "key requires an id", new Object[0]);
        }
        if (name == null) {
            name = id;
        }
        System.out.printf("add key \"%s\"\n", id);
        Key k = new Key();
        k.name = name;
        k.domain = domain;
        k.type = type;
        k.def = def;
        this.keys.put(id, k);
    }

    /*
     * Unable to fully structure code
     */
    private Port __port() throws IOException, XMLStreamException {
        block10: {
            e = this.getNextEvent();
            this.checkValid(e, 1, "port");
            port = new Port();
            attributes = e.asStartElement().getAttributes();
            while (attributes.hasNext()) {
                a = attributes.next();
                try {
                    attribute = PortAttribute.valueOf(this.toConstantName(a));
                    switch (FileSourceGraphML.$SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$PortAttribute()[attribute.ordinal()]) {
                        case 1: {
                            port.name = a.getValue();
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw this.newParseError(e, "invalid attribute '%s' for '<port>'", new Object[]{a.getName().getLocalPart()});
                }
            }
            if (port.name == null) {
                throw this.newParseError(e, "'<port>' element requires a 'name' attribute", new Object[0]);
            }
            e = this.getNextEvent();
            if (!this.isEvent(e, 1, "desc")) ** GOTO lbl33
            this.pushback(e);
            port.desc = this.__desc();
            break block10;
lbl-1000:
            // 1 sources

            {
                if (this.isEvent(e, 1, "data")) {
                    this.pushback(e);
                    data = this.__data();
                    port.datas.add(data);
                } else {
                    this.pushback(e);
                    portChild = this.__port();
                    port.ports.add(portChild);
                }
                e = this.getNextEvent();
lbl33:
                // 2 sources

                ** while (this.isEvent((XMLEvent)e, (int)1, (String)"data") || this.isEvent((XMLEvent)e, (int)1, (String)"port"))
            }
        }
        e = this.getNextEvent();
        this.checkValid(e, 2, "port");
        return port;
    }

    private EndPoint __endpoint() throws IOException, XMLStreamException {
        XMLEvent e = this.getNextEvent();
        this.checkValid(e, 1, "endpoint");
        Iterator<Attribute> attributes = e.asStartElement().getAttributes();
        EndPoint ep = new EndPoint();
        while (attributes.hasNext()) {
            Attribute a = attributes.next();
            try {
                EndPointAttribute attribute = EndPointAttribute.valueOf(this.toConstantName(a));
                switch (attribute) {
                    case NODE: {
                        ep.node = a.getValue();
                        break;
                    }
                    case ID: {
                        ep.id = a.getValue();
                        break;
                    }
                    case PORT: {
                        ep.port = a.getValue();
                        break;
                    }
                    case TYPE: {
                        try {
                            ep.type = EndPointType.valueOf(this.toConstantName(a.getValue()));
                            break;
                        }
                        catch (IllegalArgumentException ex) {
                            throw this.newParseError(e, "invalid end point type '%s'", a.getValue());
                        }
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                throw this.newParseError(e, "invalid attribute '%s' for '<endpoint>'", a.getName().getLocalPart());
            }
        }
        if (ep.node == null) {
            throw this.newParseError(e, "'<endpoint>' element requires a 'node' attribute", new Object[0]);
        }
        e = this.getNextEvent();
        if (this.isEvent(e, 1, "desc")) {
            this.pushback(e);
            ep.desc = this.__desc();
        }
        e = this.getNextEvent();
        this.checkValid(e, 2, "endpoint");
        return ep;
    }

    private Data __data() throws IOException, XMLStreamException {
        StringBuilder buffer = new StringBuilder();
        XMLEvent e = this.getNextEvent();
        this.checkValid(e, 1, "data");
        Iterator<Attribute> attributes = e.asStartElement().getAttributes();
        String key = null;
        String id = null;
        while (attributes.hasNext()) {
            Attribute a = attributes.next();
            try {
                DataAttribute attribute = DataAttribute.valueOf(this.toConstantName(a));
                switch (attribute) {
                    case KEY: {
                        key = a.getValue();
                        break;
                    }
                    case ID: {
                        id = a.getValue();
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                throw this.newParseError(e, "invalid attribute '%s' for '<data>'", a.getName().getLocalPart());
            }
        }
        if (key == null) {
            throw this.newParseError(e, "'<data>' element must have a 'key' attribute", new Object[0]);
        }
        e = this.getNextEvent();
        while (e.getEventType() == 4) {
            buffer.append(e.asCharacters());
            e = this.getNextEvent();
        }
        this.checkValid(e, 2, "data");
        if (this.keys.containsKey(key)) {
            this.newParseError(e, "unknown key '%s'", key);
        }
        Data d = new Data();
        d.key = this.keys.get(key);
        d.id = id;
        d.value = buffer.toString();
        return d;
    }

    /*
     * Unable to fully structure code
     */
    private void __graph() throws IOException, XMLStreamException {
        block21: {
            e = this.getNextEvent();
            this.checkValid(e, 1, "graph");
            attributes = e.asStartElement().getAttributes();
            id = null;
            desc = null;
            directed = false;
            directedSet = false;
            while (attributes.hasNext()) {
                a = attributes.next();
                try {
                    attribute = GraphAttribute.valueOf(this.toConstantName(a));
                    switch (FileSourceGraphML.$SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$GraphAttribute()[attribute.ordinal()]) {
                        case 1: {
                            id = a.getValue();
                            break;
                        }
                        case 2: {
                            if (a.getValue().equals("directed")) {
                                directed = true;
                            } else if (a.getValue().equals("undirected")) {
                                directed = false;
                            } else {
                                throw this.newParseError(e, "invalid 'edgefault' value '%s'", new Object[]{a.getValue()});
                            }
                            directedSet = true;
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw this.newParseError(e, "invalid node attribute '%s'", new Object[]{a.getName().getLocalPart()});
                }
            }
            if (!directedSet) {
                throw this.newParseError(e, "graph requires attribute 'edgedefault'", new Object[0]);
            }
            gid = "";
            if (this.graphId.size() > 0) {
                gid = String.valueOf(this.graphId.peek()) + ":";
            }
            gid = id != null ? String.valueOf(gid) + id : String.valueOf(gid) + Integer.toString(this.graphCounter++);
            this.graphId.push(gid);
            e = this.getNextEvent();
            if (this.isEvent(e, 1, "desc")) {
                this.pushback(e);
                desc = this.__desc();
                this.sendGraphAttributeAdded(this.sourceId, "desc", desc);
                e = this.getNextEvent();
            }
            if (!this.isEvent(e, 1, "locator")) ** GOTO lbl61
            this.pushback(e);
            this.__locator();
            e = this.getNextEvent();
            break block21;
lbl-1000:
            // 1 sources

            {
                this.pushback(e);
                if (this.isEvent(e, 1, "data")) {
                    this.datas.add(this.__data());
                } else if (this.isEvent(e, 1, "node")) {
                    this.__node();
                } else if (this.isEvent(e, 1, "edge")) {
                    this.__edge(directed);
                } else {
                    this.__hyperedge();
                }
                e = this.getNextEvent();
lbl61:
                // 2 sources

                ** while (this.isEvent((XMLEvent)e, (int)1, (String)"data") || this.isEvent((XMLEvent)e, (int)1, (String)"node") || this.isEvent((XMLEvent)e, (int)1, (String)"edge") || this.isEvent((XMLEvent)e, (int)1, (String)"hyperedge"))
            }
        }
        this.graphId.pop();
        this.checkValid(e, 2, "graph");
    }

    /*
     * Unable to fully structure code
     */
    private void __node() throws IOException, XMLStreamException {
        block13: {
            block12: {
                e = this.getNextEvent();
                this.checkValid(e, 1, "node");
                attributes = e.asStartElement().getAttributes();
                id = null;
                sentAttributes = new HashSet<Key>();
                while (attributes.hasNext()) {
                    a = attributes.next();
                    try {
                        attribute = NodeAttribute.valueOf(this.toConstantName(a));
                        switch (FileSourceGraphML.$SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$NodeAttribute()[attribute.ordinal()]) {
                            case 1: {
                                id = a.getValue();
                            }
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        throw this.newParseError(e, "invalid node attribute '%s'", new Object[]{a.getName().getLocalPart()});
                    }
                }
                if (id == null) {
                    throw this.newParseError(e, "node requires an id", new Object[0]);
                }
                this.sendNodeAdded(this.sourceId, id);
                e = this.getNextEvent();
                if (!this.isEvent(e, 1, "desc")) break block12;
                this.pushback(e);
                desc = this.__desc();
                this.sendNodeAttributeAdded(this.sourceId, id, "desc", desc);
                break block13;
            }
            if (!this.isEvent(e, 1, "locator")) ** GOTO lbl42
            this.pushback(e);
            this.__locator();
            break block13;
lbl-1000:
            // 1 sources

            {
                if (this.isEvent(e, 1, "data")) {
                    this.pushback(e);
                    data = this.__data();
                    this.sendNodeAttributeAdded(this.sourceId, id, data.key.name, this.getValue(data));
                    sentAttributes.add(data.key);
                } else {
                    this.pushback(e);
                    this.__port();
                }
                e = this.getNextEvent();
lbl42:
                // 2 sources

                ** while (this.isEvent((XMLEvent)e, (int)1, (String)"data") || this.isEvent((XMLEvent)e, (int)1, (String)"port"))
            }
        }
        for (Key k : this.keys.values()) {
            if (k.domain != KeyDomain.NODE && k.domain != KeyDomain.ALL || sentAttributes.contains(k)) continue;
            this.sendNodeAttributeAdded(this.sourceId, id, k.name, this.getDefaultValue(k));
        }
        if (this.isEvent(e, 1, "graph")) {
            loc = e.getLocation();
            System.err.printf("[WARNING] %d:%d graph inside node is not implemented", new Object[]{loc.getLineNumber(), loc.getColumnNumber()});
            this.pushback(e);
            this.__graph();
            e = this.getNextEvent();
        }
        this.checkValid(e, 2, "node");
    }

    /*
     * Unable to fully structure code
     */
    private void __edge(boolean edgedefault) throws IOException, XMLStreamException {
        block15: {
            e = this.getNextEvent();
            this.checkValid(e, 1, "edge");
            attributes = e.asStartElement().getAttributes();
            sentAttributes = new HashSet<Key>();
            id = null;
            directed = edgedefault;
            source = null;
            target = null;
            while (attributes.hasNext()) {
                a = attributes.next();
                try {
                    attribute = EdgeAttribute.valueOf(this.toConstantName(a));
                    switch (FileSourceGraphML.$SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$EdgeAttribute()[attribute.ordinal()]) {
                        case 1: {
                            id = a.getValue();
                            break;
                        }
                        case 6: {
                            directed = Boolean.parseBoolean(a.getValue());
                            break;
                        }
                        case 2: {
                            source = a.getValue();
                            break;
                        }
                        case 4: {
                            target = a.getValue();
                            break;
                        }
                        case 3: 
                        case 5: {
                            throw this.newParseError(e, "sourceport and targetport not implemented", new Object[0]);
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw this.newParseError(e, "invalid graph attribute '%s'", new Object[]{a.getName().getLocalPart()});
                }
            }
            if (id == null) {
                throw this.newParseError(e, "edge must have an id", new Object[0]);
            }
            if (source == null || target == null) {
                throw this.newParseError(e, "edge must have a source and a target", new Object[0]);
            }
            this.sendEdgeAdded(this.sourceId, id, source, target, directed);
            e = this.getNextEvent();
            if (!this.isEvent(e, 1, "desc")) ** GOTO lbl48
            this.pushback(e);
            desc = this.__desc();
            this.sendEdgeAttributeAdded(this.sourceId, id, "desc", desc);
            break block15;
lbl-1000:
            // 1 sources

            {
                this.pushback(e);
                data = this.__data();
                this.sendEdgeAttributeAdded(this.sourceId, id, data.key.name, this.getValue(data));
                sentAttributes.add(data.key);
                e = this.getNextEvent();
lbl48:
                // 2 sources

                ** while (this.isEvent((XMLEvent)e, (int)1, (String)"data"))
            }
        }
        for (Key k : this.keys.values()) {
            if (k.domain != KeyDomain.EDGE && k.domain != KeyDomain.ALL || sentAttributes.contains(k)) continue;
            this.sendEdgeAttributeAdded(this.sourceId, id, k.name, this.getDefaultValue(k));
        }
        if (this.isEvent(e, 1, "graph")) {
            loc = e.getLocation();
            System.err.printf("[WARNING] %d:%d graph inside node is not implemented", new Object[]{loc.getLineNumber(), loc.getColumnNumber()});
            this.pushback(e);
            this.__graph();
            e = this.getNextEvent();
        }
        this.checkValid(e, 2, "edge");
    }

    /*
     * Unable to fully structure code
     */
    private void __hyperedge() throws IOException, XMLStreamException {
        block11: {
            e = this.getNextEvent();
            this.checkValid(e, 1, "hyperedge");
            loc = e.getLocation();
            System.err.printf("[WARNING] %d:%d hyperedge feature is not implemented", new Object[]{loc.getLineNumber(), loc.getColumnNumber()});
            id = null;
            attributes = e.asStartElement().getAttributes();
            while (attributes.hasNext()) {
                a = attributes.next();
                try {
                    attribute = HyperEdgeAttribute.valueOf(this.toConstantName(a));
                    switch (FileSourceGraphML.$SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$HyperEdgeAttribute()[attribute.ordinal()]) {
                        case 1: {
                            id = a.getValue();
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw this.newParseError(e, "invalid attribute '%s' for '<endpoint>'", new Object[]{a.getName().getLocalPart()});
                }
            }
            if (id == null) {
                throw this.newParseError(e, "'<hyperedge>' element requires a 'node' attribute", new Object[0]);
            }
            e = this.getNextEvent();
            if (!this.isEvent(e, 1, "desc")) ** GOTO lbl35
            this.pushback(e);
            this.__desc();
            break block11;
lbl-1000:
            // 1 sources

            {
                if (this.isEvent(e, 1, "data")) {
                    this.pushback(e);
                    this.__data();
                } else {
                    this.pushback(e);
                    this.__endpoint();
                }
                e = this.getNextEvent();
lbl35:
                // 2 sources

                ** while (this.isEvent((XMLEvent)e, (int)1, (String)"data") || this.isEvent((XMLEvent)e, (int)1, (String)"endpoint"))
            }
        }
        if (this.isEvent(e, 1, "graph")) {
            loc = e.getLocation();
            System.err.printf("[WARNING] %d:%d graph inside node is not implemented", new Object[]{loc.getLineNumber(), loc.getColumnNumber()});
            this.pushback(e);
            this.__graph();
            e = this.getNextEvent();
        }
        e = this.getNextEvent();
        this.checkValid(e, 2, "hyperedge");
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$PortAttribute() {
        if ($SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$PortAttribute != null) {
            return $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$PortAttribute;
        }
        int[] nArray = new int[PortAttribute.values().length];
        try {
            nArray[PortAttribute.NAME.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$PortAttribute = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$GraphAttribute() {
        if ($SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$GraphAttribute != null) {
            return $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$GraphAttribute;
        }
        int[] nArray = new int[GraphAttribute.values().length];
        try {
            nArray[GraphAttribute.EDGEDEFAULT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GraphAttribute.ID.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$GraphAttribute = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$NodeAttribute() {
        if ($SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$NodeAttribute != null) {
            return $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$NodeAttribute;
        }
        int[] nArray = new int[NodeAttribute.values().length];
        try {
            nArray[NodeAttribute.ID.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$NodeAttribute = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$EdgeAttribute() {
        if ($SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$EdgeAttribute != null) {
            return $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$EdgeAttribute;
        }
        int[] nArray = new int[EdgeAttribute.values().length];
        try {
            nArray[EdgeAttribute.DIRECTED.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdgeAttribute.ID.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdgeAttribute.SOURCE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdgeAttribute.SOURCEPORT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdgeAttribute.TARGET.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EdgeAttribute.TARGETPORT.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$EdgeAttribute = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$HyperEdgeAttribute() {
        if ($SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$HyperEdgeAttribute != null) {
            return $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$HyperEdgeAttribute;
        }
        int[] nArray = new int[HyperEdgeAttribute.values().length];
        try {
            nArray[HyperEdgeAttribute.ID.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$graphstream$stream$file$FileSourceGraphML$HyperEdgeAttribute = nArray;
        return nArray;
    }

    protected static enum Balise {
        GRAPHML,
        GRAPH,
        NODE,
        EDGE,
        HYPEREDGE,
        DESC,
        DATA,
        LOCATOR,
        PORT,
        KEY,
        DEFAULT;

    }

    protected static class Data {
        Key key;
        String id;
        String value;

        protected Data() {
        }
    }

    protected static enum DataAttribute {
        KEY,
        ID;

    }

    protected static enum EdgeAttribute {
        ID,
        SOURCE,
        SOURCEPORT,
        TARGET,
        TARGETPORT,
        DIRECTED;

    }

    protected static class EndPoint {
        String id = null;
        String node = null;
        String port = null;
        String desc = null;
        EndPointType type = EndPointType.UNDIR;

        EndPoint() {
        }
    }

    protected static enum EndPointAttribute {
        ID,
        NODE,
        PORT,
        TYPE;

    }

    protected static enum EndPointType {
        IN,
        OUT,
        UNDIR;

    }

    protected static enum GraphAttribute {
        ID,
        EDGEDEFAULT;

    }

    protected static enum HyperEdgeAttribute {
        ID;

    }

    protected static class Key {
        KeyDomain domain = KeyDomain.ALL;
        String name = null;
        KeyAttrType type = KeyAttrType.STRING;
        String def = null;

        Key() {
        }

        Object getKeyValue(String value) {
            if (value == null) {
                return null;
            }
            switch (this.type) {
                case STRING: {
                    return value;
                }
                case INT: {
                    return Integer.valueOf(value);
                }
                case LONG: {
                    return Long.valueOf(value);
                }
                case FLOAT: {
                    return Float.valueOf(value);
                }
                case DOUBLE: {
                    return Double.valueOf(value);
                }
                case BOOLEAN: {
                    return Boolean.valueOf(value);
                }
            }
            return value;
        }

        Object getDefaultValue() {
            return this.getKeyValue(this.def);
        }
    }

    protected static enum KeyAttrType {
        BOOLEAN,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        STRING;

    }

    protected static enum KeyAttribute {
        ID,
        FOR,
        ATTR_NAME,
        ATTR_TYPE;

    }

    protected static enum KeyDomain {
        GRAPHML,
        GRAPH,
        NODE,
        EDGE,
        HYPEREDGE,
        PORT,
        ENDPOINT,
        ALL;

    }

    protected static class Locator {
        String href = null;
        String xlink = "http://www.w3.org/TR/2000/PR-xlink-20001220/";
        String type = "simple";

        Locator() {
        }
    }

    protected static enum LocatorAttribute {
        XMLNS_XLINK,
        XLINK_HREF,
        XLINK_TYPE;

    }

    protected static enum NodeAttribute {
        ID;

    }

    protected static class Port {
        String name = null;
        String desc = null;
        LinkedList<Data> datas = new LinkedList();
        LinkedList<Port> ports = new LinkedList();

        Port() {
        }
    }

    protected static enum PortAttribute {
        NAME;

    }
}

