/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.test;

import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.file.FileSourceGML;
import org.graphstream.stream.file.test.TestFileSourceBase;
import org.junit.Before;

public class TestFileSourceGML
extends TestFileSourceBase {
    protected static String TEST1_TRIANGLE = "graph [\n    id \"test1\"\n    node [ id \"A\" ]\n    node [ id \"B\" ]\n    node [ id \"C\" ]\n    edge [ id \"AB\" source \"A\" target \"B\" ]\n    edge [ id \"BC\" source \"B\" target \"C\" ]\n    edge [ id \"CA\" source \"C\" target \"A\" ]\n]\n";
    protected static String TEST2_DIRECTED_TRIANGLE = "graph [\n    id \"test1\"\n    node [ id \"A\" ]\n    node [ id \"B\" ]\n    node [ id \"C\" ]\n    edge [ id \"AB\" source \"A\" target \"B\" directed 1 ]\n    edge [ id \"BC\" source \"B\" target \"C\" directed 0 ]\n    edge [ id \"CA\" source \"A\" target \"C\" directed true ]\n]\n";
    protected static String TEST3_ATTRIBUTES = "graph [\n    id \"test1\"\n    node [ id \"A\" a 1 b truc c true ]\n    node [ id \"B\" aa \"1,2,3,4\" bb \"foo\" cc bar ]\n    node [ id \"C\" aaa 1.234 ]\n    edge [ id \"AB\" source \"A\" target \"B\" ]\n    edge [ id \"BC\" source \"B\" target \"C\" ]\n    edge [ id \"CA\" source \"C\" target \"A\" ]\n]\n";

    @Before
    public void setUp() {
        this.graph = new MultiGraph("g1");
        this.input = new FileSourceGML();
    }

    @Override
    public String anUndirectedTriangle() {
        return TEST1_TRIANGLE;
    }

    @Override
    public String aDirectedTriangle() {
        return TEST2_DIRECTED_TRIANGLE;
    }

    @Override
    public String basicAttributes() {
        return TEST3_ATTRIBUTES;
    }

    @Override
    public String anUndirectedTriangleFileName() {
        return "src-test/org/graphstream/stream/file/test/data/undirectedTriangle.gml";
    }

    @Override
    public String anUndirectedTriangleHttpURL() {
        return "http://graphstream-project.org/media/data/undirectedTriangle.gml";
    }
}

