/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.test;

import java.io.IOException;
import org.graphstream.graph.Graph;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.stream.file.FileSourceGEXF;
import org.junit.Assert;
import org.junit.Test;

public class TestFileSourceGEXF {
    protected Graph readRessource(String url) {
        AdjacencyListGraph g = new AdjacencyListGraph(url);
        FileSourceGEXF gexf = new FileSourceGEXF();
        gexf.addSink(g);
        try {
            gexf.readAll(this.getClass().getResourceAsStream(url));
        }
        catch (IOException e) {
            Assert.fail((String)"IOException occured");
        }
        gexf.removeSink(g);
        return g;
    }

    @Test
    public void testBasic() {
        Graph g = this.readRessource("data/basic.gexf");
        Assert.assertNotNull(g.getNode("0"));
        Assert.assertNotNull(g.getNode("1"));
        Assert.assertNotNull(g.getEdge("0"));
        Assert.assertEquals((Object)g.getEdge("0").getSourceNode().getId(), (Object)"0");
        Assert.assertEquals((Object)g.getEdge("0").getTargetNode().getId(), (Object)"1");
        Assert.assertTrue((boolean)g.getNode("0").hasLabel("label"));
        Assert.assertTrue((boolean)g.getNode("1").hasLabel("label"));
        Assert.assertEquals((Object)g.getNode("0").getLabel("label"), (Object)"Hello");
        Assert.assertEquals((Object)g.getNode("1").getLabel("label"), (Object)"Word");
        Assert.assertTrue((boolean)g.getEdge("0").isDirected());
    }

    @Test
    public void testData() {
        Graph g = this.readRessource("data/data.gexf");
        String[] nodeLabels = new String[]{"Gephi", "Webatlas", "RTGI", "BarabasiLab"};
        String[] edges = new String[]{"0", "1", "0", "2", "1", "0", "2", "1", "0", "3"};
        String[] urlValues = new String[]{"http://gephi.org", "http://webatlas.fr", "http://rtgi.fr", "http://barabasilab.com"};
        Float[] indegreeValues = new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)};
        Boolean[] frogValues = new Boolean[]{true, true, true, false};
        Assert.assertEquals(g.getAttribute("lastmodifieddate"), (Object)"2009-03-20");
        Assert.assertEquals(g.getAttribute("creator"), (Object)"Gephi.org");
        Assert.assertEquals(g.getAttribute("description"), (Object)"A Web network");
        int i = 0;
        while (i < 4) {
            String nid = Integer.toString(i);
            Assert.assertNotNull(g.getNode(nid));
            Assert.assertTrue((boolean)g.getNode(nid).hasLabel("label"));
            Assert.assertEquals((Object)g.getNode(nid).getLabel("label"), (Object)nodeLabels[i]);
            Assert.assertEquals(g.getNode(nid).getAttribute("url"), (Object)urlValues[i]);
            Assert.assertEquals(g.getNode(nid).getAttribute("indegree"), (Object)indegreeValues[i]);
            Assert.assertEquals(g.getNode(nid).getAttribute("frog"), (Object)frogValues[i]);
            ++i;
        }
        i = 0;
        while (i < 5) {
            String eid = Integer.toString(i);
            Assert.assertNotNull(g.getEdge(eid));
            Assert.assertTrue((boolean)g.getEdge(eid).isDirected());
            Assert.assertEquals((Object)g.getEdge(eid).getSourceNode().getId(), (Object)edges[2 * i]);
            Assert.assertEquals((Object)g.getEdge(eid).getTargetNode().getId(), (Object)edges[2 * i + 1]);
            ++i;
        }
    }
}

