/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.graphstream.util.Logger;

public class Environment
implements Cloneable {
    protected String configFileName = "config";
    protected boolean configFileRead = false;
    protected Hashtable<String, String> parameters = new Hashtable();
    protected boolean locked;
    public static Environment GLOBAL_ENV;

    public static Environment getGlobalEnvironment() {
        if (GLOBAL_ENV == null) {
            GLOBAL_ENV = new Environment();
        }
        return GLOBAL_ENV;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public String getParameter(String parameter) {
        String p = this.parameters.get(parameter);
        return p == null ? "" : p;
    }

    public boolean hasParameter(String parameter) {
        return this.parameters.get(parameter) != null;
    }

    public boolean getBooleanParameter(String parameter) {
        int val = this.getBooleanParameteri(parameter);
        return val == 1;
    }

    public int getBooleanParameteri(String parameter) {
        String p = this.parameters.get(parameter);
        if (p != null) {
            if ((p = p.toLowerCase()).equals("1")) {
                return 1;
            }
            if (p.equals("true")) {
                return 1;
            }
            if (p.equals("on")) {
                return 1;
            }
            if (p.equals("yes")) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public double getNumberParameter(String parameter) {
        String p = this.parameters.get(parameter);
        if (p != null) {
            try {
                return Double.parseDouble(p);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public int getParameterCount() {
        return this.parameters.size();
    }

    public Set<String> getParametersKeySet() {
        return this.parameters.keySet();
    }

    public Environment clone() {
        Environment e = new Environment();
        e.configFileName = this.configFileName;
        e.configFileRead = this.configFileRead;
        e.locked = this.locked;
        for (String key : this.parameters.keySet()) {
            e.parameters.put(key, this.parameters.get(key));
        }
        return e;
    }

    public void setParameter(String parameter, String value) {
        if (!this.locked) {
            this.parameters.put(parameter, value);
        } else if (this.parameters.get(parameter) != null) {
            this.parameters.put(parameter, value);
        }
    }

    public void lockEnvironment(boolean on) {
        this.locked = on;
    }

    public void initializeFieldsOf(Object object) {
        Method[] methods;
        Method[] methodArray = methods = object.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            String value;
            Class<?>[] types;
            Method method = methodArray[n2];
            if (method.getName().startsWith("set") && (types = method.getParameterTypes()).length == 1 && (value = this.parameters.get(name = String.valueOf(method.getName().substring(3, 4).toLowerCase()) + method.getName().substring(4))) != null) {
                this.invokeSetMethod(object, method, types, name, value);
            }
            ++n2;
        }
    }

    public void initializeFieldsOf(Object object, String ... fieldList) {
        Method[] methods = object.getClass().getMethods();
        HashSet<String> names = new HashSet<String>();
        Object[] objectArray = fieldList;
        int n = fieldList.length;
        int n2 = 0;
        while (n2 < n) {
            String s = objectArray[n2];
            names.add(s);
            ++n2;
        }
        objectArray = methods;
        n = methods.length;
        n2 = 0;
        while (n2 < n) {
            String value;
            String name;
            Class<?>[] types;
            Object method = objectArray[n2];
            if (((Method)method).getName().startsWith("set") && (types = ((Method)method).getParameterTypes()).length == 1 && names.contains(name = String.valueOf(((Method)method).getName().substring(3, 4).toLowerCase()) + ((Method)method).getName().substring(4)) && (value = this.parameters.get(name)) != null) {
                this.invokeSetMethod(object, (Method)method, types, name, value);
            }
            ++n2;
        }
    }

    protected void initializeFieldsOf(Object object, Collection<String> fieldList) {
        Method[] methods;
        Method[] methodArray = methods = object.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            String name;
            Class<?>[] types;
            Method method = methodArray[n2];
            if (method.getName().startsWith("set") && (types = method.getParameterTypes()).length == 1 && fieldList.contains(name = method.getName().substring(3).toLowerCase()) && (value = this.parameters.get(name)) != null) {
                this.invokeSetMethod(object, method, types, name, value);
            }
            ++n2;
        }
    }

    protected void invokeSetMethod(Object object, Method method, Class<?>[] types, String name, String value) {
        try {
            if (types[0] == Long.TYPE) {
                try {
                    long val = Long.parseLong(value);
                    method.invoke(object, new Long(val));
                }
                catch (NumberFormatException e) {
                    Logger.getGlobalLogger().log(Logger.LogLevel.WARN, this.getClass().getName(), "cannot set '%s' to the value '%s', values is not a long%n", method.toString(), value);
                }
            } else if (types[0] == Integer.TYPE) {
                try {
                    int val = (int)Double.parseDouble(value);
                    method.invoke(object, new Integer(val));
                }
                catch (NumberFormatException e) {
                    Logger.getGlobalLogger().log(Logger.LogLevel.WARN, this.getClass().getName(), "cannot set '%s' to the value '%s', values is not a int%n", method.toString(), value);
                }
            } else if (types[0] == Double.TYPE) {
                try {
                    double val = Double.parseDouble(value);
                    method.invoke(object, new Double(val));
                }
                catch (NumberFormatException e) {
                    Logger.getGlobalLogger().log(Logger.LogLevel.WARN, this.getClass().getName(), "cannot set '%s' to the value '%s', values is not a double%n", method.toString(), value);
                }
            } else if (types[0] == Float.TYPE) {
                try {
                    float val = Float.parseFloat(value);
                    method.invoke(object, new Float(val));
                }
                catch (NumberFormatException e) {
                    Logger.getGlobalLogger().log(Logger.LogLevel.WARN, this.getClass().getName(), "cannot set '%s' to the value '%s', values is not a float%n", method.toString(), value);
                }
            } else if (types[0] == Boolean.TYPE) {
                try {
                    boolean val = false;
                    value = value.toLowerCase();
                    if (value.equals("1") || value.equals("true") || value.equals("yes") || value.equals("on")) {
                        val = true;
                    }
                    method.invoke(object, new Boolean(val));
                }
                catch (NumberFormatException e) {
                    Logger.getGlobalLogger().log(Logger.LogLevel.WARN, this.getClass().getName(), "cannot set '%s' to the value '%s', values is not a boolean%n", method.toString(), value);
                }
            } else if (types[0] == String.class) {
                method.invoke(object, value);
            } else {
                Logger.getGlobalLogger().log(Logger.LogLevel.WARN, this.getClass().getName(), "cannot match parameter '%s' and the method '%s'%n", value, method.toString());
            }
        }
        catch (InvocationTargetException ite) {
            Logger.getGlobalLogger().log(Logger.LogLevel.WARN, this.getClass().getName(), "cannot invoke method '%s' : invocation targer error : %s%n", method.toString(), ite.getMessage());
        }
        catch (IllegalAccessException iae) {
            Logger.getGlobalLogger().log(Logger.LogLevel.WARN, this.getClass().getName(), "cannot invoke method '%s' : illegal access error : %s%n", method.toString(), iae.getMessage());
        }
    }

    public void printParameters(PrintStream out) {
        out.println(this.toString());
    }

    public void printParameters() {
        this.printParameters(System.out);
    }

    public String toString() {
        return this.parameters.toString();
    }

    public void readCommandLine(String[] args) {
        this.readCommandLine(args, null);
    }

    public void readCommandLine(String[] args, Collection<String> trashcan) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            boolean startsWithMinus = arg.startsWith("-");
            int equalPos = arg.indexOf(61);
            String value = "true";
            if (equalPos >= 0) {
                value = arg.substring(equalPos + 1);
                arg = startsWithMinus ? arg.substring(1, equalPos) : arg.substring(0, equalPos);
                this.parameters.put(arg, value);
            } else if (startsWithMinus) {
                arg = arg.substring(1);
                this.parameters.put(arg, value);
            } else {
                this.readConfigFile(arg, trashcan);
            }
            ++n2;
        }
    }

    protected void readConfigFile(String filename, Collection<String> trashcan) {
        int count = 0;
        try {
            String str;
            BufferedReader br = new BufferedReader(new FileReader(filename));
            while ((str = br.readLine()) != null) {
                ++count;
                if (str.length() <= 0 || str.substring(0, 1).equals("#")) continue;
                String[] val = str.split("=");
                if (val.length != 2) {
                    if (val.length == 1) {
                        this.parameters.put(val[0].trim(), "true");
                        continue;
                    }
                    System.err.printf("Something is wrong with the configuration file \"%s\"near line %d :\n %s", filename, count, str);
                    if (trashcan == null) continue;
                    trashcan.add(str);
                    continue;
                }
                String s0 = val[0].trim();
                String s1 = val[1].trim();
                this.parameters.put(s0, s1);
            }
        }
        catch (FileNotFoundException fnfe) {
            System.err.printf("Tried to open \"%s\" as a config file: file not found.%n", filename);
            if (trashcan != null) {
                trashcan.add(filename);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(0);
        }
    }

    public void writeParameterFile(String fileName) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(fileName));
        Set<String> ks = this.parameters.keySet();
        for (String key : ks) {
            bw.write(String.valueOf(key) + " = " + this.parameters.get(key));
            bw.newLine();
        }
        bw.close();
    }

    protected void readConfigurationFile() {
        try {
            this.readParameterFile(this.configFileName);
            this.configFileRead = true;
        }
        catch (IOException ioe) {
            System.err.printf("%-5s : %s : %s\n", "Warning", "Environment", "Something wrong while reading the configuration file");
        }
    }

    public void readParameterFile(String fileName) throws IOException {
        String str;
        int count = 0;
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        while ((str = br.readLine()) != null) {
            ++count;
            if (str.length() <= 0 || str.startsWith("#")) continue;
            Object[] val = str.split("=");
            if (val.length != 2) {
                System.err.printf("%-5s : %s : %s\n", "Warn", "Environment", "Something is wrong in your configuration file near line " + count + " : \n" + Arrays.toString(val));
                continue;
            }
            String s0 = val[0].trim();
            String s1 = val[1].trim();
            this.setParameter(s0, s1);
        }
        br.close();
    }
}

