/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.graphstream.graph.CompoundAttribute;
import org.graphstream.graph.NullAttributeException;
import org.graphstream.graph.implementations.MultiGraph;
import org.junit.Assert;
import org.junit.Test;

public class TestElement {
    @Test(expected=NullAttributeException.class)
    public void testElementSimpleAttributes() {
        MultiGraph graph = new MultiGraph("g1");
        Object A = graph.addNode("A");
        Assert.assertEquals((Object)"A", (Object)A.getId());
        Assert.assertEquals((long)0L, (long)A.getAttributeCount());
        A.addAttribute("foo", new Object[0]);
        Assert.assertEquals((long)1L, (long)A.getAttributeCount());
        Assert.assertTrue((boolean)A.hasAttribute("foo"));
        Assert.assertTrue((boolean)A.hasAttribute("foo", Boolean.class));
        Assert.assertFalse((boolean)A.hasLabel("foo"));
        Assert.assertFalse((boolean)A.hasNumber("foo"));
        Assert.assertFalse((boolean)A.hasVector("foo"));
        Assert.assertFalse((boolean)A.hasArray("foo"));
        Assert.assertFalse((boolean)A.hasHash("foo"));
        Assert.assertNotNull(A.getAttribute("foo"));
        Assert.assertEquals((Object)true, A.getAttribute("foo"));
        Assert.assertEquals((Object)Boolean.TRUE, A.getAttribute("foo"));
        A.changeAttribute("foo", false);
        Assert.assertEquals((long)1L, (long)A.getAttributeCount());
        Assert.assertTrue((boolean)A.hasAttribute("foo"));
        Assert.assertTrue((boolean)A.hasAttribute("foo", Boolean.class));
        Assert.assertFalse((boolean)A.hasLabel("foo"));
        Assert.assertFalse((boolean)A.hasNumber("foo"));
        Assert.assertFalse((boolean)A.hasVector("foo"));
        Assert.assertFalse((boolean)A.hasArray("foo"));
        Assert.assertFalse((boolean)A.hasHash("foo"));
        Assert.assertNotNull(A.getAttribute("foo"));
        Assert.assertEquals((Object)false, A.getAttribute("foo"));
        Assert.assertEquals((Object)Boolean.FALSE, A.getAttribute("foo"));
        A.removeAttribute("foo");
        Assert.assertEquals((long)0L, (long)A.getAttributeCount());
        Assert.assertFalse((boolean)A.hasAttribute("foo"));
        Assert.assertNull(A.getAttribute("foo"));
        Assert.assertFalse((boolean)graph.nullAttributesAreErrors());
        graph.setNullAttributesAreErrors(true);
        Assert.assertTrue((boolean)graph.nullAttributesAreErrors());
        A.getAttribute("foo");
    }

    @Test
    public void testElementValueAttributes() {
        MultiGraph graph = new MultiGraph("g1");
        Object A = graph.addNode("A");
        Assert.assertEquals((Object)"A", (Object)A.getId());
        Assert.assertEquals((long)0L, (long)A.getAttributeCount());
        A.addAttribute("foo", "bar");
        Assert.assertEquals((long)1L, (long)A.getAttributeCount());
        Assert.assertTrue((boolean)A.hasAttribute("foo"));
        Assert.assertTrue((boolean)A.hasAttribute("foo", String.class));
        Assert.assertTrue((boolean)A.hasLabel("foo"));
        Assert.assertFalse((boolean)A.hasNumber("foo"));
        Assert.assertFalse((boolean)A.hasVector("foo"));
        Assert.assertFalse((boolean)A.hasArray("foo"));
        Assert.assertFalse((boolean)A.hasHash("foo"));
        Assert.assertNotNull(A.getAttribute("foo"));
        Assert.assertEquals((Object)"bar", A.getAttribute("foo"));
        A.addAttribute("pi", 3.1415);
        Assert.assertEquals((long)2L, (long)A.getAttributeCount());
        Assert.assertTrue((boolean)A.hasAttribute("pi"));
        Assert.assertTrue((boolean)A.hasAttribute("pi", Number.class));
        Assert.assertFalse((boolean)A.hasLabel("pi"));
        Assert.assertTrue((boolean)A.hasNumber("pi"));
        Assert.assertFalse((boolean)A.hasVector("pi"));
        Assert.assertFalse((boolean)A.hasArray("pi"));
        Assert.assertFalse((boolean)A.hasHash("pi"));
        Assert.assertNotNull(A.getAttribute("pi"));
        Assert.assertEquals((Object)3.1415, A.getAttribute("pi"));
        Assert.assertEquals((Object)new Double(3.1415), A.getAttribute("pi"));
        A.setAttribute("pi", "3.1415");
        Assert.assertEquals((double)3.1415, (double)A.getNumber("pi"), (double)0.0);
        ArrayList<Number> numbers = new ArrayList<Number>();
        numbers.add(3);
        numbers.add(1.4);
        numbers.add(Float.valueOf(1.5f));
        A.addAttribute("v", numbers);
        Assert.assertEquals((long)3L, (long)A.getAttributeCount());
        Assert.assertTrue((boolean)A.hasAttribute("v"));
        Assert.assertTrue((boolean)A.hasAttribute("v", ArrayList.class));
        Assert.assertFalse((boolean)A.hasLabel("v"));
        Assert.assertFalse((boolean)A.hasNumber("v"));
        Assert.assertTrue((boolean)A.hasVector("v"));
        Assert.assertFalse((boolean)A.hasArray("v"));
        Assert.assertFalse((boolean)A.hasHash("v"));
        Assert.assertNotNull(A.getAttribute("v"));
        Assert.assertEquals(numbers, A.getAttribute("v"));
        Assert.assertEquals(numbers, A.getVector("v"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "a");
        map.put("B", "b");
        map.put("C", "c");
        A.addAttribute("map", map);
        Assert.assertEquals((long)4L, (long)A.getAttributeCount());
        Assert.assertTrue((boolean)A.hasAttribute("map"));
        Assert.assertTrue((boolean)A.hasAttribute("map", HashMap.class));
        Assert.assertFalse((boolean)A.hasLabel("map"));
        Assert.assertFalse((boolean)A.hasNumber("map"));
        Assert.assertFalse((boolean)A.hasVector("map"));
        Assert.assertFalse((boolean)A.hasArray("map"));
        Assert.assertTrue((boolean)A.hasHash("map"));
        Assert.assertNotNull(A.getAttribute("map"));
        Assert.assertEquals(map, A.getAttribute("map"));
        Assert.assertEquals(map, A.getHash("map"));
        MyAttribute attr = new MyAttribute();
        attr.put("A", "a");
        attr.put("B", "b");
        attr.put("C", "c");
        A.addAttribute("ca", attr);
        Assert.assertEquals((long)5L, (long)A.getAttributeCount());
        Assert.assertTrue((boolean)A.hasAttribute("ca"));
        Assert.assertTrue((boolean)A.hasAttribute("ca", MyAttribute.class));
        Assert.assertFalse((boolean)A.hasLabel("ca"));
        Assert.assertFalse((boolean)A.hasNumber("ca"));
        Assert.assertFalse((boolean)A.hasVector("ca"));
        Assert.assertFalse((boolean)A.hasArray("ca"));
        Assert.assertTrue((boolean)A.hasHash("ca"));
        Assert.assertNotNull(A.getAttribute("ca"));
        Assert.assertEquals((Object)attr, A.getAttribute("ca"));
        Assert.assertEquals((Object)attr, A.getHash("ca"));
        A.clearAttributes();
        Assert.assertEquals((long)0L, (long)A.getAttributeCount());
    }

    @Test(expected=NullAttributeException.class)
    public void testElementValueAttributeNull1() {
        MultiGraph graph = new MultiGraph("g");
        graph.setNullAttributesAreErrors(true);
        graph.getAttribute("nonExisting");
    }

    @Test(expected=NullAttributeException.class)
    public void testElementValueAttributeNull2() {
        MultiGraph graph = new MultiGraph("g");
        graph.setNullAttributesAreErrors(true);
        graph.getFirstAttributeOf("nonExisting", "nonExisting2", "nonExisting3");
    }

    @Test(expected=NullAttributeException.class)
    public void testElementValueAttributeNull3() {
        MultiGraph graph = new MultiGraph("g");
        graph.setNullAttributesAreErrors(true);
        graph.getNumber("foo");
    }

    @Test(expected=NullAttributeException.class)
    public void testElementValueAttributeNull4() {
        MultiGraph graph = new MultiGraph("g");
        graph.setNullAttributesAreErrors(true);
        graph.addAttribute("foo", "ah ah ah");
        graph.getNumber("foo");
    }

    @Test(expected=NullAttributeException.class)
    public void testElementValueAttributeNull5() {
        MultiGraph graph = new MultiGraph("g");
        graph.setNullAttributesAreErrors(true);
        graph.getLabel("foo");
    }

    @Test(expected=NullAttributeException.class)
    public void testElementValueAttributeNull6() {
        MultiGraph graph = new MultiGraph("g");
        graph.setNullAttributesAreErrors(true);
        graph.addAttribute("foo", 5);
        graph.getLabel("foo");
    }

    @Test
    public void testElementMultiAttributes() {
        MultiGraph graph = new MultiGraph("g1");
        Object A = graph.addNode("A");
        Assert.assertEquals((Object)"A", (Object)A.getId());
        Assert.assertEquals((long)0L, (long)A.getAttributeCount());
        A.addAttribute("array", 0, 1.1, Float.valueOf(1.3f), "foo");
        Object[] expected = new Object[]{0, 1.1, Float.valueOf(1.3f), "foo"};
        Assert.assertEquals((long)1L, (long)A.getAttributeCount());
        Assert.assertTrue((boolean)A.hasAttribute("array"));
        Assert.assertTrue((boolean)A.hasAttribute("array", Object[].class));
        Assert.assertFalse((boolean)A.hasLabel("array"));
        Assert.assertFalse((boolean)A.hasNumber("array"));
        Assert.assertFalse((boolean)A.hasVector("array"));
        Assert.assertTrue((boolean)A.hasArray("array"));
        Assert.assertFalse((boolean)A.hasHash("array"));
        Assert.assertArrayEquals((Object[])expected, (Object[])((Object[])A.getAttribute("array")));
        Assert.assertArrayEquals((Object[])expected, (Object[])A.getArray("array"));
        Assert.assertNotNull(A.getAttribute("array"));
    }

    @Test
    public void testElementUtilityMethods() {
        MultiGraph graph = new MultiGraph("g1");
        Number A = graph.addNode("A");
        Assert.assertEquals((Object)"A", (Object)A.getId());
        Assert.assertEquals((long)0L, (long)A.getAttributeCount());
        A.addAttribute("C", "c");
        A.addAttribute("I", "i");
        A.addAttribute("Z", "z");
        String s = (String)A.getFirstAttributeOf("A", "B", "C", "I", "Z");
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((Object)"c", (Object)s);
        A.addAttribute("J", 1);
        A.addAttribute("X", 2);
        Number n = A.getFirstAttributeOf(Number.class, "A", "B", "C", "I", "J", "X", "Z");
        Assert.assertNotNull((Object)n);
        Assert.assertEquals((Object)1, (Object)n);
    }

    @Test
    public void testElementIterables() {
        MultiGraph graph = new MultiGraph("g1");
        Object A = graph.addNode("A");
        Assert.assertEquals((Object)"A", (Object)A.getId());
        Assert.assertEquals((long)0L, (long)A.getAttributeCount());
        A.addAttribute("A", "a");
        A.addAttribute("B", "b");
        A.addAttribute("C", "c");
        Assert.assertEquals((long)3L, (long)A.getAttributeCount());
        HashSet<String> keys = new HashSet<String>();
        for (String key : A.getAttributeKeySet()) {
            keys.add(key);
        }
        Assert.assertEquals((long)3L, (long)keys.size());
        Assert.assertTrue((boolean)keys.contains("A"));
        Assert.assertTrue((boolean)keys.contains("B"));
        Assert.assertTrue((boolean)keys.contains("C"));
    }

    @Test
    public void testNullAttributes() {
        MultiGraph graph = new MultiGraph("g1");
        graph.addAttribute("foo", new Object[0]);
        graph.addAttribute("bar", new Object[]{null});
        Assert.assertTrue((boolean)graph.hasAttribute("foo"));
        Assert.assertTrue((boolean)graph.hasAttribute("bar"));
        graph.removeAttribute("foo");
        graph.removeAttribute("bar");
        Assert.assertFalse((boolean)graph.hasAttribute("foo"));
        Assert.assertFalse((boolean)graph.hasAttribute("bar"));
    }

    protected static class MyAttribute
    extends HashMap<String, String>
    implements CompoundAttribute {
        private static final long serialVersionUID = 1L;

        protected MyAttribute() {
        }

        @Override
        public String getKey() {
            return "MyAttribute";
        }

        @Override
        public HashMap<?, ?> toHashMap() {
            return this;
        }
    }
}

