/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.test;

import java.io.IOException;
import java.io.StringReader;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.file.FileSourceEdge;
import org.graphstream.stream.file.test.TestFileSourceBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFileSourceEdge
extends TestFileSourceBase {
    protected static String TEST1_TRIANGLE = "A B\nB C\nC A\n";
    protected static String TEST2_DIRECTED_TRIANGLE = "A B\nB C\nA C\n";

    @Before
    public void setUp() {
        this.graph = new MultiGraph("g1");
        this.input = new FileSourceEdge();
        this.testEdgeIds = false;
    }

    public static void main(String[] args) {
        TestFileSourceEdge fid = new TestFileSourceEdge();
        fid.setUp();
        fid.test_Access_ReadAll_Stream();
    }

    @Override
    public String anUndirectedTriangle() {
        return TEST1_TRIANGLE;
    }

    @Override
    public String aDirectedTriangle() {
        return TEST2_DIRECTED_TRIANGLE;
    }

    @Override
    public String basicAttributes() {
        return "";
    }

    @Override
    @Test
    public void test_DirectedTriangle() {
        this.input = new FileSourceEdge(true);
        try {
            this.input.addSink(this.graph);
            this.input.readAll(new StringReader(this.aDirectedTriangle()));
            String BCid = this.graph.getNode("B").getEdgeToward("C").getId();
            this.graph.removeEdge(BCid);
            this.graph.addEdge(BCid, "B", "C", false);
            this.directedTriangleTests();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((String)("IOException, should not happen" + e.getMessage()), (boolean)false);
        }
    }

    @Override
    @Test
    public void test_Attributes() {
    }

    @Override
    public String anUndirectedTriangleFileName() {
        return "src-test/org/graphstream/stream/file/test/data/undirectedTriangle.edge";
    }

    @Override
    public String anUndirectedTriangleHttpURL() {
        return "http://graphstream-project.org/media/data/undirectedTriangle.edge";
    }
}

