/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.dgs;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.graphstream.stream.file.FileSourceBase;

public class OldFileSourceDGS
extends FileSourceBase {
    protected int version;
    protected String graphName;
    protected int stepCountAnnounced;
    protected int eventCountAnnounced;
    protected int stepCount;
    protected int eventCount;
    protected HashMap<String, Object> attributes = new HashMap();
    protected boolean finished;

    public OldFileSourceDGS() {
        super(true);
    }

    @Override
    public boolean nextEvents() throws IOException {
        if (this.finished) {
            return false;
        }
        return this.next(false, false);
    }

    @Override
    public boolean nextStep() throws IOException {
        if (this.finished) {
            return false;
        }
        return this.next(true, false);
    }

    protected boolean next(boolean readSteps, boolean stop) throws IOException {
        String key = null;
        boolean loop = readSteps;
        do {
            if ((key = this.getWordOrSymbolOrStringOrEolOrEof()).equals("ce")) {
                this.readCE();
                continue;
            }
            if (key.equals("cn")) {
                this.readCN();
                continue;
            }
            if (key.equals("ae")) {
                this.readAE();
                continue;
            }
            if (key.equals("an")) {
                this.readAN();
                continue;
            }
            if (key.equals("de")) {
                this.readDE();
                continue;
            }
            if (key.equals("dn")) {
                this.readDN();
                continue;
            }
            if (key.equals("cg")) {
                this.readCG();
                continue;
            }
            if (key.equals("st")) {
                if (readSteps) {
                    if (stop) {
                        loop = false;
                        this.pushBack();
                        continue;
                    }
                    stop = true;
                    this.readST();
                    continue;
                }
                this.readST();
                continue;
            }
            if (key.equals("#")) {
                this.eatAllUntilEol();
                return this.next(readSteps, stop);
            }
            if (key.equals("EOL")) {
                return this.next(readSteps, stop);
            }
            if (key.equals("EOF")) {
                this.finished = true;
                return false;
            }
            this.parseError("unknown token '" + key + "'");
        } while (loop);
        return true;
    }

    protected void readCE() throws IOException {
        String tag = this.getStringOrWordOrNumber();
        this.readAttributes(this.attributes);
        for (String key : this.attributes.keySet()) {
            Object value = this.attributes.get(key);
            if (value == null) {
                this.sendEdgeAttributeRemoved(this.graphName, tag, key);
                continue;
            }
            this.sendEdgeAttributeChanged(this.graphName, tag, key, null, value);
        }
        if (this.eatEolOrEof() == -1) {
            this.pushBack();
        }
    }

    protected void readCN() throws IOException {
        String tag = this.getStringOrWordOrNumber();
        this.readAttributes(this.attributes);
        for (String key : this.attributes.keySet()) {
            Object value = this.attributes.get(key);
            if (value == null) {
                this.sendNodeAttributeRemoved(this.graphName, tag, key);
                continue;
            }
            this.sendNodeAttributeChanged(this.graphName, tag, key, null, value);
        }
        if (this.eatEolOrEof() == -1) {
            this.pushBack();
        }
    }

    protected void readCG() throws IOException {
        this.readAttributes(this.attributes);
        for (String key : this.attributes.keySet()) {
            Object value = this.attributes.get(key);
            if (value == null) {
                this.sendGraphAttributeRemoved(this.graphName, key);
                continue;
            }
            this.sendGraphAttributeChanged(this.graphName, key, null, value);
        }
        if (this.eatEolOrEof() == -1) {
            this.pushBack();
        }
    }

    protected void readAE() throws IOException {
        int dir = 0;
        boolean directed = false;
        String dirc = null;
        String tag = null;
        String fromTag = null;
        String toTag = null;
        tag = this.getStringOrWordOrNumber();
        fromTag = this.getStringOrWordOrNumber();
        dirc = this.getWordOrSymbolOrNumberOrStringOrEolOrEof();
        if (dirc.equals(">")) {
            directed = true;
            dir = 1;
        } else if (dirc.equals("<")) {
            directed = true;
            dir = 2;
        } else {
            this.pushBack();
        }
        toTag = this.getStringOrWordOrNumber();
        if (dir == 2) {
            String tmp = toTag;
            toTag = fromTag;
            fromTag = tmp;
        }
        this.readAttributes(this.attributes);
        this.sendEdgeAdded(this.graphName, tag, fromTag, toTag, directed);
        for (String key : this.attributes.keySet()) {
            Object value = this.attributes.get(key);
            this.sendEdgeAttributeAdded(this.graphName, tag, key, value);
        }
        if (this.eatEolOrEof() == -1) {
            this.pushBack();
        }
    }

    protected void readAN() throws IOException {
        String tag = this.getStringOrWordOrNumber();
        this.readAttributes(this.attributes);
        this.sendNodeAdded(this.graphName, tag);
        for (String key : this.attributes.keySet()) {
            Object value = this.attributes.get(key);
            this.sendNodeAttributeAdded(this.graphName, tag, key, value);
        }
        if (this.eatEolOrEof() == -1) {
            this.pushBack();
        }
    }

    protected void readDE() throws IOException {
        String tag = this.getStringOrWordOrNumber();
        this.sendEdgeRemoved(this.graphName, tag);
        if (this.eatEolOrEof() == -1) {
            this.pushBack();
        }
    }

    protected void readDN() throws IOException {
        String tag = this.getStringOrWordOrNumber();
        this.sendNodeRemoved(this.graphName, tag);
        if (this.eatEolOrEof() == -1) {
            this.pushBack();
        }
    }

    protected void readST() throws IOException {
        String w = this.getWordOrNumber();
        try {
            double time = Double.parseDouble(w);
            this.sendStepBegins(this.graphName, time);
        }
        catch (NumberFormatException e) {
            this.parseError("expecting a number after `st', got `" + w + "'");
        }
        if (this.eatEolOrEof() == -1) {
            this.pushBack();
        }
    }

    protected void readAttributes(HashMap<String, Object> attributes) throws IOException {
        boolean del = false;
        String key = this.getWordOrSymbolOrStringOrEolOrEof();
        attributes.clear();
        if (key.equals("-")) {
            key = this.getWordOrSymbolOrStringOrEolOrEof();
            del = true;
        }
        if (key.equals("+")) {
            key = this.getWordOrSymbolOrStringOrEolOrEof();
        }
        while (!(key.equals("EOF") || key.equals("EOL") || key.equals("]"))) {
            if (del) {
                attributes.put(key, null);
            } else {
                attributes.put(key, this.readAttributeValue(key));
            }
            key = this.getWordOrSymbolOrStringOrEolOrEof();
            if (key.equals("-")) {
                key = this.getWordOrStringOrEolOrEof();
                del = true;
            }
            if (!key.equals("+")) continue;
            key = this.getWordOrStringOrEolOrEof();
            del = false;
        }
        this.pushBack();
    }

    protected Object readAttributeValue(String key) throws IOException {
        ArrayList<Object> vector = null;
        HashMap<String, Object> value = null;
        Object value2 = null;
        String next = null;
        if (key != null) {
            this.eatSymbols(":=");
        }
        if (((Object)(value = this.getStringOrWordOrSymbolOrNumberO())).equals("[")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.readAttributes(map);
            this.eatSymbol(']');
            value = map;
        } else if (((Object)value).equals("{")) {
            vector = this.readAttributeArray(key);
            this.eatSymbol('}');
        } else {
            this.pushBack();
            value = this.getStringOrWordOrNumberO();
            if (key != null) {
                next = this.getWordOrSymbolOrNumberOrStringOrEolOrEof();
                while (next.equals(",")) {
                    if (vector == null) {
                        vector = new ArrayList();
                        vector.add(value);
                    }
                    value2 = this.getStringOrWordOrNumberO();
                    next = this.getWordOrSymbolOrNumberOrStringOrEolOrEof();
                    vector.add(value2);
                }
                this.pushBack();
            }
        }
        if (vector != null) {
            return vector.toArray();
        }
        return value;
    }

    protected ArrayList<Object> readAttributeArray(String key) throws IOException {
        String next;
        ArrayList<Object> list = new ArrayList<Object>();
        do {
            Object value = this.readAttributeValue(null);
            next = this.getWordOrSymbolOrNumberOrStringOrEolOrEof();
            list.add(value);
        } while (next.equals(","));
        this.pushBack();
        return list;
    }

    @Override
    public void begin(String filename) throws IOException {
        super.begin(filename);
        this.begin();
    }

    @Override
    public void begin(URL url) throws IOException {
        super.begin(url);
        this.begin();
    }

    @Override
    public void begin(InputStream stream) throws IOException {
        super.begin(stream);
        this.begin();
    }

    @Override
    public void begin(Reader reader) throws IOException {
        super.begin(reader);
        this.begin();
    }

    protected void begin() throws IOException {
        this.st.parseNumbers();
        this.eatWords("DGS003", "DGS004");
        this.version = 3;
        this.eatEol();
        this.graphName = this.getWordOrString();
        this.stepCountAnnounced = (int)this.getNumber();
        this.eventCountAnnounced = (int)this.getNumber();
        this.eatEol();
        if (this.graphName != null) {
            this.sendGraphAttributeAdded(this.graphName, "label", this.graphName);
        } else {
            this.graphName = "DGS_";
        }
        this.graphName = String.format("%s_%d", this.graphName, System.currentTimeMillis() + (long)Math.random() * 10L);
    }

    @Override
    protected void continueParsingInInclude() throws IOException {
    }

    @Override
    protected Reader createReaderFrom(String file) throws FileNotFoundException {
        InputStream is = null;
        is = new FileInputStream(file);
        if (is.markSupported()) {
            is.mark(128);
        }
        try {
            is = new GZIPInputStream(is);
        }
        catch (IOException e1) {
            if (is.markSupported()) {
                try {
                    is.reset();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            try {
                is.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            is = new FileInputStream(file);
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    @Override
    protected Reader createReaderFrom(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream));
    }

    @Override
    protected void configureTokenizer(StreamTokenizer tok) throws IOException {
        if (this.COMMENT_CHAR > 0) {
            tok.commentChar(this.COMMENT_CHAR);
        }
        tok.eolIsSignificant(this.eol_is_significant);
        tok.parseNumbers();
        tok.wordChars(95, 95);
    }
}

