/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.test;

import org.graphstream.graph.Graph;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.graph.implementations.SingleGraph;
import org.junit.Assert;
import org.junit.Test;

public class TestGraphSynchronisation {
    @Test
    public void testGraphSyncBase() {
        this.testGraphSyncBase(new MultiGraph("g1"), new MultiGraph("g2"));
        this.testGraphSyncBase(new SingleGraph("g1"), new SingleGraph("g2"));
        this.testGraphSyncBase(new AdjacencyListGraph("g1"), new AdjacencyListGraph("g2"));
        this.testGraphSyncBase(new MultiGraph("g1"), new AdjacencyListGraph("g2"));
    }

    protected void testGraphSyncBase(Graph g1, Graph g2) {
        g2.addNode("Z");
        g2.removeNode("Z");
        g1.addSink(g2);
        g2.addSink(g1);
        g1.addNode("A");
        g2.addNode("B");
        g1.addNode("C");
        g2.addEdge("AB", "A", "B", false);
        g1.addEdge("BC", "B", "C", true);
        g2.addEdge("CA", "C", "A", true);
        Assert.assertEquals((long)3L, (long)g1.getNodeCount());
        Assert.assertEquals((long)3L, (long)g2.getNodeCount());
        Assert.assertEquals((long)3L, (long)g1.getEdgeCount());
        Assert.assertEquals((long)3L, (long)g2.getEdgeCount());
        Assert.assertNotNull(g1.getNode("A"));
        Assert.assertNotNull(g2.getNode("A"));
        Assert.assertNotNull(g1.getNode("B"));
        Assert.assertNotNull(g2.getNode("B"));
        Assert.assertNotNull(g1.getNode("C"));
        Assert.assertNotNull(g2.getNode("C"));
        Assert.assertNotNull(g1.getEdge("AB"));
        Assert.assertNotNull(g2.getEdge("AB"));
        Assert.assertNotNull(g1.getEdge("BC"));
        Assert.assertNotNull(g2.getEdge("BC"));
        Assert.assertNotNull(g1.getEdge("CA"));
        Assert.assertNotNull(g2.getEdge("CA"));
        g1.getNode("A").addAttribute("foo", "bar");
        g2.getEdge("AB").addAttribute("foo", "bar");
        Assert.assertEquals((long)1L, (long)g1.getNode("A").getAttributeCount());
        Assert.assertEquals((long)1L, (long)g2.getNode("A").getAttributeCount());
        Assert.assertEquals((long)1L, (long)g1.getEdge("AB").getAttributeCount());
        Assert.assertEquals((long)1L, (long)g2.getEdge("AB").getAttributeCount());
        Assert.assertEquals((Object)"bar", g1.getNode("A").getAttribute("foo"));
        Assert.assertEquals((Object)"bar", g2.getNode("A").getAttribute("foo"));
        Assert.assertEquals((Object)"bar", g1.getEdge("AB").getAttribute("foo"));
        Assert.assertEquals((Object)"bar", g2.getEdge("AB").getAttribute("foo"));
        g1.getNode("A").setAttribute("foo", "truc");
        g2.getEdge("AB").setAttribute("foo", "truc");
        Assert.assertEquals((Object)"truc", g1.getNode("A").getAttribute("foo"));
        Assert.assertEquals((Object)"truc", g2.getNode("A").getAttribute("foo"));
        Assert.assertEquals((Object)"truc", g1.getEdge("AB").getAttribute("foo"));
        Assert.assertEquals((Object)"truc", g2.getEdge("AB").getAttribute("foo"));
        g2.getNode("A").removeAttribute("foo");
        g1.getEdge("AB").removeAttribute("foo");
        Assert.assertEquals((long)0L, (long)g1.getNode("A").getAttributeCount());
        Assert.assertEquals((long)0L, (long)g2.getNode("A").getAttributeCount());
        Assert.assertEquals((long)0L, (long)g1.getEdge("AB").getAttributeCount());
        Assert.assertEquals((long)0L, (long)g2.getEdge("AB").getAttributeCount());
        Assert.assertFalse((boolean)g1.getNode("A").hasAttribute("foo"));
        Assert.assertFalse((boolean)g2.getNode("A").hasAttribute("foo"));
        Assert.assertFalse((boolean)g1.getEdge("AB").hasAttribute("foo"));
        Assert.assertFalse((boolean)g2.getEdge("AB").hasAttribute("foo"));
        g1.removeEdge("CA");
        Assert.assertEquals((long)2L, (long)g1.getEdgeCount());
        Assert.assertEquals((long)2L, (long)g2.getEdgeCount());
        Assert.assertNull(g1.getEdge("CA"));
        Assert.assertNull(g2.getEdge("CA"));
        g2.removeNode("A");
        Assert.assertEquals((long)2L, (long)g2.getNodeCount());
        Assert.assertEquals((long)2L, (long)g1.getNodeCount());
        Assert.assertEquals((long)1L, (long)g1.getEdgeCount());
        Assert.assertEquals((long)1L, (long)g2.getEdgeCount());
        Assert.assertNull(g1.getNode("A"));
        Assert.assertNull(g2.getNode("A"));
        Assert.assertNull(g1.getEdge("AB"));
        Assert.assertNull(g2.getEdge("AB"));
    }

    @Test
    public void testGraphSyncCycleSimple() {
        this.testGraphSyncCycleSimple(new MultiGraph("g1"), new MultiGraph("g2"), new MultiGraph("g3"));
        this.testGraphSyncCycleSimple(new SingleGraph("g1"), new SingleGraph("g2"), new SingleGraph("g3"));
        this.testGraphSyncCycleSimple(new AdjacencyListGraph("g1"), new AdjacencyListGraph("g2"), new AdjacencyListGraph("g3"));
        this.testGraphSyncCycleSimple(new MultiGraph("g1"), new SingleGraph("g2"), new AdjacencyListGraph("g3"));
    }

    protected void testGraphSyncCycleSimple(Graph g1, Graph g2, Graph g3) {
        g1.addSink(g2);
        g2.addSink(g3);
        g3.addSink(g1);
        this.testGraphSyncCycle(g1, g2, g3);
    }

    @Test
    public void testGraphSyncCycleProblem() {
        this.testGraphSyncCycleProblem(new MultiGraph("g1"), new MultiGraph("g2"), new MultiGraph("g3"));
        this.testGraphSyncCycleProblem(new SingleGraph("g1"), new SingleGraph("g2"), new SingleGraph("g3"));
        this.testGraphSyncCycleProblem(new AdjacencyListGraph("g1"), new AdjacencyListGraph("g2"), new AdjacencyListGraph("g3"));
        this.testGraphSyncCycleProblem(new MultiGraph("g1"), new SingleGraph("g2"), new AdjacencyListGraph("g3"));
    }

    protected void testGraphSyncCycleProblem(Graph g1, Graph g2, Graph g3) {
        g1.addSink(g2);
        g2.addSink(g3);
        g3.addSink(g1);
        g3.addSink(g2);
        this.testGraphSyncCycle(g1, g2, g3);
    }

    protected void testGraphSyncCycle(Graph g1, Graph g2, Graph g3) {
        g1.addNode("A");
        g2.addNode("B");
        g3.addNode("C");
        Assert.assertEquals((long)3L, (long)g1.getNodeCount());
        Assert.assertEquals((long)3L, (long)g2.getNodeCount());
        Assert.assertEquals((long)3L, (long)g3.getNodeCount());
        Assert.assertNotNull(g1.getNode("A"));
        Assert.assertNotNull(g2.getNode("A"));
        Assert.assertNotNull(g3.getNode("A"));
        Assert.assertNotNull(g1.getNode("B"));
        Assert.assertNotNull(g2.getNode("B"));
        Assert.assertNotNull(g3.getNode("B"));
        Assert.assertNotNull(g1.getNode("C"));
        Assert.assertNotNull(g2.getNode("C"));
        Assert.assertNotNull(g3.getNode("C"));
        g1.addEdge("AB", "A", "B");
        g2.addEdge("BC", "B", "C", true);
        g3.addEdge("CA", "C", "A", false);
        Assert.assertEquals((long)3L, (long)g1.getEdgeCount());
        Assert.assertEquals((long)3L, (long)g2.getEdgeCount());
        Assert.assertEquals((long)3L, (long)g3.getEdgeCount());
        Assert.assertNotNull(g1.getEdge("AB"));
        Assert.assertNotNull(g2.getEdge("AB"));
        Assert.assertNotNull(g3.getEdge("AB"));
        Assert.assertNotNull(g1.getEdge("BC"));
        Assert.assertNotNull(g2.getEdge("BC"));
        Assert.assertNotNull(g3.getEdge("BC"));
        Assert.assertNotNull(g1.getEdge("CA"));
        Assert.assertNotNull(g2.getEdge("CA"));
        Assert.assertNotNull(g3.getEdge("CA"));
        g1.addAttribute("foo", "bar");
        g2.getNode("A").addAttribute("foo", "bar");
        g3.getEdge("AB").addAttribute("foo", "bar");
        Assert.assertEquals((Object)"bar", g1.getAttribute("foo"));
        Assert.assertEquals((Object)"bar", g2.getAttribute("foo"));
        Assert.assertEquals((Object)"bar", g3.getAttribute("foo"));
        Assert.assertEquals((Object)"bar", g1.getNode("A").getAttribute("foo"));
        Assert.assertEquals((Object)"bar", g2.getNode("A").getAttribute("foo"));
        Assert.assertEquals((Object)"bar", g3.getNode("A").getAttribute("foo"));
        Assert.assertEquals((Object)"bar", g1.getEdge("AB").getAttribute("foo"));
        Assert.assertEquals((Object)"bar", g2.getEdge("AB").getAttribute("foo"));
        Assert.assertEquals((Object)"bar", g3.getEdge("AB").getAttribute("foo"));
        g1.setAttribute("foo", "truc");
        g2.getNode("A").setAttribute("foo", "truc");
        g3.getEdge("AB").setAttribute("foo", "truc");
        Assert.assertEquals((Object)"truc", g1.getAttribute("foo"));
        Assert.assertEquals((Object)"truc", g2.getAttribute("foo"));
        Assert.assertEquals((Object)"truc", g3.getAttribute("foo"));
        Assert.assertEquals((Object)"truc", g1.getNode("A").getAttribute("foo"));
        Assert.assertEquals((Object)"truc", g2.getNode("A").getAttribute("foo"));
        Assert.assertEquals((Object)"truc", g3.getNode("A").getAttribute("foo"));
        Assert.assertEquals((Object)"truc", g1.getEdge("AB").getAttribute("foo"));
        Assert.assertEquals((Object)"truc", g2.getEdge("AB").getAttribute("foo"));
        Assert.assertEquals((Object)"truc", g3.getEdge("AB").getAttribute("foo"));
        g1.removeAttribute("foo");
        g2.getNode("A").removeAttribute("foo");
        g3.getEdge("AB").removeAttribute("foo");
        Assert.assertFalse((boolean)g1.hasAttribute("foo"));
        Assert.assertFalse((boolean)g2.hasAttribute("foo"));
        Assert.assertFalse((boolean)g3.hasAttribute("foo"));
        Assert.assertFalse((boolean)g1.getNode("A").hasAttribute("foo"));
        Assert.assertFalse((boolean)g2.getNode("A").hasAttribute("foo"));
        Assert.assertFalse((boolean)g3.getNode("A").hasAttribute("foo"));
        Assert.assertFalse((boolean)g1.getEdge("AB").hasAttribute("foo"));
        Assert.assertFalse((boolean)g2.getEdge("AB").hasAttribute("foo"));
        Assert.assertFalse((boolean)g3.getEdge("AB").hasAttribute("foo"));
        g1.removeEdge("AB");
        Assert.assertEquals((long)2L, (long)g1.getEdgeCount());
        Assert.assertEquals((long)2L, (long)g2.getEdgeCount());
        Assert.assertEquals((long)2L, (long)g3.getEdgeCount());
        Assert.assertNull(g1.getEdge("AB"));
        Assert.assertNull(g2.getEdge("AB"));
        Assert.assertNull(g3.getEdge("AB"));
        g2.removeNode("A");
        Assert.assertEquals((long)2L, (long)g1.getNodeCount());
        Assert.assertEquals((long)2L, (long)g2.getNodeCount());
        Assert.assertEquals((long)2L, (long)g3.getNodeCount());
        Assert.assertEquals((long)1L, (long)g1.getEdgeCount());
        Assert.assertEquals((long)1L, (long)g2.getEdgeCount());
        Assert.assertEquals((long)1L, (long)g3.getEdgeCount());
        Assert.assertNull(g1.getNode("A"));
        Assert.assertNull(g2.getNode("A"));
        Assert.assertNull(g3.getNode("A"));
        Assert.assertNull(g1.getEdge("CA"));
        Assert.assertNull(g2.getEdge("CA"));
        Assert.assertNull(g3.getEdge("CA"));
    }
}

