/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.net.test;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.LinkedList;
import org.graphstream.graph.implementations.DefaultGraph;
import org.graphstream.stream.rmi.RMISink;
import org.graphstream.stream.rmi.RMISource;
import org.junit.Assert;
import org.junit.Test;

public class TestRMI {
    @Test
    public void test() {
        DefaultGraph g1 = new DefaultGraph("g1");
        DefaultGraph g2 = new DefaultGraph("g2");
        try {
            LocateRegistry.createRegistry(1099);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String name = "__test_rmi_source";
            RMISink sink = new RMISink();
            g1.addSink(sink);
            RMISource source = new RMISource();
            source.addSink(g2);
            source.bind(name);
            sink.register("//localhost/" + name);
        }
        catch (RemoteException e) {
            Assert.fail();
        }
        Object A = g1.addNode("A");
        Object B = g1.addNode("B");
        Object C = g1.addNode("C");
        Object AB = g1.addEdge("AB", "A", "B", false);
        Object AC = g1.addEdge("AC", "A", "C", true);
        Object BC = g1.addEdge("BC", "B", "C", false);
        A.addAttribute("int", 1);
        B.addAttribute("string", "test");
        C.addAttribute("double", 2.0);
        AB.addAttribute("points", new Object[]{new double[][]{{1.0, 1.0}, {2.0, 2.0}}});
        LinkedList<Integer> list = new LinkedList<Integer>();
        list.add(1);
        list.add(2);
        AC.addAttribute("list", list);
        BC.addAttribute("boolean", true);
        A = g2.getNode("A");
        B = g2.getNode("B");
        C = g2.getNode("C");
        Assert.assertNotNull(A);
        Assert.assertNotNull(B);
        Assert.assertNotNull(C);
        Assert.assertEquals((long)g2.getNodeCount(), (long)3L);
        AB = g2.getEdge("AB");
        AC = g2.getEdge("AC");
        BC = g2.getEdge("BC");
        Assert.assertNotNull(AB);
        Assert.assertNotNull(AC);
        Assert.assertNotNull(BC);
        Assert.assertEquals((long)g2.getEdgeCount(), (long)3L);
        Assert.assertEquals((Object)"A", (Object)AB.getNode0().getId());
        Assert.assertEquals((Object)"B", (Object)AB.getNode1().getId());
        Assert.assertEquals((Object)"A", (Object)AC.getNode0().getId());
        Assert.assertEquals((Object)"C", (Object)AC.getNode1().getId());
        Assert.assertEquals((Object)"B", (Object)BC.getNode0().getId());
        Assert.assertEquals((Object)"C", (Object)BC.getNode1().getId());
        Assert.assertTrue((!AB.isDirected() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)AC.isDirected());
        Assert.assertTrue((!BC.isDirected() ? 1 : 0) != 0);
        Assert.assertEquals(A.getAttribute("int"), (Object)1);
        Assert.assertEquals(B.getAttribute("string"), (Object)"test");
        Assert.assertEquals(C.getAttribute("double"), (Object)2.0);
        try {
            double[][] points = (double[][])AB.getAttribute("points");
            Assert.assertEquals((long)points.length, (long)2L);
            Assert.assertEquals((long)points[0].length, (long)2L);
            Assert.assertEquals((long)points[1].length, (long)2L);
            Assert.assertEquals((double)points[0][0], (double)1.0);
            Assert.assertEquals((double)points[0][1], (double)1.0);
            Assert.assertEquals((double)points[1][0], (double)2.0);
            Assert.assertEquals((double)points[1][1], (double)2.0);
        }
        catch (ClassCastException e) {
            Assert.fail();
        }
        catch (NullPointerException e) {
            Assert.fail();
        }
        Assert.assertEquals(list, AC.getAttribute("list"));
        Assert.assertTrue((boolean)((Boolean)BC.getAttribute("boolean")));
    }
}

