/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph.test;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.GraphicSprite;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.spriteManager.Sprite;
import org.graphstream.ui.spriteManager.SpriteManager;
import org.junit.Assert;
import org.junit.Test;

public class TestGraphSynchronisationProxyThread {
    @Test
    public void testGraphSynchronisation() {
        MultiGraph main = new MultiGraph("main");
        ThreadProxyPipe toGraphic = new ThreadProxyPipe();
        toGraphic.init(main);
        InTheSwingThread viewerThread = new InTheSwingThread(toGraphic);
        ThreadProxyPipe toMain = viewerThread.getProxy();
        toMain.addAttributeSink(main);
        viewerThread.start();
        Object A = main.addNode("A");
        Object B = main.addNode("B");
        Object C = main.addNode("C");
        main.addEdge("AB", "A", "B");
        main.addEdge("BC", "B", "C");
        main.addEdge("CA", "C", "A");
        SpriteManager sman = new SpriteManager(main);
        Sprite S1 = sman.addSprite("S1");
        Sprite S2 = sman.addSprite("S2");
        Sprite S3 = sman.addSprite("S3");
        S3.setPosition(1.0, 2.0, 2.0);
        S3.setPosition(2.0, 3.0, 2.0);
        S3.setPosition(3.0, 2.0, 1.0);
        A.addAttribute("ui.foo", "bar");
        B.addAttribute("ui.bar", "foo");
        C.addAttribute("truc", new Object[0]);
        S1.addAttribute("ui.foo", "bar");
        main.stepBegins(1.0);
        toMain.pump();
        main.stepBegins(2.0);
        main.addAttribute("ui.EQUIP", new Object[0]);
        toMain.pump();
        this.sleep(1000);
        toMain.pump();
        main.addAttribute("ui.STOP", new Object[0]);
        toMain.pump();
        this.sleep(1000);
        toMain.pump();
        GraphicGraph graphic = viewerThread.graphic;
        Assert.assertTrue((boolean)viewerThread.isStopped());
        Assert.assertFalse((boolean)main.hasAttribute("ui.EQUIP"));
        Assert.assertFalse((boolean)graphic.hasAttribute("ui.EQUIP"));
        Assert.assertTrue((boolean)main.hasAttribute("ui.STOP"));
        Assert.assertTrue((boolean)graphic.hasAttribute("ui.STOP"));
        Assert.assertEquals((double)3.0, (double)graphic.getStep(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)main.getStep(), (double)0.0);
        Assert.assertEquals((long)3L, (long)graphic.getNodeCount());
        Assert.assertEquals((long)3L, (long)graphic.getEdgeCount());
        Assert.assertEquals((long)3L, (long)graphic.getSpriteCount());
        Assert.assertNotNull(graphic.getNode("A"));
        Assert.assertNotNull(graphic.getNode("B"));
        Assert.assertNotNull(graphic.getNode("C"));
        Assert.assertNotNull(graphic.getEdge("AB"));
        Assert.assertNotNull(graphic.getEdge("BC"));
        Assert.assertNotNull(graphic.getEdge("CA"));
        Assert.assertNotNull((Object)graphic.getSprite("S1"));
        Assert.assertNotNull((Object)graphic.getSprite("S2"));
        Assert.assertEquals((Object)"bar", graphic.getNode("A").getAttribute("ui.foo"));
        Assert.assertEquals((Object)"foo", graphic.getNode("B").getAttribute("ui.bar"));
        Assert.assertEquals((Object)"bar", graphic.getSprite("S1").getAttribute("ui.foo"));
        Assert.assertEquals((Object)"bar", sman.getSprite("S1").getAttribute("ui.foo"));
        Object[] xyz1 = new Object[]{4, 3, 2};
        Object[] xyz2 = new Object[]{2, 1, 0};
        Object[] xyz3 = new Object[]{3, 2, 1};
        Assert.assertArrayEquals((Object[])xyz1, (Object[])((Object[])main.getNode("A").getAttribute("xyz")));
        Assert.assertArrayEquals((Object[])xyz2, (Object[])((Object[])main.getNode("B").getAttribute("xyz")));
        Assert.assertArrayEquals((Object[])xyz3, (Object[])((Object[])main.getNode("C").getAttribute("xyz")));
        Assert.assertEquals((Object)"foobar", S2.getAttribute("ui.foobar"));
        GraphicSprite gs3 = graphic.getSprite("S3");
        Assert.assertEquals((double)0.5, (double)S1.getX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)S1.getY(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)S1.getZ(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)S2.getX(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)S2.getY(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)S2.getZ(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)gs3.getX(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)gs3.getY(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)gs3.getZ(), (double)0.0);
    }

    protected void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class InTheSwingThread
    implements ActionListener {
        protected ThreadProxyPipe fromMain;
        protected GraphicGraph graphic;
        protected Timer timer;

        public InTheSwingThread(ThreadProxyPipe input) {
            this.fromMain = input;
            this.graphic = new GraphicGraph("gg");
            this.timer = new Timer(40, this);
            this.timer.setRepeats(true);
            this.timer.setCoalesce(true);
            input.addSink(this.graphic);
        }

        public void start() {
            this.timer.start();
        }

        public boolean isStopped() {
            return !this.timer.isRunning();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fromMain.pump();
            if (this.graphic.hasAttribute("ui.EQUIP")) {
                Object A = this.graphic.getNode("A");
                Object B = this.graphic.getNode("B");
                Object C = this.graphic.getNode("C");
                if (A != null) {
                    A.addAttribute("xyz", 4, 3, 2);
                }
                if (B != null) {
                    B.addAttribute("xyz", 2, 1, 0);
                }
                if (C != null) {
                    C.addAttribute("xyz", 3, 2, 1);
                }
                GraphicSprite S1 = this.graphic.getSprite("S1");
                GraphicSprite S2 = this.graphic.getSprite("S2");
                if (S2 != null) {
                    S2.addAttribute("ui.foobar", "foobar");
                    S2.setPosition(1.0, 2.0, 3.0, StyleConstants.Units.GU);
                }
                if (S1 != null) {
                    S1.setPosition(0.5);
                }
                this.graphic.removeAttribute("ui.EQUIP");
                this.graphic.stepBegins(3.0);
            } else if (this.graphic.hasAttribute("ui.STOP")) {
                this.timer.stop();
            }
        }

        public ThreadProxyPipe getProxy() {
            ThreadProxyPipe toMain = new ThreadProxyPipe();
            toMain.init(this.graphic);
            return toMain;
        }
    }
}

