/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer.util;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;

public class GradientFactory {
    public static boolean version16;
    public static float[][] predefFractions;
    public static float[] predefFractions2;
    public static float[] predefFractions3;
    public static float[] predefFractions4;
    public static float[] predefFractions5;
    public static float[] predefFractions6;
    public static float[] predefFractions7;
    public static float[] predefFractions8;
    public static float[] predefFractions9;
    public static float[] predefFractions10;

    static {
        String v;
        int n;
        version16 = false;
        predefFractions = new float[11][];
        predefFractions2 = new float[]{0.0f, 1.0f};
        predefFractions3 = new float[]{0.0f, 0.5f, 1.0f};
        predefFractions4 = new float[]{0.0f, 0.33f, 0.66f, 1.0f};
        predefFractions5 = new float[]{0.0f, 0.25f, 0.5f, 0.75f, 1.0f};
        predefFractions6 = new float[]{0.0f, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f};
        predefFractions7 = new float[]{0.0f, 0.1666f, 0.3333f, 0.4999f, 0.6666f, 0.8333f, 1.0f};
        predefFractions8 = new float[]{0.0f, 0.1428f, 0.2856f, 0.4284f, 0.5712f, 0.714f, 0.8568f, 1.0f};
        predefFractions9 = new float[]{0.0f, 0.125f, 0.25f, 0.375f, 0.5f, 0.625f, 0.75f, 0.875f, 1.0f};
        predefFractions10 = new float[]{0.0f, 0.1111f, 0.2222f, 0.3333f, 0.4444f, 0.5555f, 0.6666f, 0.7777f, 0.8888f, 1.0f};
        String version = System.getProperty("java.version");
        if (version.startsWith("1.") && version.length() >= 3 && (n = Integer.parseInt(v = version.substring(2, 3))) >= 6) {
            version16 = true;
        }
        GradientFactory.predefFractions[0] = null;
        GradientFactory.predefFractions[1] = null;
        GradientFactory.predefFractions[2] = predefFractions2;
        GradientFactory.predefFractions[3] = predefFractions3;
        GradientFactory.predefFractions[4] = predefFractions4;
        GradientFactory.predefFractions[5] = predefFractions5;
        GradientFactory.predefFractions[6] = predefFractions6;
        GradientFactory.predefFractions[7] = predefFractions7;
        GradientFactory.predefFractions[8] = predefFractions8;
        GradientFactory.predefFractions[9] = predefFractions9;
        GradientFactory.predefFractions[10] = predefFractions10;
    }

    public static Paint gradientInArea(int x0, int y0, int width, int height, Style style) {
        switch (style.getFillMode()) {
            case GRADIENT_VERTICAL: {
                return GradientFactory.linearGradientFromStyle(x0, y0, x0, y0 + height, style);
            }
            case GRADIENT_HORIZONTAL: {
                return GradientFactory.linearGradientFromStyle(x0, y0, x0 + width, y0, style);
            }
            case GRADIENT_DIAGONAL1: {
                return GradientFactory.linearGradientFromStyle(x0, y0, x0 + width, y0 + height, style);
            }
            case GRADIENT_DIAGONAL2: {
                return GradientFactory.linearGradientFromStyle(x0 + width, y0, x0, y0 + height, style);
            }
            case GRADIENT_RADIAL: {
                return GradientFactory.radialGradientFromStyle(x0 + width / 2, y0 + height / 2, width > height ? width / 2 : height / 2, style);
            }
        }
        return null;
    }

    public static Paint linearGradientFromStyle(float x0, float y0, float x1, float y1, Style style) {
        Paint paint = null;
        if (style.getFillColorCount() > 1) {
            switch (style.getFillMode()) {
                case GRADIENT_HORIZONTAL: 
                case GRADIENT_VERTICAL: 
                case GRADIENT_DIAGONAL1: 
                case GRADIENT_DIAGONAL2: {
                    if (version16) {
                        paint = new LinearGradientPaint(x0, y0, x1, y1, GradientFactory.createFractions(style), GradientFactory.createColors(style));
                        break;
                    }
                    paint = new GradientPaint(x0, y0, style.getFillColor(0), x1, y1, style.getFillColor(1));
                    break;
                }
            }
        }
        return paint;
    }

    public static Paint radialGradientFromStyle(float cx, float cy, float radius, Style style) {
        return GradientFactory.radialGradientFromStyle(cx, cy, radius, cx, cy, style);
    }

    public static Paint radialGradientFromStyle(float cx, float cy, float radius, float fx, float fy, Style style) {
        RadialGradientPaint paint = null;
        if (version16 && style.getFillColorCount() > 1 && style.getFillMode() == StyleConstants.FillMode.GRADIENT_RADIAL) {
            float[] fractions = GradientFactory.createFractions(style);
            Color[] colors = GradientFactory.createColors(style);
            paint = new RadialGradientPaint(cx, cy, radius, fx, fy, fractions, colors, MultipleGradientPaint.CycleMethod.REFLECT);
        }
        return paint;
    }

    protected static float[] createFractions(Style style) {
        int n = style.getFillColorCount();
        if (n < predefFractions.length) {
            return predefFractions[n];
        }
        float[] fractions = new float[n];
        float div = 1.0f / (float)(n - 1);
        int i = 1;
        while (i < n - 1) {
            fractions[i] = div * (float)i;
            ++i;
        }
        fractions[0] = 0.0f;
        fractions[n - 1] = 1.0f;
        return fractions;
    }

    protected static Color[] createColors(Style style) {
        int n = style.getFillColorCount();
        Color[] colors = new Color[n];
        int i = 0;
        while (i < n) {
            colors[i] = style.getFillColor(i);
            ++i;
        }
        return colors;
    }
}

