/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.netstream;

import java.io.IOException;
import java.net.UnknownHostException;
import org.graphstream.stream.Sink;
import org.graphstream.stream.netstream.NetStreamReceiver;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.junit.Assert;

public class ExampleEventsReceiver {
    public static void main(String[] args) throws InterruptedException {
        NetStreamReceiver net = null;
        try {
            net = new NetStreamReceiver("localhost", 2001, true);
        }
        catch (UnknownHostException e1) {
            Assert.fail((String)e1.toString());
        }
        catch (IOException e1) {
            Assert.fail((String)e1.toString());
        }
        ThreadProxyPipe pipe = net.getDefaultStream();
        pipe.addSink(new Sink(){

            @Override
            public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
                Assert.assertEquals((Object)0, (Object)value);
                Assert.assertEquals((Object)"graphAttribute", (Object)attribute);
            }

            @Override
            public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
                Assert.assertTrue(((Integer)newValue == 0 || (Integer)newValue == 1 ? 1 : 0) != 0);
                Assert.assertEquals((Object)"graphAttribute", (Object)attribute);
            }

            @Override
            public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
                Assert.assertEquals((Object)"graphAttribute", (Object)attribute);
            }

            @Override
            public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
                Assert.assertEquals((Object)0, (Object)value);
                Assert.assertEquals((Object)"nodeAttribute", (Object)attribute);
            }

            @Override
            public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
                Assert.assertTrue(((Integer)newValue == 0 || (Integer)newValue == 1 ? 1 : 0) != 0);
                Assert.assertEquals((Object)"nodeAttribute", (Object)attribute);
            }

            @Override
            public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
                Assert.assertEquals((Object)"nodeAttribute", (Object)attribute);
            }

            @Override
            public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
                Assert.assertEquals((Object)0, (Object)value);
                Assert.assertEquals((Object)"edgeAttribute", (Object)attribute);
            }

            @Override
            public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
                Assert.assertTrue(((Integer)newValue == 0 || (Integer)newValue == 1 ? 1 : 0) != 0);
                Assert.assertEquals((Object)"edgeAttribute", (Object)attribute);
            }

            @Override
            public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
                Assert.assertEquals((Object)"edgeAttribute", (Object)attribute);
            }

            @Override
            public void nodeAdded(String sourceId, long timeId, String nodeId) {
                Assert.assertTrue(("node0".equals(nodeId) || "node1".equals(nodeId) ? 1 : 0) != 0);
            }

            @Override
            public void nodeRemoved(String sourceId, long timeId, String nodeId) {
                Assert.assertTrue(("node0".equals(nodeId) || "node1".equals(nodeId) ? 1 : 0) != 0);
            }

            @Override
            public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
                Assert.assertEquals((Object)"edge", (Object)edgeId);
                Assert.assertEquals((Object)"node0", (Object)fromNodeId);
                Assert.assertEquals((Object)"node1", (Object)toNodeId);
                Assert.assertEquals((Object)true, (Object)directed);
            }

            @Override
            public void edgeRemoved(String sourceId, long timeId, String edgeId) {
                Assert.assertEquals((Object)"edge", (Object)edgeId);
            }

            @Override
            public void graphCleared(String sourceId, long timeId) {
            }

            @Override
            public void stepBegins(String sourceId, long timeId, double step) {
                Assert.assertEquals((double)1.1, (double)step);
            }
        });
        while (true) {
            pipe.pump();
            Thread.sleep(100L);
        }
    }
}

