# Find BLAS on system or use the one in 3rdParty.

IF(WIN32)
	SET(BLAS_blas_LIBRARY "${OMDEV_DIR}/lib/3rdParty/Lapack/Lib/blas_win32.dll")
	FIND_PACKAGE(BLAS)
	IF(NOT BLAS_FOUND)
		MESSAGE(STATUS "BLAS library not found. Setting manually to:")
		SET(BLAS_DIR "${OMDEV_DIR}/lib/3rdParty/Lapack/Lib")
		SET(BLAS_LIB "${OMDEV_DIR}/lib/3rdParty/Lapack/Lib/blas_win32.dll")
		MESSAGE(STATUS "${BLAS_LIB}")
	ENDIF()

	# Find LAPACK on system or use the one in 3rdParty.
	SET(LAPACK_lapack_LIBRARY "${OMDEV_DIR}/lib/3rdParty/Lapack/Lib/lapack_win32.dll")
	FIND_PACKAGE(LAPACK)
	IF(NOT LAPACK_FOUND)
		MESSAGE(STATUS "LAPACK library not found. Setting manually to:")
		SET(LAPACK_DIR "${OMDEV_DIR}/lib/3rdParty/Lapack/Lib")
		SET(LAPACK_LIB "${OMDEV_DIR}/lib/3rdParty/Lapack/Lib/lapack_win32.dll")
		MESSAGE(STATUS "${BLAS_LIB}")
	ENDIF()
	SET(BLAS_LIBRARY_DIRS "${BLAS_DIR}")
	SET(LAPACK_LIBRARY_DIRS "${LAPACK_DIR}")
	SET(TPL_BLAS_LIBRARIES "${BLAS_LIB}")
	SET(TPL_LAPACK_LIBRARIES "${LAPACK_LIB}")
ENDIF()


# Set Trilinos options to build and use only necessary packages.
SET(Trilinos_ENABLE_ALL_PACKAGES OFF)
SET(Trilinos_ENABLE_EXAMPLES OFF)
SET(Trilinos_ENABLE_TESTS OFF)
SET(BUILD_SHARED_LIBS ON)
SET(Trilinos_ENABLE_NOX ON)
SET(Trilinos_ASSERT_MISSING_PACKAGES OFF)
SET(Xpetra_ENABLE_Tpetra OFF)
SET(Trilinos_ENABLE_ThyraCore OFF)
SET(NOX_ENABLE_ThyraEpetraExtAdapters OFF)
SET(Trilinos_ENABLE_Gtest OFF)
SET(Trilinos_ENABLE_Epetra OFF)
SET(Trilinos_ENABLE_Galeri OFF)
SET(Trilinos_ENABLE_AztecOO OFF)
SET(Trilinos_ENABLE_Ifpack OFF)
SET(Trilinos_ENABLE_KokkosCore OFF)
SET(DTrilinos_EXTRA_LINK_FLAGS "-lws2_32")
SET(CMAKE_INSTALL_PREFIX "./build")
