/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.test;

import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.file.FileSourceDGS;
import org.graphstream.stream.file.test.TestFileSourceBase;
import org.junit.Before;

public class TestFileSourceDGS
extends TestFileSourceBase {
    protected static String TEST1_TRIANGLE = "DGS004\n\"test1\" 0 0\nan A\nan B\nan C\nae AB A B\nae BC B C\nae CA C A\n";
    protected static String TEST2_DIRECTED_TRIANGLE = "DGS004\n\"test2\" 0 0\nan A\nan B\nan C\nae AB A > B\nae BC B C\nae CA C < A\n";
    protected static String TEST3_ATTRIBUTES = "DGS004\n\"test3\" 0 0\nan A a:1 b:\"truc\" c:\"true\"\nan B aa:1,2,3,4 bb:foo cc:bar\nan C aaa=1.234\nae AB A B\nae BC B C\nae CA C A\n";

    @Before
    public void setUp() {
        this.graph = new MultiGraph("g1");
        this.input = new FileSourceDGS();
    }

    @Override
    public String anUndirectedTriangle() {
        return TEST1_TRIANGLE;
    }

    @Override
    public String aDirectedTriangle() {
        return TEST2_DIRECTED_TRIANGLE;
    }

    @Override
    public String basicAttributes() {
        return TEST3_ATTRIBUTES;
    }

    @Override
    public String anUndirectedTriangleFileName() {
        return "src-test/org/graphstream/stream/file/test/data/undirectedTriangle.dgs";
    }

    @Override
    public String anUndirectedTriangleHttpURL() {
        return "http://graphstream-project.org/media/data/undirectedTriangle.dgs";
    }
}

