/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.viewer.test;

import java.io.IOException;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.file.FileSourceDGS;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.graphstream.ui.swingViewer.Viewer;

public class DemoTwoGraphsInOneViewer {
    public static final String GRAPH = "data/dorogovtsev_mendes6000.dgs";
    protected String styleSheet1 = "graph { padding: 40px; }node { fill-color: red; }";
    protected String styleSheet2 = "graph { padding: 40px; }node { fill-color: blue; }";

    public static void main(String[] args) {
        new DemoTwoGraphsInOneViewer();
    }

    public DemoTwoGraphsInOneViewer() {
        MultiGraph graph1 = new MultiGraph("g1");
        MultiGraph graph2 = new MultiGraph("g2");
        Viewer viewer1 = new Viewer(new ThreadProxyPipe(graph1));
        Viewer viewer2 = new Viewer(new ThreadProxyPipe(graph2));
        graph1.addAttribute("ui.stylesheet", this.styleSheet1);
        graph2.addAttribute("ui.stylesheet", this.styleSheet2);
        viewer1.addDefaultView(true);
        viewer2.addDefaultView(true);
        viewer1.enableAutoLayout();
        viewer2.enableAutoLayout();
        FileSourceDGS dgs = new FileSourceDGS();
        dgs.addSink(graph1);
        try {
            dgs.begin(this.getClass().getResourceAsStream(GRAPH));
            int i = 0;
            while (i < 100 && dgs.nextEvents()) {
                ++i;
            }
            dgs.end();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        dgs.removeSink(graph1);
        dgs.addSink(graph2);
        try {
            dgs.begin(this.getClass().getResourceAsStream(GRAPH));
            int i = 0;
            while (i < 100 && dgs.nextEvents()) {
                ++i;
            }
            dgs.end();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        dgs.removeSink(graph2);
    }
}

