/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.gexf;

import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.graphstream.stream.SinkAdapter;
import org.graphstream.stream.file.gexf.GEXF;
import org.graphstream.stream.file.gexf.GEXFEdge;
import org.graphstream.stream.file.gexf.GEXFElement;
import org.graphstream.stream.file.gexf.SmartXMLWriter;

public class GEXFEdges
extends SinkAdapter
implements GEXFElement {
    GEXF root;
    HashMap<String, GEXFEdge> edges;

    public GEXFEdges(GEXF root) {
        this.root = root;
        this.edges = new HashMap();
        root.addSink(this);
    }

    @Override
    public void export(SmartXMLWriter stream) throws XMLStreamException {
        stream.startElement("edges");
        for (GEXFEdge edge : this.edges.values()) {
            edge.export(stream);
        }
        stream.endElement();
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        GEXFEdge edge = this.edges.get(edgeId);
        if (edge == null) {
            edge = new GEXFEdge(this.root, edgeId, fromNodeId, toNodeId, directed);
            this.edges.put(edgeId, edge);
        }
        edge.spells.start();
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        GEXFEdge edge = this.edges.get(edgeId);
        if (edge == null) {
            System.err.printf("edge removed but not added\n", new Object[0]);
            return;
        }
        edge.spells.end();
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        for (GEXFEdge edge : this.edges.values()) {
            edge.spells.end();
        }
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        GEXFEdge edge = this.edges.get(edgeId);
        if (("ui.label".equals(attribute) || "label".equals(attribute)) && value != null) {
            edge.label = value.toString();
        }
        if ("weight".equals("attribute") && value != null && value instanceof Number) {
            edge.weight = ((Number)value).doubleValue();
        }
        edge.attvalues.attributeUpdated(this.root.getEdgeAttribute(attribute), value);
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.edgeAttributeAdded(sourceId, timeId, edgeId, attribute, newValue);
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        GEXFEdge edge = this.edges.get(edgeId);
        edge.attvalues.attributeUpdated(this.root.getNodeAttribute(attribute), null);
    }
}

