/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util.test;

import java.io.IOException;
import java.util.HashSet;
import org.graphstream.graph.Graph;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.stream.file.FileSourceDGS;
import org.graphstream.util.FilteredEdgeIterator;
import org.graphstream.util.FilteredNodeIterator;
import org.graphstream.util.Filters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFilteredIterators {
    Graph baseGraph;

    @Before
    public void loadGraph() throws IOException {
        FileSourceDGS dgs = new FileSourceDGS();
        this.baseGraph = new AdjacencyListGraph("g");
        dgs.addSink(this.baseGraph);
        dgs.readAll(this.getClass().getResource("data/TestFilteredIterators.dgs"));
        dgs.removeSink(this.baseGraph);
    }

    @Test
    public void testFilteredNodeIterator() {
        HashSet expected = new HashSet();
        HashSet<Object> reached = new HashSet<Object>();
        FilteredNodeIterator ite = new FilteredNodeIterator(this.baseGraph.getNodeIterator(), Filters.byAttributeFilter("type", "A"));
        expected.add(this.baseGraph.getNode("A0"));
        expected.add(this.baseGraph.getNode("A1"));
        expected.add(this.baseGraph.getNode("A2"));
        while (ite.hasNext()) {
            reached.add(ite.next());
        }
        Assert.assertEquals(expected, reached);
    }

    @Test
    public void testFiltereEdgeIterator() {
        HashSet expected = new HashSet();
        HashSet<Object> reached = new HashSet<Object>();
        FilteredEdgeIterator ite = new FilteredEdgeIterator(this.baseGraph.getEdgeIterator(), Filters.byAttributeFilter("type", "A"));
        expected.add(this.baseGraph.getEdge("A01"));
        expected.add(this.baseGraph.getEdge("A02"));
        expected.add(this.baseGraph.getEdge("A12"));
        while (ite.hasNext()) {
            reached.add(ite.next());
        }
        Assert.assertEquals(expected, reached);
    }
}

