@echo off
REM OpenModelica TLM start-up script
REM Start with 6 arguments:
REM 1 XModelName (XModel directory) 
REM 2 start-time 
REM 3 end-time 
REM 4 max-time-step 
REM 5 server-name:port 
REM 6 model-file 

rem *********************SET PATHS****************************************************
rem set path to OpenModelica installation folder
set OpenModelicaPath=C:/OpenModelica1.9.1Nightly

rem *********************SETUP SIMULATION*********************************************
set OMC_Cmd=%OpenModelicaPath%/bin/omc.exe
set TLMCONFIGFILE=tlm.config

If "%6" == "" goto USAGE

echo execution directory is %1
cd %1

If not exist %6 goto BADFILE

echo Starting a OpenModelica simulation with input file: %6
echo Make sure that: 
echo time = %2
echo timeEnd = %3
echo MaxTimeStep "<"= %4

echo Writing caseID %1 and server name %5 to file %TLMCONFIGFILE%
echo %1 > %TLMCONFIGFILE% 
echo %5 >> %TLMCONFIGFILE%
echo %2 >> %TLMCONFIGFILE%
echo %3 >> %TLMCONFIGFILE%
echo %4 >> %TLMCONFIGFILE%

set MOSFILE=%1.mos
for /F %%I in ("%6") do set MODELNAME=%%~nI 
for /F %%I in ("%Mofile%") do set MODELNAME_WITH_MO=%%I 
%TLMPluginPath%\bin\AdvancedCalc.exe (%3-%2)/%4
rem resulting in "result.bat" that contains "set res=7.777"
call result.bat
set INTERVALS=%res%
rem set /a INTERVALS=(%3-%2)/%4
echo Computed INTERVALS = %INTERVALS%

echo Writing %MOSFILE% 
echo // Autogenerated modelica script for TLM cosimulation > %MOSFILE%
echo setEnvironmentVar("MODELICAUSERCFLAGS","-I %TLMPluginPath%\Modelica"); >> %MOSFILE%
rem echo setCommandLineOptions({"+d=initialization"}); >> %MOSFILE%
rem echo setCommandLineOptions({"-lv=LOG_INIT -w"}); >> %MOSFILE%
echo loadModel(Modelica); >> %MOSFILE%

echo loadFile("%TLMPluginPath%\Modelica\TLM.mo"); >> %MOSFILE%

echo loadFile("%6"); >> %MOSFILE%
REM echo getErrorString(); >> %MOSFILE%
echo checkModel(%MODELNAME%); >> %MOSFILE%
REM echo getErrorString(); >> %MOSFILE%
echo simulate(%MODELNAME%, startTime=%2, stopTime=%3, numberOfIntervals=%INTERVALS%, tolerance=0.000001, method="euler", outputFormat="plt", variableFilter="pos"); >> %MOSFILE%
REM echo simulate(%MODELNAME%, startTime=%2, stopTime=%3, numberOfIntervals=%INTERVALS%, tolerance=0.000001, method="euler", outputFormat="plt"); >> %MOSFILE%
REM echo getErrorString(); >> %MOSFILE%


echo Starting OpenModelica
echo %OMC_Cmd% %MOSFILE%

%OMC_Cmd% %1.mos > %1.simlog
goto DONE


:USAGE
echo Usage: 
echo %0 XModelName start-time end-time max-time-step server-name:port model-file 
goto DONE


:BADFILE
echo Model file %6 not found, cannot start simulation


:DONE
echo Done %0