/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.viewer.test;

import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.ui.swingViewer.ViewerListener;
import org.graphstream.ui.swingViewer.ViewerPipe;

public class DemoViewerColorInterpolation
implements ViewerListener {
    protected boolean loop = true;
    protected static String styleSheet = "graph         { padding: 20px; stroke-width: 0px; }node:selected { fill-color: red;  fill-mode: plain; }node:clicked  { fill-color: blue; fill-mode: plain; }node#A        { fill-color: green, yellow, purple; fill-mode: dyn-plain; }";

    public static void main(String[] args) {
        new DemoViewerColorInterpolation();
    }

    public DemoViewerColorInterpolation() {
        MultiGraph graph = new MultiGraph("main graph");
        ViewerPipe pipe = graph.display(false).newViewerPipe();
        graph.addAttribute("ui.antialias", new Object[0]);
        pipe.addViewerListener(this);
        Object A = graph.addNode("A");
        Object B = graph.addNode("B");
        Object C = graph.addNode("C");
        graph.addEdge("AB", "A", "B", true);
        graph.addEdge("BC", "B", "C", true);
        graph.addEdge("CA", "C", "A", true);
        A.addAttribute("xyz", 0, 1, 0);
        B.addAttribute("xyz", 1, 0, 0);
        C.addAttribute("xyz", -1, 0, 0);
        graph.addAttribute("ui.stylesheet", styleSheet);
        float color = 0.0f;
        float dir = 0.01f;
        while (this.loop) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            pipe.pump();
            color += dir;
            if (color > 1.0f) {
                color = 1.0f;
                dir = -dir;
            } else if (color < 0.0f) {
                color = 0.0f;
                dir = -dir;
            }
            A.setAttribute("ui.color", Float.valueOf(color));
            this.showSelection(graph);
        }
        System.out.printf("Bye bye ...%n", new Object[0]);
        System.exit(0);
    }

    protected void showSelection(Graph graph) {
        boolean selection = false;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Node node : graph) {
            if (node.hasAttribute("ui.selected")) {
                sb.append(String.format(" %s", node.getId()));
                selection = true;
            }
            if (!node.hasAttribute("ui.clicked")) continue;
            System.err.printf("node %s clicked%n", node.getId());
        }
        sb.append(" ]");
        if (selection) {
            System.err.printf("selection = %s%n", sb.toString());
        }
    }

    @Override
    public void buttonPushed(String id) {
    }

    @Override
    public void buttonReleased(String id) {
    }

    @Override
    public void viewClosed(String viewName) {
        this.loop = false;
    }
}

