echo off
REM OpenModelica TLM start-up script
REM Start with 6 arguments:
REM 1 XModelName (XModel directory) 
REM 2 start-time 
REM 3 end-time 
REM 4 max-time-step 
REM 5 server-name:port 
REM 6 model-file (without mo)

set Mofile=%6.mo

rem *********************SET PATHS****************************************************
rem set path to Dymola installation folder
set DymolaPath=C:\Program Files (x86)\Dymola 2016 FD01

rem *********************SETUP SIMULATION*********************************************
rem use dir /x to study these weird MS-DOS paths 
set Dymola_Cmd="%DymolaPath%\bin\Dymola.exe"

set TLMCONFIGFILE=tlm.config

If "%6" == "" goto USAGE

echo execution directory is %1
cd %1

If not exist %Mofile% goto BADFILE

echo Starting a Dymola simulation with input file: %6
echo Make sure that: 
echo time = %2
echo timeEnd = %3
echo MaxTimeStep "<"= %4
echo 

echo Writing caseID %1 and server name %5 to file %TLMCONFIGFILE%
echo %1 > %TLMCONFIGFILE% 
echo %5 >> %TLMCONFIGFILE%
echo %2 >> %TLMCONFIGFILE%
echo %3 >> %TLMCONFIGFILE%
echo %4 >> %TLMCONFIGFILE%

set MOSFILE=%1.mos
for /F %%I in ("%6") do set MODELNAME=%%~nI 
for /F %%I in ("%Mofile%") do set MODELNAME_WITH_MO=%%I 
echo APA
echo %TLMPluginPath%\AdvancedCalc.exe (%3-%2)/%4
echo KANIN
%TLMPluginPath%\AdvancedCalc.exe (%3-%2)/%4
rem resulting in "result.bat" that contains "set res=xxx"
call result.bat
set INTERVALS=%res%
rem set /a INTERVALS=(%3-%2)/%4
echo Computed INTERVALS = %INTERVALS%

echo Writing %MOSFILE% 
echo // Autogenerated modelica script for TLM cosimulation > %MOSFILE%
echo openModel("%DymolaPath%\Modelica\Library\Modelica 3.0\package.mo"); >> %MOSFILE%
echo openModel("%TLMPluginPath%\Modelica\TLM.mo"); >> %MOSFILE%


rem  This %CD% is very important. Dymola creates its exe files and temp files in the same place , and two Dymolas dislike each other.
echo openModel("%CD%\%MODELNAME_WITH_MO%"); >> %MOSFILE%

echo LogDefaultInitialConditions = true; >> %MOSFILE%
echo checkModel("%6"); >> %MOSFILE%
echo translateModel(problem="%6"); >> %MOSFILE%

rem set simulation settings
echo simulateModel(problem="%6", startTime=%2, stopTime=%3, numberOfIntervals=%INTERVALS%, tolerance=0.000001, resultFile = "dsres", method="euler"); >> %MOSFILE%

echo Starting Dymola
echo %Dymola_Cmd% %MOSFILE%
echo DOING THIS: %Dymola_Cmd% %1.mos > %1.simlog
%Dymola_Cmd% %1.mos >> %1.simlog
echo DONE  THIS: %Dymola_Cmd% %1.mos >> %1.simlog

goto DONE

:USAGE
echo Usage: 
echo %0 XModelName start-time end-time max-time-step server-name:port model-file 
goto DONE


:BADFILE
echo Model file %6 not found, cannot start simulation


:DONE
echo Done %0