# OMCompiler C Runtime - Developer Documentation

The C Runtime of the OpenModelica Compiler is a runtime to work with generated C
generated by the Frontend and Backend to:

  - Simulate ODE/DAE systems
  - Optimization of ODE/DAE systems
  - Data Reconciliation
  - Linearize ODE systems

Also, it provides some utility functions:

  - MetaModelica language
  - External C functions for FMU import in Modelica models
  - Utility functions for the compiler

## Directory Structure

  - [dataReconciliation/](./dataReconciliation/)<br/>
    Data Reconciliation, see
    [User's Guide chapter Data Reconciliation](https://openmodelica.org/doc/OpenModelicaUsersGuide/latest/dataReconciliation.html#data-reconciliation)

    Integrated into the simulation procedure of the C runtime. C++ code written
    in mainly C style (structs instead of classes) but using a few standard
    functionalities from the C++ standard like `vector` or `string`. Uses LAPACK
    for its Matrix/Vector computations.

  - [fmi/](./fmi/)<br/>
    Wrappers for FMI1 and FMI2 C-functions to be called from Modelica external
    C. Used by the compiler for the mostly not working FMU import in Modelica to
    integrate FMUs into a Modelica model.

  - [gc/](./gc/)<br/>
    Boehm GC mark-and-sweep garbage collector for the C runtime. Is used for C
    variables the runtime doesn't know the lifetime of. E.g. for some strings or
    arrays.

  - [linearization/](./linearization/)<br/>
    Single function `linearize` to linearize an ODE system. Written in C++ to
    use Strings, but otherwise using C style.

  - [math-support/](./math-support/)<br/>
    Only containts a function to compute a full pivotization of a matrix. Used
    for state selection.

  - [meta/](./meta/)<br/>
    C functions used for Meta Modelica. Data types or functions used in the Meta
    Modelica language used by Frontend / Backend of OMC.

  - [moo/](./moo/)<br/>
    Modelica / Model Optimizer - A Generic Framework for Dynamic Optimization,
    see [AMIT-HSBI/MOO](https://github.com/AMIT-HSBI/MOO).

  - [optimization/](./optimization/)<br/>
    A dynamic optimization runtime for OpenModelica, see
    [User's Guide on Optimization with OpenModelica](https://openmodelica.org/doc/OpenModelicaUsersGuide/latest/optimization.html#builtin-dynamic-optimization)

  - [simulation/](./simulation/)<br/>
    The main simulation runtime for generated simulation executables. Containing
    ODE, DAE solvers as well as linear and non-linear solvers and tools for
    event handling.

    See [simulation/Readme.md](./simulation/Readme.md) for more details.

  - [util](./util/)<br/>
    Functions for different parts of the C runtime.

    - Simulation Options
    - C implementation of some data types like arrays, lists, strings, ...
    - Math functions for rational numbers, greatest common divisor
    - Memory management with a ringbuffer
    - Error handling and logging
    - Handling of CSV- and MAT-files
    - A Java interface of all things
