# Created using "misc/xmlParams.py" (or similar name). Written as python code for
#  easier use and because this list is unlikely to change

# Pairs meaning:
#    Parameter name, value, description
w3_params_info_list = [ ("agr_inp_init",5000000000.0,"Initial agricultural input"),
                        ("agr_mtl_toxic_index",1.0,"Agricultural materials toxicity index"),
                        ("arable_land_init",900000000.0,"Initial arable land"),
                        ("assim_half_life_1970",1.5,"Pollution assimilation half life in 1970"),
                        ("avg_life_land_norm",1000.0,"Normal life span of land"),
                        ("des_compl_fam_size_norm",3.8,"Desired normal complete family size"),
                        ("des_food_ratio_dfr",2.0,"Desired food ratio"),
                        ("des_ppoll_index_DPOLX",1.2,"Desired persistent pollution index"),
                        ("des_res_use_rt_DNRUR",4800000000.0,"Desired resource utilization rate"),
                        ("food_short_perc_del",2.0,"Food shortage perception delay"),
                        ("fr_agr_inp_pers_mtl",0.001,"Effective fraction of agricultural pollution input"),
                        ("frac_res_pers_mtl",0.02,"Effective fraction of resource utilization on pollution generation"),
                        ("hlth_serv_impact_del",20.0,"Health service impact delay"),
                        ("income_expect_avg_time",3.0,"Income expected average time"),
                        ("ind_mtl_emiss_fact",0.1,"Industrial materials emission factor"),
                        ("ind_mtl_toxic_index",10.0,"Industrial materials toxicity index"),
                        ("ind_out_in_1970",790000000000.0,"Industrial output in 1970"),
                        ("ind_out_pc_des",400.0,"Desired annual industrial per capita output"),
                        ("industrial_capital_init",210000000000.0,"Initial industrial investment"),
                        ("inherent_land_fert",600.0,"Inherent land fertility"),
                        ("labor_force_partic",0.75,"Percentage of participating labor force"),
                        ("labor_util_fr_del_init",1.0,"Initial delayed labor utilization fraction"),
                        ("labor_util_fr_del_time",2.0,"Labor utilization fraction delay time"),
                        ("land_fertility_init",600.0,"Initial industrial investment"),
                        ("land_fr_harvested",0.7,"Land fraction harvested"),
                        ("life_expect_norm",28.0,"Normal life expectancy"),
                        ("lifet_perc_del",20.0,"Perceived life-time delay"),
                        ("max_tot_fert_norm",12.0,"Normal maximal total fertility"),
                        ("nr_resources_init",1000000000000.0,"Initial available non-recoverable resources"),
                        ("p_avg_life_agr_inp_1",2.0,"Default average life of agricultural input"),
                        ("p_avg_life_agr_inp_2",2.0,"Controlled average life of agricultural input"),
                        ("p_avg_life_ind_cap_1",14.0,"Default average life of industrial capital"),
                        ("p_avg_life_ind_cap_2",14.0,"Controlled average life of industrial capital"),
                        ("p_avg_life_serv_cap_1",20.0,"Default average life of service sector capital"),
                        ("p_avg_life_serv_cap_2",20.0,"Controlled average life of service sector capital"),
                        ("p_fioa_cons_const_1",0.43,"Default fraction of industrial output allocated to consumption"),
                        ("p_fioa_cons_const_2",0.43,"Controlled fraction of industrial output allocated to consumption"),
                        ("p_fr_cap_al_obt_res_2[1]",1.0,"Non-renewable resource fraction remaining"),
                        ("p_fr_cap_al_obt_res_2[2]",0.2,"Non-renewable resource fraction remaining"),
                        ("p_fr_cap_al_obt_res_2[3]",0.1,"Non-renewable resource fraction remaining"),
                        ("p_fr_cap_al_obt_res_2[4]",0.05,"Non-renewable resource fraction remaining"),
                        ("p_fr_cap_al_obt_res_2[5]",0.05,"Non-renewable resource fraction remaining"),
                        ("p_fr_cap_al_obt_res_2[6]",0.05,"Non-renewable resource fraction remaining"),
                        ("p_fr_cap_al_obt_res_2[7]",0.05,"Non-renewable resource fraction remaining"),
                        ("p_fr_cap_al_obt_res_2[8]",0.05,"Non-renewable resource fraction remaining"),
                        ("p_fr_cap_al_obt_res_2[9]",0.05,"Non-renewable resource fraction remaining"),
                        ("p_fr_cap_al_obt_res_2[10]",0.05,"Non-renewable resource fraction remaining"),
                        ("p_fr_cap_al_obt_res_2[11]",0.05,"Non-renewable resource fraction remaining"),
                        ("p_ind_cap_out_ratio_1",3.0,"Default industrial capital output ratio"),
                        ("p_land_yield_fact_1",1.0,"Default land yield factor"),
                        ("p_nr_res_use_fact_1",1.0,"Default non-recoverable resource utilization factor"),
                        ("p_ppoll_gen_fact_1",1.0,"Default persistent pollution generation factor"),
                        ("p_ppoll_tech_chg_mlt[1]",0.0,"Persistent pollution technology change multiplier"),
                        ("p_ppoll_tech_chg_mlt[2]",0.0,"Persistent pollution technology change multiplier"),
                        ("p_ppoll_tech_chg_mlt[3]",0.0,"Persistent pollution technology change multiplier"),
                        ("p_ppoll_tech_chg_mlt[4]",0.0,"Persistent pollution technology change multiplier"),
                        ("p_res_tech_chg_mlt[1]",0.0,"Resource technology change multiplier"),
                        ("p_res_tech_chg_mlt[2]",0.0,"Resource technology change multiplier"),
                        ("p_res_tech_chg_mlt[3]",0.0,"Resource technology change multiplier"),
                        ("p_res_tech_chg_mlt[4]",0.0,"Resource technology change multiplier"),
                        ("p_serv_cap_out_ratio_1",1.0,"Default fraction of service sector output ratio"),
                        ("p_serv_cap_out_ratio_2",1.0,"Controlled fraction of service sector output ratio"),
                        ("p_yield_tech_chg_mlt[1]",0.0,"Yield technology change multiplier"),
                        ("p_yield_tech_chg_mlt[2]",0.0,"Yield technology change multiplier"),
                        ("p_yield_tech_chg_mlt[3]",0.0,"Yield technology change multiplier"),
                        ("p_yield_tech_chg_mlt[4]",0.0,"Yield technology change multiplier"),
                        ("perc_food_ratio_init",1.0,"Initial perceived food ratio"),
                        ("pers_pollution_init",25000000.0,"Initial persistent pollution"),
                        ("pop1_init",650000000.0,"Initial population 14 years and younger"),
                        ("pop2_init",700000000.0,"Initial population 15 to 44 years old"),
                        ("pop3_init",190000000.0,"Initial population 45 to 64 years old"),
                        ("pop4_init",60000000.0,"Initial population 65 years and older"),
                        ("pot_arable_land_init",2300000000.0,"Initial potential arable land"),
                        ("pot_arable_land_tot",3200000000.0,"Total potential arable land"),
                        ("ppoll_in_1970",136000000.0,"Persistent pollution in 1970"),
                        ("ppoll_tech_init",1.0,"Initial persistent pollution technology change factor"),
                        ("ppoll_trans_del",20.0,"Persistent pollution transmission delay"),
                        ("processing_loss",0.1,"Processing loss"),
                        ("reproductive_lifetime",30.0,"Reproductive life time"),
                        ("res_tech_init",1.0,"Initial non-recoverable resource technology factor"),
                        ("service_capital_init",144000000000.0,"Initial service sector investment"),
                        ("social_adj_del",20.0,"Social adjustment delay"),
                        ("social_discount",0.07000000000000001,"Social discount"),
                        ("subsist_food_pc",230.0,"Available per capita food"),
                        ("t_air_poll_time",4000.0,"Air pollution change time"),
                        ("t_fcaor_time",4000.0,"Year of capital allocation to resource use efficiency"),
                        ("t_fert_cont_eff_time",4000.0,"Year of continued fertility change"),
                        ("t_ind_equil_time",4000.0,"Year of industrial equilibrium"),
                        ("t_land_life_time",4000.0,"Land life time"),
                        ("t_policy_year",4000.0,"Year of policy change"),
                        ("t_pop_equil_time",4000.0,"Population equilibrium time"),
                        ("t_zero_pop_grow_time",4000.0,"Time to zero population growth"),
                        ("tech_dev_del_TDD",20.0,"Technology development time"),
                        ("urb_ind_land_dev_time",10.0,"Urban and industrial land development time"),
                        ("urban_ind_land_init",8200000.0,"Initial urban and industrial land"),
                        ("yield_tech_init",1.0,"Initial yield technology factor"),
                        ]

om_TheoParamSensitivity_params_dict = {
             'agr_inp_init': 'P.1',
             'agr_mtl_toxic_index': 'P.2',
             'arable_land_init': 'P.3',
             'assim_half_life_1970': 'P.4',
             'avg_life_land_norm': 'P.5',
             'des_compl_fam_size_norm': 'P.6',
             'des_food_ratio_dfr': 'P.7',
             'des_ppoll_index_DPOLX': 'P.8',
             'des_res_use_rt_DNRUR': 'P.9',
             'food_short_perc_del': 'P.10',
             'fr_agr_inp_pers_mtl': 'P.11',
             'frac_res_pers_mtl': 'P.12',
             'hlth_serv_impact_del': 'P.13',
             'income_expect_avg_time': 'P.14',
             'ind_mtl_emiss_fact': 'P.15',
             'ind_mtl_toxic_index': 'P.16',
             'ind_out_in_1970': 'P.17',
             'ind_out_pc_des': 'P.18',
             'industrial_capital_init': 'P.19',
             'inherent_land_fert': 'P.20',
             'labor_force_partic': 'P.21',
             'labor_util_fr_del_init': 'P.22',
             'labor_util_fr_del_time': 'P.23',
             'land_fertility_init': 'P.24',
             'land_fr_harvested': 'P.25',
             'life_expect_norm': 'P.26',
             'lifet_perc_del': 'P.27',
             'max_tot_fert_norm': 'P.28',
             'nr_resources_init': 'P.29',
             'p_avg_life_agr_inp_1': 'P.30',
             'p_avg_life_agr_inp_2': 'P.31',
             'p_avg_life_ind_cap_1': 'P.32',
             'p_avg_life_ind_cap_2': 'P.33',
             'p_avg_life_serv_cap_1': 'P.34',
             'p_avg_life_serv_cap_2': 'P.35',
             'p_fioa_cons_const_1': 'P.36',
             'p_fioa_cons_const_2': 'P.37',
             'p_fr_cap_al_obt_res_2[10]': 'P.47',
             'p_fr_cap_al_obt_res_2[11]': 'P.48',
             'p_fr_cap_al_obt_res_2[1]': 'P.38',
             'p_fr_cap_al_obt_res_2[2]': 'P.39',
             'p_fr_cap_al_obt_res_2[3]': 'P.40',
             'p_fr_cap_al_obt_res_2[4]': 'P.41',
             'p_fr_cap_al_obt_res_2[5]': 'P.42',
             'p_fr_cap_al_obt_res_2[6]': 'P.43',
             'p_fr_cap_al_obt_res_2[7]': 'P.44',
             'p_fr_cap_al_obt_res_2[8]': 'P.45',
             'p_fr_cap_al_obt_res_2[9]': 'P.46',
             'p_ind_cap_out_ratio_1': 'P.49',
             'p_land_yield_fact_1': 'P.50',
             'p_nr_res_use_fact_1': 'P.51',
             'p_ppoll_gen_fact_1': 'P.52',
             'p_ppoll_tech_chg_mlt[1]': 'P.53',
             'p_ppoll_tech_chg_mlt[2]': 'P.54',
             'p_ppoll_tech_chg_mlt[3]': 'P.55',
             'p_ppoll_tech_chg_mlt[4]': 'P.56',
             'p_res_tech_chg_mlt[1]': 'P.57',
             'p_res_tech_chg_mlt[2]': 'P.58',
             'p_res_tech_chg_mlt[3]': 'P.59',
             'p_res_tech_chg_mlt[4]': 'P.60',
             'p_serv_cap_out_ratio_1': 'P.61',
             'p_serv_cap_out_ratio_2': 'P.62',
             'p_yield_tech_chg_mlt[1]': 'P.63',
             'p_yield_tech_chg_mlt[2]': 'P.64',
             'p_yield_tech_chg_mlt[3]': 'P.65',
             'p_yield_tech_chg_mlt[4]': 'P.66',
             'perc_food_ratio_init': 'P.67',
             'pers_pollution_init': 'P.68',
             'pop1_init': 'P.69',
             'pop2_init': 'P.70',
             'pop3_init': 'P.71',
             'pop4_init': 'P.72',
             'pot_arable_land_init': 'P.73',
             'pot_arable_land_tot': 'P.74',
             'ppoll_in_1970': 'P.75',
             'ppoll_tech_init': 'P.76',
             'ppoll_trans_del': 'P.77',
             'processing_loss': 'P.78',
             'reproductive_lifetime': 'P.79',
             'res_tech_init': 'P.80',
             'service_capital_init': 'P.81',
             'social_adj_del': 'P.82',
             'social_discount': 'P.83',
             'subsist_food_pc': 'P.84',
             't_air_poll_time': 'P.85',
             't_fcaor_time': 'P.86',
             't_fert_cont_eff_time': 'P.87',
             't_ind_equil_time': 'P.88',
             't_land_life_time': 'P.89',
             't_policy_year': 'P.90',
             't_pop_equil_time': 'P.91',
             't_zero_pop_grow_time': 'P.92',
             'tech_dev_del_TDD': 'P.93',
             'urb_ind_land_dev_time': 'P.94',
             'urban_ind_land_init': 'P.95',
             'yield_tech_init': 'P.96'}

om_TheoParamSensitivity_differentiableVariables_dict = {
      'Arable_Land_Dynamics1.Arable_Land.Integrator1.y': 'DV.1',
      'Arable_Land_Dynamics1.Pot_Arable_Land.Integrator1.y': 'DV.2',
      'Arable_Land_Dynamics1.Urban_Ind_Land.Integrator1.y': 'DV.3',
      'Food_Production1.Agr_Inp.Integrator1.y': 'DV.4',
      'Food_Production1.P_Land_Yield_Fact_2.Smooth1.Integrator1.y': 'DV.5',
      'Food_Production1.P_Land_Yield_Fact_2.Smooth2.Integrator1.y': 'DV.6',
      'Food_Production1.P_Land_Yield_Fact_2.Smooth3.Integrator1.y': 'DV.7',
      'Food_Production1.Perc_Food_Ratio.Integrator1.y': 'DV.8',
      'Human_Fertility1.Avg_Ind_Out_PC.Smooth_of_Input.Integrator1.y': 'DV.9',
      'Human_Fertility1.Del_Ind_Out_PC.Smooth1.Integrator1.y': 'DV.10',
      'Human_Fertility1.Del_Ind_Out_PC.Smooth2.Integrator1.y': 'DV.11',
      'Human_Fertility1.Del_Ind_Out_PC.Smooth3.Integrator1.y': 'DV.12',
      'Human_Fertility1.Fert_Cont_Facil_PC.Smooth1.Integrator1.y': 'DV.13',
      'Human_Fertility1.Fert_Cont_Facil_PC.Smooth2.Integrator1.y': 'DV.14',
      'Human_Fertility1.Fert_Cont_Facil_PC.Smooth3.Integrator1.y': 'DV.15',
      'Human_Fertility1.Perc_Life_Expectancy.Smooth1.Integrator1.y': 'DV.16',
      'Human_Fertility1.Perc_Life_Expectancy.Smooth2.Integrator1.y': 'DV.17',
      'Human_Fertility1.Perc_Life_Expectancy.Smooth3.Integrator1.y': 'DV.18',
      'Industrial_Investment1.Industrial_Capital.Integrator1.y': 'DV.19',
      'Labor_Utilization1.Labor_Util_Fr_Del.Integrator1.y': 'DV.20',
      'Land_Fertility1.Land_Fertility.Integrator1.y': 'DV.21',
      'Land_Fertility1.Yield_Tech_LYTD.Integrator1.y': 'DV.22',
      'Life_Expectancy1.Eff_Hlth_Serv_PC.Smooth_of_Input.Integrator1.y': 'DV.23',
      'NR_Resource_Utilization1.NR_Resources.Integrator1.y': 'DV.24',
      'NR_Resource_Utilization1.P_Nr_Res_Use_Fact_2.Smooth1.Integrator1.y': 'DV.25',
      'NR_Resource_Utilization1.P_Nr_Res_Use_Fact_2.Smooth2.Integrator1.y': 'DV.26',
      'NR_Resource_Utilization1.P_Nr_Res_Use_Fact_2.Smooth3.Integrator1.y': 'DV.27',
      'NR_Resource_Utilization1.Res_Tech_NRTD.Integrator1.y': 'DV.28',
      'Pollution_Dynamics1.PPoll_Appear_Rate.Smooth1.Integrator1.y': 'DV.29',
      'Pollution_Dynamics1.PPoll_Appear_Rate.Smooth2.Integrator1.y': 'DV.30',
      'Pollution_Dynamics1.PPoll_Appear_Rate.Smooth3.Integrator1.y': 'DV.31',
      'Pollution_Dynamics1.PPoll_Tech_PTD.Integrator1.y': 'DV.32',
      'Pollution_Dynamics1.P_PPoll_Gen_Fact_2.Smooth1.Integrator1.y': 'DV.33',
      'Pollution_Dynamics1.P_PPoll_Gen_Fact_2.Smooth2.Integrator1.y': 'DV.34',
      'Pollution_Dynamics1.P_PPoll_Gen_Fact_2.Smooth3.Integrator1.y': 'DV.35',
      'Pollution_Dynamics1.Pers_Pollution.Integrator1.y': 'DV.36',
      'Population_Dynamics1.Pop_0_14.Integrator1.y': 'DV.37',
      'Population_Dynamics1.Pop_15_44.Integrator1.y': 'DV.38',
      'Population_Dynamics1.Pop_45_64.Integrator1.y': 'DV.39',
      'Population_Dynamics1.Pop_65plus.Integrator1.y': 'DV.40',
      'Service_Sector_Investment1.Service_Capital.Integrator1.y': 'DV.41'}
om_TheoParamSensitivity_differentiableVariablesExtra_dict = {
        "Population_Dynamics1.pop_state_var_new": "DVextra.1",
        }

om_TheoParamSensitivity_nonDiffVars_dict = {
      "nr_resources": "NDV.1",
      "population": "NDV.2"
      }

# For paper heatmap:
# om_TheoParamSensitivity_differentiableVariables_dict = {
#       'Arable_Land_Dynamics1.Arable_Land.Integrator1.y': 'V.1',
#       'Arable_Land_Dynamics1.Pot_Arable_Land.Integrator1.y': 'V.2',
#       'Arable_Land_Dynamics1.Urban_Ind_Land.Integrator1.y': 'V.3',
#       'Food_Production1.Agr_Inp.Integrator1.y': 'V.4',
#       'Food_Production1.P_Land_Yield_Fact_2.Smooth1.Integrator1.y': 'V.5',
#       'Food_Production1.P_Land_Yield_Fact_2.Smooth2.Integrator1.y': 'V.6',
#       'Food_Production1.P_Land_Yield_Fact_2.Smooth3.Integrator1.y': 'V.7',
#       'Food_Production1.Perc_Food_Ratio.Integrator1.y': 'V.8',
#       'Human_Fertility1.Avg_Ind_Out_PC.Smooth_of_Input.Integrator1.y': 'V.9',
#       'Human_Fertility1.Del_Ind_Out_PC.Smooth1.Integrator1.y': 'V.10',
#       'Human_Fertility1.Del_Ind_Out_PC.Smooth2.Integrator1.y': 'V.11',
#       'Human_Fertility1.Del_Ind_Out_PC.Smooth3.Integrator1.y': 'V.12',
#       'Human_Fertility1.Fert_Cont_Facil_PC.Smooth1.Integrator1.y': 'V.13',
#       'Human_Fertility1.Fert_Cont_Facil_PC.Smooth2.Integrator1.y': 'V.14',
#       'Human_Fertility1.Fert_Cont_Facil_PC.Smooth3.Integrator1.y': 'V.15',
#       'Human_Fertility1.Perc_Life_Expectancy.Smooth1.Integrator1.y': 'V.16',
#       'Human_Fertility1.Perc_Life_Expectancy.Smooth2.Integrator1.y': 'V.17',
#       'Human_Fertility1.Perc_Life_Expectancy.Smooth3.Integrator1.y': 'V.18',
#       'Industrial_Investment1.Industrial_Capital.Integrator1.y': 'V.19',
#       'Labor_Utilization1.Labor_Util_Fr_Del.Integrator1.y': 'V.20',
#       'Land_Fertility1.Land_Fertility.Integrator1.y': 'V.21',
#       'Land_Fertility1.Yield_Tech_LYTD.Integrator1.y': 'V.22',
#       'Life_Expectancy1.Eff_Hlth_Serv_PC.Smooth_of_Input.Integrator1.y': 'V.23',
#       'NR_Resource_Utilization1.NR_Resources.Integrator1.y': 'V.24',
#       'NR_Resource_Utilization1.P_Nr_Res_Use_Fact_2.Smooth1.Integrator1.y': 'V.25',
#       'NR_Resource_Utilization1.P_Nr_Res_Use_Fact_2.Smooth2.Integrator1.y': 'V.26',
#       'NR_Resource_Utilization1.P_Nr_Res_Use_Fact_2.Smooth3.Integrator1.y': 'V.27',
#       'NR_Resource_Utilization1.Res_Tech_NRTD.Integrator1.y': 'V.28',
#       'Pollution_Dynamics1.PPoll_Appear_Rate.Smooth1.Integrator1.y': 'V.29',
#       'Pollution_Dynamics1.PPoll_Appear_Rate.Smooth2.Integrator1.y': 'V.30',
#       'Pollution_Dynamics1.PPoll_Appear_Rate.Smooth3.Integrator1.y': 'V.31',
#       'Pollution_Dynamics1.PPoll_Tech_PTD.Integrator1.y': 'V.32',
#       'Pollution_Dynamics1.P_PPoll_Gen_Fact_2.Smooth1.Integrator1.y': 'V.33',
#       'Pollution_Dynamics1.P_PPoll_Gen_Fact_2.Smooth2.Integrator1.y': 'V.34',
#       'Pollution_Dynamics1.P_PPoll_Gen_Fact_2.Smooth3.Integrator1.y': 'V.35',
#       'Pollution_Dynamics1.Pers_Pollution.Integrator1.y': 'V.36',
#       'Population_Dynamics1.Pop_0_14.Integrator1.y': 'V.37',
#       'Population_Dynamics1.Pop_15_44.Integrator1.y': 'V.38',
#       'Population_Dynamics1.Pop_45_64.Integrator1.y': 'V.39',
#       'Population_Dynamics1.Pop_65plus.Integrator1.y': 'V.40',
#       'Service_Sector_Investment1.Service_Capital.Integrator1.y': 'V.41'}
#
# om_TheoParamSensitivity_nonDiffVars_dict = {
#       "nr_resources": "V.42",
#       "population": "V.43"
#       }
