/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.antlr.Tool;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.OrderedHashSet;
import org.antlr.misc.Utils;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;

public class DOTGenerator {
    public static final boolean STRIP_NONREDUCED_STATES = false;
    protected String arrowhead = "normal";
    protected String rankdir = "LR";
    public static StringTemplateGroup stlib = new StringTemplateGroup("toollib", AngleBracketTemplateLexer.class);
    protected Set markedStates = null;
    protected Grammar grammar;

    public DOTGenerator(Grammar grammar) {
        this.grammar = grammar;
    }

    public String getDOT(State startState) {
        if (startState == null) {
            return null;
        }
        StringTemplate dot = null;
        this.markedStates = new HashSet();
        if (startState instanceof DFAState) {
            dot = stlib.getInstanceOf("org/antlr/tool/templates/dot/dfa");
            dot.setAttribute("startState", Utils.integer(startState.stateNumber));
            dot.setAttribute("useBox", Tool.internalOption_ShowNFAConfigsInDFA);
            this.walkCreatingDFADOT(dot, (DFAState)startState);
        } else {
            dot = stlib.getInstanceOf("org/antlr/tool/templates/dot/nfa");
            dot.setAttribute("startState", Utils.integer(startState.stateNumber));
            this.walkRuleNFACreatingDOT(dot, startState);
        }
        dot.setAttribute("rankdir", this.rankdir);
        return dot.toString();
    }

    protected void walkCreatingDFADOT(StringTemplate dot, DFAState s) {
        if (this.markedStates.contains(Utils.integer(s.stateNumber))) {
            return;
        }
        this.markedStates.add(Utils.integer(s.stateNumber));
        StringTemplate st = s.isAcceptState() ? stlib.getInstanceOf("org/antlr/tool/templates/dot/stopstate") : stlib.getInstanceOf("org/antlr/tool/templates/dot/state");
        st.setAttribute("name", this.getStateLabel(s));
        dot.setAttribute("states", st);
        for (int i = 0; i < s.getNumberOfTransitions(); ++i) {
            Transition edge = s.transition(i);
            st = stlib.getInstanceOf("org/antlr/tool/templates/dot/edge");
            st.setAttribute("label", this.getEdgeLabel(edge));
            st.setAttribute("src", this.getStateLabel(s));
            st.setAttribute("target", this.getStateLabel(edge.target));
            st.setAttribute("arrowhead", this.arrowhead);
            dot.setAttribute("edges", st);
            this.walkCreatingDFADOT(dot, (DFAState)edge.target);
        }
    }

    protected void walkRuleNFACreatingDOT(StringTemplate dot, State s) {
        GrammarAST n;
        if (this.markedStates.contains(s)) {
            return;
        }
        this.markedStates.add(s);
        StringTemplate stateST = s.isAcceptState() ? stlib.getInstanceOf("org/antlr/tool/templates/dot/stopstate") : stlib.getInstanceOf("org/antlr/tool/templates/dot/state");
        stateST.setAttribute("name", this.getStateLabel(s));
        dot.setAttribute("states", stateST);
        if (s.isAcceptState()) {
            return;
        }
        if (((NFAState)s).isDecisionState() && (n = ((NFAState)s).associatedASTNode) != null && n.getType() != 19) {
            StringTemplate rankST = stlib.getInstanceOf("org/antlr/tool/templates/dot/decision-rank");
            NFAState alt = (NFAState)s;
            while (alt != null) {
                rankST.setAttribute("states", this.getStateLabel(alt));
                if (alt.transition[1] != null) {
                    alt = (NFAState)alt.transition[1].target;
                    continue;
                }
                alt = null;
            }
            dot.setAttribute("decisionRanks", rankST);
        }
        StringTemplate edgeST = null;
        for (int i = 0; i < s.getNumberOfTransitions(); ++i) {
            Transition edge = s.transition(i);
            if (edge instanceof RuleClosureTransition) {
                RuleClosureTransition rr = (RuleClosureTransition)edge;
                edgeST = stlib.getInstanceOf("org/antlr/tool/templates/dot/edge");
                if (rr.rule.grammar != this.grammar) {
                    edgeST.setAttribute("label", "<" + rr.rule.grammar.name + "." + rr.rule.name + ">");
                } else {
                    edgeST.setAttribute("label", "<" + rr.rule.name + ">");
                }
                edgeST.setAttribute("src", this.getStateLabel(s));
                edgeST.setAttribute("target", this.getStateLabel(rr.followState));
                edgeST.setAttribute("arrowhead", this.arrowhead);
                dot.setAttribute("edges", edgeST);
                this.walkRuleNFACreatingDOT(dot, rr.followState);
                continue;
            }
            edgeST = edge.isAction() ? stlib.getInstanceOf("org/antlr/tool/templates/dot/action-edge") : (edge.isEpsilon() ? stlib.getInstanceOf("org/antlr/tool/templates/dot/epsilon-edge") : stlib.getInstanceOf("org/antlr/tool/templates/dot/edge"));
            edgeST.setAttribute("label", this.getEdgeLabel(edge));
            edgeST.setAttribute("src", this.getStateLabel(s));
            edgeST.setAttribute("target", this.getStateLabel(edge.target));
            edgeST.setAttribute("arrowhead", this.arrowhead);
            dot.setAttribute("edges", edgeST);
            this.walkRuleNFACreatingDOT(dot, edge.target);
        }
    }

    protected String getEdgeLabel(Transition edge) {
        SemanticContext preds;
        String label = edge.label.toString(this.grammar);
        label = Utils.replace(label, "\\", "\\\\");
        label = Utils.replace(label, "\"", "\\\"");
        label = Utils.replace(label, "\n", "\\\\n");
        if ((label = Utils.replace(label, "\r", "")).equals("<EPSILON>")) {
            label = "e";
        }
        State target = edge.target;
        if (!edge.isSemanticPredicate() && target instanceof DFAState && (preds = ((DFAState)target).getGatedPredicatesInNFAConfigurations()) != null) {
            String predsStr = "";
            predsStr = "&&{" + preds.genExpr(this.grammar.generator, this.grammar.generator.getTemplates(), null).toString() + "}?";
            label = label + predsStr;
        }
        return label;
    }

    protected String getStateLabel(State s) {
        if (s == null) {
            return "null";
        }
        String stateLabel = String.valueOf(s.stateNumber);
        if (s instanceof DFAState) {
            StringBuffer buf = new StringBuffer(250);
            buf.append('s');
            buf.append(s.stateNumber);
            if (Tool.internalOption_ShowNFAConfigsInDFA) {
                Set alts;
                if (s instanceof DFAState && ((DFAState)s).abortedDueToRecursionOverflow) {
                    buf.append("\\n");
                    buf.append("abortedDueToRecursionOverflow");
                }
                if ((alts = ((DFAState)s).getAltSet()) != null) {
                    buf.append("\\n");
                    ArrayList altList = new ArrayList();
                    altList.addAll(alts);
                    Collections.sort(altList);
                    OrderedHashSet<NFAConfiguration> configurations = ((DFAState)s).nfaConfigurations;
                    for (int altIndex = 0; altIndex < altList.size(); ++altIndex) {
                        Integer altI = (Integer)altList.get(altIndex);
                        int alt = altI;
                        if (altIndex > 0) {
                            buf.append("\\n");
                        }
                        buf.append("alt");
                        buf.append(alt);
                        buf.append(':');
                        ArrayList<NFAConfiguration> configsInAlt = new ArrayList<NFAConfiguration>();
                        for (NFAConfiguration c : configurations) {
                            if (c.alt != alt) continue;
                            configsInAlt.add(c);
                        }
                        int n = 0;
                        for (int cIndex = 0; cIndex < configsInAlt.size(); ++cIndex) {
                            NFAConfiguration c = (NFAConfiguration)configsInAlt.get(cIndex);
                            ++n;
                            buf.append(c.toString(false));
                            if (cIndex + 1 < configsInAlt.size()) {
                                buf.append(", ");
                            }
                            if (n % 5 != 0 || configsInAlt.size() - cIndex <= 3) continue;
                            buf.append("\\n");
                        }
                    }
                }
            }
            stateLabel = buf.toString();
        }
        if (s instanceof NFAState && ((NFAState)s).isDecisionState()) {
            stateLabel = stateLabel + ",d=" + ((NFAState)s).getDecisionNumber();
            if (((NFAState)s).endOfBlockStateNumber != -1) {
                stateLabel = stateLabel + ",eob=" + ((NFAState)s).endOfBlockStateNumber;
            }
        } else if (s instanceof NFAState && ((NFAState)s).endOfBlockStateNumber != -1) {
            NFAState n = (NFAState)s;
            stateLabel = stateLabel + ",eob=" + n.endOfBlockStateNumber;
        } else if (s instanceof DFAState && ((DFAState)s).isAcceptState()) {
            stateLabel = stateLabel + "=>" + ((DFAState)s).getUniquelyPredictedAlt();
        }
        return '\"' + stateLabel + '\"';
    }

    public String getArrowheadType() {
        return this.arrowhead;
    }

    public void setArrowheadType(String arrowhead) {
        this.arrowhead = arrowhead;
    }

    public String getRankdir() {
        return this.rankdir;
    }

    public void setRankdir(String rankdir) {
        this.rankdir = rankdir;
    }
}

