/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.test;

import java.util.Collection;
import java.util.Iterator;
import org.graphstream.graph.Edge;
import org.graphstream.graph.EdgeFactory;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.NodeFactory;
import org.graphstream.graph.implementations.AbstractEdge;
import org.graphstream.graph.implementations.AbstractGraph;
import org.graphstream.graph.implementations.AbstractNode;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.graph.implementations.AdjacencyListNode;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.graph.implementations.MultiNode;
import org.graphstream.graph.implementations.SingleGraph;
import org.graphstream.graph.implementations.SingleNode;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericity {
    @Test
    public void checkAdjacencyListGraph() {
        AdjacencyListGraph g = new AdjacencyListGraph("g");
        g.setNodeFactory(new MyALGNodeFactory());
        g.setEdgeFactory(new MyALGEdgeFactory());
        new TestAddRemoveNode(g);
        new TestForEachNode(g);
        new TestNodeCollection(g);
        new TestAddRemoveEdge(g);
        new TestForEachEdge(g);
        new TestEdgeCollection(g);
        new TestNodeEdgeSet(g);
        new TestNodeNeighborhood(g);
        new TestEdgeExtremities(g);
    }

    @Test
    public void checkSingleGraph() {
        SingleGraph g = new SingleGraph("g");
        g.setNodeFactory(new MySingleNodeFactory());
        g.setEdgeFactory(new MySingleEdgeFactory());
        new TestAddRemoveNode(g);
        new TestForEachNode(g);
        new TestNodeCollection(g);
        new TestAddRemoveEdge(g);
        new TestForEachEdge(g);
        new TestEdgeCollection(g);
        new TestNodeEdgeSet(g);
        new TestNodeNeighborhood(g);
        new TestEdgeExtremities(g);
    }

    @Test
    public void checkMultiGraph() {
        MultiGraph g = new MultiGraph("g");
        g.setNodeFactory(new MyMultiNodeFactory());
        g.setEdgeFactory(new MyMultiEdgeFactory());
        new TestAddRemoveNode(g);
        new TestForEachNode(g);
        new TestNodeCollection(g);
        new TestAddRemoveEdge(g);
        new TestForEachEdge(g);
        new TestEdgeCollection(g);
        new TestNodeEdgeSet(g);
        new TestNodeNeighborhood(g);
        new TestEdgeExtremities(g);
    }

    protected static class BadTypedEdge
    extends AbstractEdge {
        protected BadTypedEdge(String id, Node src, Node dst, boolean directed) {
            super(id, (AbstractNode)src, (AbstractNode)dst, directed);
        }
    }

    protected static class BadTypedNode
    extends SingleNode {
        public BadTypedNode(Graph graph, String id) {
            super((AbstractGraph)graph, id);
        }
    }

    protected static class MyALGEdge
    extends AbstractEdge {
        protected MyALGEdge(String id, Node src, Node dst, boolean directed) {
            super(id, (AbstractNode)src, (AbstractNode)dst, directed);
        }
    }

    protected static class MyALGEdgeFactory
    implements EdgeFactory<MyALGEdge> {
        protected MyALGEdgeFactory() {
        }

        @Override
        public MyALGEdge newInstance(String id, Node src, Node dst, boolean directed) {
            return new MyALGEdge(id, src, dst, directed);
        }
    }

    protected static class MyALGNode
    extends AdjacencyListNode {
        public MyALGNode(Graph graph, String id) {
            super((AbstractGraph)graph, id);
        }
    }

    protected static class MyALGNodeFactory
    implements NodeFactory<MyALGNode> {
        protected MyALGNodeFactory() {
        }

        @Override
        public MyALGNode newInstance(String id, Graph graph) {
            return new MyALGNode(graph, id);
        }
    }

    protected static class MyMultiEdge
    extends AbstractEdge {
        protected MyMultiEdge(String id, Node src, Node dst, boolean directed) {
            super(id, (AbstractNode)src, (AbstractNode)dst, directed);
        }
    }

    protected static class MyMultiEdgeFactory
    implements EdgeFactory<MyMultiEdge> {
        protected MyMultiEdgeFactory() {
        }

        @Override
        public MyMultiEdge newInstance(String id, Node src, Node dst, boolean directed) {
            return new MyMultiEdge(id, src, dst, directed);
        }
    }

    protected static class MyMultiNode
    extends MultiNode {
        public MyMultiNode(Graph graph, String id) {
            super((AbstractGraph)graph, id);
        }
    }

    protected static class MyMultiNodeFactory
    implements NodeFactory<MyMultiNode> {
        protected MyMultiNodeFactory() {
        }

        @Override
        public MyMultiNode newInstance(String id, Graph graph) {
            return new MyMultiNode(graph, id);
        }
    }

    protected static class MySingleEdge
    extends AbstractEdge {
        protected MySingleEdge(String id, Node src, Node dst, boolean directed) {
            super(id, (AbstractNode)src, (AbstractNode)dst, directed);
        }
    }

    protected static class MySingleEdgeFactory
    implements EdgeFactory<MySingleEdge> {
        protected MySingleEdgeFactory() {
        }

        @Override
        public MySingleEdge newInstance(String id, Node src, Node dst, boolean directed) {
            return new MySingleEdge(id, src, dst, directed);
        }
    }

    protected static class MySingleNode
    extends SingleNode {
        public MySingleNode(Graph graph, String id) {
            super((AbstractGraph)graph, id);
        }
    }

    protected static class MySingleNodeFactory
    implements NodeFactory<MySingleNode> {
        protected MySingleNodeFactory() {
        }

        @Override
        public MySingleNode newInstance(String id, Graph graph) {
            return new MySingleNode(graph, id);
        }
    }

    static class TestAddRemoveEdge<A extends Edge> {
        TestAddRemoveEdge(Graph g) {
            BadTypedEdge bte2;
            Object t;
            Object goodTypedEdge;
            g.clear();
            g.addNode("0");
            g.addNode("1");
            g.addNode("2");
            g.addNode("3");
            g.addNode("4");
            g.addNode("5");
            try {
                goodTypedEdge = g.addEdge("e0", "0", "1");
                t = g.addEdge("e1", "1", "2");
            }
            catch (ClassCastException e) {
                Assert.fail();
            }
            try {
                bte2 = (BadTypedEdge)g.addEdge("e2", "2", "3");
                Assert.fail();
            }
            catch (ClassCastException bte2) {
                // empty catch block
            }
            Assert.assertNotNull(g.getEdge("e0"));
            Assert.assertNotNull(g.getEdge("e1"));
            Assert.assertNotNull(g.getEdge("e2"));
            try {
                goodTypedEdge = g.getEdge("e0");
                goodTypedEdge = g.getEdge("e1");
                goodTypedEdge = g.getEdge("e2");
                Object e = g.getEdge("e0");
                e = g.getEdge("e1");
                t = g.getEdge("e2");
            }
            catch (ClassCastException e) {
                Assert.fail();
            }
            try {
                bte2 = (BadTypedEdge)g.getEdge("e0");
                Assert.fail();
                bte2 = (BadTypedEdge)g.getEdge("e1");
                Assert.fail();
                bte2 = (BadTypedEdge)g.getEdge("e2");
                Assert.fail();
            }
            catch (ClassCastException bte3) {
                // empty catch block
            }
            try {
                goodTypedEdge = g.removeEdge("e0");
                t = g.removeEdge("e1");
            }
            catch (ClassCastException e) {
                Assert.fail();
            }
            try {
                bte2 = (BadTypedEdge)g.removeEdge("e2");
                Assert.fail();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            Assert.assertNull(g.getEdge("e0"));
            Assert.assertNull(g.getEdge("e1"));
            Assert.assertNull(g.getEdge("e2"));
        }
    }

    static class TestAddRemoveNode<A extends Node> {
        TestAddRemoveNode(Graph g) {
            BadTypedNode badTypedNode;
            Object simpleNode;
            Object goodTypedNode;
            try {
                goodTypedNode = g.addNode("test-add-remove-node-A");
                simpleNode = g.addNode("test-add-remove-node-N");
            }
            catch (ClassCastException e) {
                Assert.fail();
            }
            try {
                badTypedNode = (BadTypedNode)g.addNode("test-add-remove-node-B");
                System.err.println(badTypedNode.getClass());
                Assert.fail();
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            Assert.assertNotNull(g.getNode("test-add-remove-node-A"));
            Assert.assertNotNull(g.getNode("test-add-remove-node-B"));
            Assert.assertNotNull(g.getNode("test-add-remove-node-N"));
            try {
                badTypedNode = (BadTypedNode)g.getNode("test-add-remove-node-A");
                Assert.fail();
                badTypedNode = (BadTypedNode)g.getNode("test-add-remove-node-B");
                Assert.fail();
                badTypedNode = (BadTypedNode)g.getNode("test-add-remove-node-N");
                Assert.fail();
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            try {
                goodTypedNode = g.getNode("test-add-remove-node-A");
                goodTypedNode = g.getNode("test-add-remove-node-B");
                goodTypedNode = g.getNode("test-add-remove-node-N");
                simpleNode = g.getNode("test-add-remove-node-A");
                simpleNode = g.getNode("test-add-remove-node-B");
                simpleNode = g.getNode("test-add-remove-node-N");
            }
            catch (ClassCastException e) {
                Assert.fail();
            }
            try {
                simpleNode = g.removeNode("test-add-remove-node-A");
                goodTypedNode = g.removeNode("test-add-remove-node-B");
            }
            catch (ClassCastException e) {
                Assert.fail();
            }
            try {
                badTypedNode = (BadTypedNode)g.removeNode("test-add-remove-node-N");
                Assert.fail();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            Assert.assertNull(g.getNode("test-add-remove-node-A"));
            Assert.assertNull(g.getNode("test-add-remove-node-B"));
            Assert.assertNull(g.getNode("test-add-remove-node-N"));
        }
    }

    static class TestEdgeCollection<A extends Edge> {
        TestEdgeCollection(Graph g) {
            g.clear();
            int i = 0;
            while (i < 10) {
                g.addNode(String.format("node-%02d", i));
                ++i;
            }
            i = 0;
            while (i < 9) {
                g.addEdge(String.format("edge-%02d", i), String.format("node-%02d", i), String.format("node-%02d", i + 1));
                ++i;
            }
            try {
                Collection cA = g.getEdgeSet();
                for (Edge edge : cA) {
                }
                Collection cEdge = g.getEdgeSet();
                for (Object object : cEdge) {
                }
            }
            catch (ClassCastException e) {
                Assert.fail();
            }
            try {
                Collection cB = g.getEdgeSet();
                for (Edge bte : cB) {
                    Assert.fail();
                }
            }
            catch (ClassCastException cB) {
                // empty catch block
            }
            try {
                Iterator iA = g.getEdgeIterator();
                while (iA.hasNext()) {
                    Edge bte;
                    bte = (Edge)iA.next();
                }
                Iterator iE = g.getEdgeIterator();
                while (iE.hasNext()) {
                    Object object;
                    object = (Edge)iE.next();
                }
            }
            catch (ClassCastException e) {
                Assert.fail();
            }
            try {
                Iterator iB = g.getEdgeIterator();
                while (iB.hasNext()) {
                    Edge edge;
                    edge = (BadTypedEdge)iB.next();
                }
                Assert.fail();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            g.clear();
        }
    }

    static class TestEdgeExtremities<A extends Node> {
        TestEdgeExtremities(Graph g) {
            Object nodeA;
            g.clear();
            g.addNode("0");
            g.addNode("1");
            g.addEdge("A", "0", "1");
            Object edge = g.getEdge("A");
            try {
                nodeA = edge.getNode0();
                nodeA = edge.getSourceNode();
                nodeA = edge.getNode1();
                nodeA = edge.getTargetNode();
            }
            catch (ClassCastException e) {
                Assert.fail();
            }
            try {
                nodeA = edge.getNode0();
                nodeA = edge.getSourceNode();
                nodeA = edge.getNode1();
                nodeA = edge.getTargetNode();
            }
            catch (ClassCastException e) {
                Assert.fail();
            }
            try {
                nodeA = (BadTypedNode)edge.getNode0();
                Assert.fail();
                nodeA = (BadTypedNode)edge.getSourceNode();
                Assert.fail();
                nodeA = (BadTypedNode)edge.getNode1();
                Assert.fail();
                nodeA = (BadTypedNode)edge.getTargetNode();
                Assert.fail();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            g.clear();
        }
    }

    static class TestForEachEdge<A extends Edge> {
        TestForEachEdge(Graph g) {
            g.clear();
            int i = 0;
            while (i < 10) {
                g.addNode(String.format("node-%02d", i));
                ++i;
            }
            i = 0;
            while (i < 9) {
                g.addEdge(String.format("edge-%02d", i), String.format("node-%02d", i), String.format("node-%02d", i + 1));
                ++i;
            }
            try {
                for (Edge i2 : g.getEachEdge()) {
                }
                for (Edge i2 : g.getEachEdge()) {
                }
            }
            catch (ClassCastException e) {
                Assert.fail();
            }
            try {
                for (BadTypedEdge bte : g.getEachEdge()) {
                    Assert.fail();
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            g.clear();
        }
    }

    static class TestForEachNode<A extends Node> {
        TestForEachNode(Graph g) {
            g.clear();
            int i2 = 0;
            while (i2 < 10) {
                g.addNode(String.format("test-for-each-%02d", i2));
                ++i2;
            }
            try {
                for (Node i2 : g.getEachNode()) {
                }
                for (Node i2 : g.getEachNode()) {
                }
            }
            catch (ClassCastException e) {
                Assert.fail();
            }
            try {
                for (BadTypedNode badTypedNode : g.getEachNode()) {
                    Assert.fail();
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            g.clear();
        }
    }

    static class TestNodeCollection<A extends Node> {
        TestNodeCollection(Graph g) {
            g.clear();
            int i = 0;
            while (i < 10) {
                g.addNode(String.format("node-%02d", i));
                ++i;
            }
            try {
                Collection cA = g.getNodeSet();
                for (Node node : cA) {
                }
                Collection cNode = g.getNodeSet();
                for (Object object : cNode) {
                }
            }
            catch (ClassCastException e) {
                Assert.fail();
            }
            try {
                Collection cB = g.getNodeSet();
                for (Node n : cB) {
                    Assert.fail();
                }
            }
            catch (ClassCastException cB) {
                // empty catch block
            }
            try {
                Iterator iA = g.getNodeIterator();
                while (iA.hasNext()) {
                    Node n;
                    n = (Node)iA.next();
                }
                Iterator iN = g.getNodeIterator();
                while (iN.hasNext()) {
                    Object object;
                    object = (Node)iN.next();
                }
            }
            catch (ClassCastException e) {
                Assert.fail();
            }
            try {
                Iterator iB = g.getNodeIterator();
                while (iB.hasNext()) {
                    BadTypedNode btn = (BadTypedNode)iB.next();
                    Assert.fail();
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            g.clear();
        }
    }

    static class TestNodeEdgeSet<A extends Edge> {
        TestNodeEdgeSet(Graph g) {
            BadTypedEdge e;
            Iterator iB2;
            g.clear();
            g.addNode("root");
            int i = 0;
            while (i < 10) {
                g.addNode(String.format("ext-%02d", i));
                g.addEdge(String.format("edge-%02d", i), "root", String.format("ext-%02d", i));
                ++i;
            }
            Object root = g.getNode("root");
            try {
                Object object;
                Object edge;
                for (Edge edge2 : root.getEdgeSet()) {
                }
                for (Edge edge2 : root.getEdgeSet()) {
                }
                int i2 = 0;
                while (i2 < 10) {
                    edge = root.getEdge(i2);
                    object = root.getEdge(i2);
                    ++i2;
                }
                Iterator iA = root.getLeavingEdgeIterator();
                while (iA.hasNext()) {
                    edge = (Edge)iA.next();
                }
                iA = root.getEnteringEdgeIterator();
                while (iA.hasNext()) {
                    edge = (Edge)iA.next();
                }
                Iterator iE = root.getLeavingEdgeIterator();
                while (iE.hasNext()) {
                    object = (Edge)iE.next();
                }
                iE = root.getEnteringEdgeIterator();
                while (iE.hasNext()) {
                    object = (Edge)iE.next();
                }
            }
            catch (ClassCastException e2) {
                Assert.fail();
            }
            catch (UnsupportedOperationException e2) {
                // empty catch block
            }
            try {
                for (BadTypedEdge bte : root.getEdgeSet()) {
                    Assert.fail();
                }
            }
            catch (ClassCastException bte) {
                // empty catch block
            }
            try {
                int i3 = 0;
                while (i3 < 10) {
                    BadTypedEdge bte = (BadTypedEdge)g.getEdge(String.format("edge-%02d", i3));
                    Assert.fail();
                    ++i3;
                }
            }
            catch (ClassCastException i3) {
                // empty catch block
            }
            try {
                iB2 = root.getLeavingEdgeIterator();
                while (iB2.hasNext()) {
                    e = (BadTypedEdge)iB2.next();
                    Assert.fail();
                }
            }
            catch (ClassCastException iB2) {
            }
            catch (UnsupportedOperationException iB2) {
                // empty catch block
            }
            try {
                iB2 = root.getEnteringEdgeIterator();
                while (iB2.hasNext()) {
                    e = (BadTypedEdge)iB2.next();
                    Assert.fail();
                }
            }
            catch (ClassCastException classCastException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            g.clear();
        }
    }

    static class TestNodeNeighborhood<A extends Node> {
        TestNodeNeighborhood(Graph g) {
            g.clear();
            g.addNode("root");
            int i = 0;
            while (i < 10) {
                g.addNode(String.format("ext-%02d", i));
                g.addEdge(String.format("edge-%02d", i), "root", String.format("ext-%02d", i));
                ++i;
            }
            Object root = g.getNode("root");
            try {
                Node node;
                Node node2;
                Iterator iA = root.getBreadthFirstIterator();
                while (iA.hasNext()) {
                    node2 = (Node)iA.next();
                }
                iA = root.getDepthFirstIterator();
                while (iA.hasNext()) {
                    node2 = (Node)iA.next();
                }
                Iterator iN = root.getBreadthFirstIterator();
                while (iN.hasNext()) {
                    node = (Node)iN.next();
                }
                iN = root.getDepthFirstIterator();
                while (iN.hasNext()) {
                    node = (Node)iN.next();
                }
            }
            catch (ClassCastException e) {
                Assert.fail();
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            try {
                BadTypedNode node;
                Iterator iB = root.getBreadthFirstIterator();
                while (iB.hasNext()) {
                    node = (BadTypedNode)iB.next();
                    Assert.fail();
                }
                iB = root.getDepthFirstIterator();
                while (iB.hasNext()) {
                    node = (BadTypedNode)iB.next();
                    Assert.fail();
                }
            }
            catch (ClassCastException classCastException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            g.clear();
        }
    }
}

