/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util;

import java.util.Iterator;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.util.Filter;

public class FilteredEdgeIterator<T extends Edge>
implements Iterator<T> {
    protected Iterator<T> globalIterator;
    protected Filter<Edge> filter;
    protected T next;

    public FilteredEdgeIterator(Graph g, Filter<Edge> filter) {
        this(g.getEdgeIterator(), filter);
    }

    public FilteredEdgeIterator(Iterator<T> ite, Filter<Edge> filter) {
        this.globalIterator = ite;
        this.filter = filter;
        this.findNext();
    }

    protected void findNext() {
        this.next = null;
        while (this.globalIterator.hasNext() && this.next == null) {
            this.next = (Edge)this.globalIterator.next();
            if (this.filter.isAvailable((Edge)this.next)) continue;
            this.next = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        T tmp = this.next;
        this.findNext();
        return tmp;
    }

    @Override
    public void remove() {
    }
}

