  optimization FreeFloatingRobot(
        objectiveIntegrand = 0.5*(u1^2 +u2^2+u3^2+u4^2),
  objective = (x1(finalTime)-4)^2 +(x2(finalTime))^2 + (x3(finalTime)-4)^2 + (x4(finalTime))^2 + (x5(finalTime))^2 + (x6(finalTime))^2,
        startTime=0, finalTime=5)

    Real x1(start=0, fixed=true);
    Real x2(start=0, fixed=true);
    Real x3(start=0, fixed=true);
    Real x4(start=0, fixed=true);
    Real x5(start=0, fixed=true);
    Real x6(start=0, fixed=true);

    input Real u1;
    input Real u2;
    input Real u3;
    input Real u4;
    
    parameter Real M = 10;
    parameter Real D = 5;
    parameter Real Le = 5;
    parameter Real In = 12;
    Real s5;
    Real c5;
  equation
    der(x1) = x2;
    der(x2) = ((u1 + u3)*c5 - (u2 + u4)*s5)/M;
    der(x3) = x4;
    der(x4) = ((u1 + u3)*s5 - (u2 + u4)*c5)/M;
    der(x5) = x6;
    der(x6) = ((u1 + u3)*D - (u2 + u4)*Le)/In;
  
    s5 = sin(x5);
    c5 = cos(x5);

  end FreeFloatingRobot;
