// $Id: WidgetSelectModModel.h 20164 2014-04-16 09:06:22Z hudson $
/**
 * This file is part of OpenModelica.
 *
 * Copyright (c) 1998-CurrentYear, Open Source Modelica Consortium (OSMC),
 * c/o Linköpings universitet, Department of Computer and Information Science,
 * SE-58183 Linköping, Sweden.
 *
 * All rights reserved.
 *
 * THIS PROGRAM IS PROVIDED UNDER THE TERMS OF GPL VERSION 3 LICENSE OR
 * THIS OSMC PUBLIC LICENSE (OSMC-PL).
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS PROGRAM CONSTITUTES RECIPIENT'S ACCEPTANCE
 * OF THE OSMC PUBLIC LICENSE OR THE GPL VERSION 3, ACCORDING TO RECIPIENTS CHOICE.
 *
 * The OpenModelica software and the Open Source Modelica
 * Consortium (OSMC) Public License (OSMC-PL) are obtained
 * from OSMC, either from the above address,
 * from the URLs: http://www.ida.liu.se/projects/OpenModelica or
 * http://www.openmodelica.org, and in the OpenModelica distribution.
 * GNU version 3 is obtained from: http://www.gnu.org/copyleft/gpl.html.
 *
 * This program is distributed WITHOUT ANY WARRANTY; without
 * even the implied warranty of  MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE, EXCEPT AS EXPRESSLY SET FORTH
 * IN THE BY RECIPIENT SELECTED SUBSIDIARY LICENSE CONDITIONS OF OSMC-PL.
 *
 * See the full OSMC Public License conditions for more details.
 *
 * Main contributor 2010, Hubert Thierot, CEP - ARMINES (France)

    @file WidgetSelectModModel.h
    @brief Comments for file documentation.
    @author Hubert Thieriot, hubert.thieriot@mines-paristech.fr
    Company : CEP - ARMINES (France)
    http://www-cep.ensmp.fr/english/
    @version
*/

#ifndef WidgetSelectModModel_H
#define WidgetSelectModModel_H

#include <QtGui/QDialog>
#include <QtGui/QWidget>


#include "ModItem.h"
#include "ModItemsTree.h"
#include "ProblemInterface.h"


namespace Ui {
class WidgetSelectModModelClass;
}


class WidgetSelectModModel : public QDialog {
    Q_OBJECT


public:
    explicit WidgetSelectModModel(ModItemsTree* modItemsTree,ProblemInterface::ModelNeeds needs,QWidget *parent);
    virtual ~WidgetSelectModModel();



public:
    Ui::WidgetSelectModModelClass *ui;

    QList<ModItem *> _selectedModels;
    void setSelectedModModel(QList<ModItem *> modClasses);

public slots :
    void onSelectedModItem(QModelIndex);

private :
    ModItemsTree *_modItemsTree;
    ProblemInterface::ModelNeeds _needs;

};

#endif
