/*
 * This file is part of OpenModelica.
 *
 * Copyright (c) 1998-2010, Linköpings University,
 * Department of Computer and Information Science,
 * SE-58183 Linköping, Sweden.
 *
 * All rights reserved.
 *
 * THIS PROGRAM IS PROVIDED UNDER THE TERMS OF THIS OSMC PUBLIC
 * LICENSE (OSMC-PL). ANY USE, REPRODUCTION OR DISTRIBUTION OF
 * THIS PROGRAM CONSTITUTES RECIPIENT'S ACCEPTANCE OF THE OSMC
 * PUBLIC LICENSE.
 *
 * The OpenModelica software and the Open Source Modelica
 * Consortium (OSMC) Public License (OSMC-PL) are obtained
 * from Linköpings University, either from the above address,
 * from the URL: http://www.ida.liu.se/projects/OpenModelica
 * and in the OpenModelica distribution.
 *
 * This program is distributed  WITHOUT ANY WARRANTY; without
 * even the implied warranty of  MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE, EXCEPT AS EXPRESSLY SET FORTH
 * IN THE BY RECIPIENT SELECTED SUBSIDIARY LICENSE CONDITIONS
 * OF OSMC-PL.
 *
 * See the full OSMC Public License conditions for more details.
 *
 * For more information about the Qt-library visit TrollTech's webpage
 * regarding the Qt licence: http://www.trolltech.com/products/qt/licensing.html
 */

/*!
* \file VisualizeApplication.h
* \author Peter Arvidsson
* \date 2012
*/
#ifndef VISUALIZEAPPLICATION_H
#define VISUALIZEAPPLICATION_H

#include <QApplication>
#include <QSharedMemory>
#include <QStringList>
#include <QDebug>

namespace OMVisualize
{
class VisualizeApplication : public QApplication
{
  Q_OBJECT
public:
  /*! \brief Constructor of singleapplication*/
  VisualizeApplication(int &argc, char* argv[], const QString uniqueKey);
  /*! \brief Get _isRunning*/
  bool isRunning();
  /*! \brief Sends a message if a new application is started*/
  void sendMessage(QStringList arguments);
  void launchNewApplication(QStringList arguments);
  virtual bool notify(QObject *receiver, QEvent *event);
private:
  /*! \brief Knows if application is running or not*/
  bool mIsRunning;
  /*! \brief The shared memory used by applications to send message between each other*/
  QSharedMemory mSharedMemory;
  QTimer *mpTimer;
public slots:
  /*! \brief Checks if a new application have sent a message*/
  void checkForMessage();
signals:
  /*! \brief Signalize a message if a new application have started*/
  void messageAvailable(QStringList arguments);
  void newApplicationLaunched(QStringList arguments);
};
}
#endif // VISUALIZEAPPLICATION_H
