#ifndef OpenModelicaScriptingAPI__H
#define OpenModelicaScriptingAPI__H
#include "meta/meta_modelica.h"
#include "util/modelica.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#ifdef __cplusplus
extern "C" {
#endif

extern struct record_description Absyn_CodeNode_C__TYPENAME__desc;
extern struct record_description Absyn_Msg_MSG__desc;
extern struct record_description SourceInfo_SOURCEINFO__desc;
extern struct record_description Values_Value_BOOL__desc;
extern struct record_description Values_Value_CODE__desc;
extern struct record_description Values_Value_INTEGER__desc;
extern struct record_description Values_Value_REAL__desc;
extern struct record_description Values_Value_STRING__desc;


DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_loadFile(threadData_t *threadData, modelica_metatype _st, modelica_string _fileName, modelica_string _encoding, modelica_boolean _uses, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_loadFile(threadData_t *threadData, modelica_metatype _st, modelica_metatype _fileName, modelica_metatype _encoding, modelica_metatype _uses, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_loadFile,0}};
#define boxvar_OpenModelicaScriptingAPI_loadFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFile)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_loadFiles(threadData_t *threadData, modelica_metatype _st, modelica_metatype _fileNames, modelica_string _encoding, modelica_integer _numThreads, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_loadFiles(threadData_t *threadData, modelica_metatype _st, modelica_metatype _fileNames, modelica_metatype _encoding, modelica_metatype _numThreads, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFiles,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_loadFiles,0}};
#define boxvar_OpenModelicaScriptingAPI_loadFiles MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFiles)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_reloadClass(threadData_t *threadData, modelica_metatype _st, modelica_string _name, modelica_string _encoding, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_reloadClass(threadData_t *threadData, modelica_metatype _st, modelica_metatype _name, modelica_metatype _encoding, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_reloadClass,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_reloadClass,0}};
#define boxvar_OpenModelicaScriptingAPI_reloadClass MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_reloadClass)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_loadString(threadData_t *threadData, modelica_metatype _st, modelica_string _data, modelica_string _filename, modelica_string _encoding, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_loadString(threadData_t *threadData, modelica_metatype _st, modelica_metatype _data, modelica_metatype _filename, modelica_metatype _encoding, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadString,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_loadString,0}};
#define boxvar_OpenModelicaScriptingAPI_loadString MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadString)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_parseString(threadData_t *threadData, modelica_metatype _st, modelica_string _data, modelica_string _filename, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_parseString omc_OpenModelicaScriptingAPI_parseString
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_parseString,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_parseString,0}};
#define boxvar_OpenModelicaScriptingAPI_parseString MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_parseString)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_parseFile(threadData_t *threadData, modelica_metatype _st, modelica_string _filename, modelica_string _encoding, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_parseFile omc_OpenModelicaScriptingAPI_parseFile
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_parseFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_parseFile,0}};
#define boxvar_OpenModelicaScriptingAPI_parseFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_parseFile)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_loadFileInteractiveQualified(threadData_t *threadData, modelica_metatype _st, modelica_string _filename, modelica_string _encoding, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_loadFileInteractiveQualified omc_OpenModelicaScriptingAPI_loadFileInteractiveQualified
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFileInteractiveQualified,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_loadFileInteractiveQualified,0}};
#define boxvar_OpenModelicaScriptingAPI_loadFileInteractiveQualified MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFileInteractiveQualified)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_loadFileInteractive(threadData_t *threadData, modelica_metatype _st, modelica_string _filename, modelica_string _encoding, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_loadFileInteractive omc_OpenModelicaScriptingAPI_loadFileInteractive
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFileInteractive,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_loadFileInteractive,0}};
#define boxvar_OpenModelicaScriptingAPI_loadFileInteractive MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFileInteractive)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_system(threadData_t *threadData, modelica_metatype _st, modelica_string _callStr, modelica_string _outputFile, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_system(threadData_t *threadData, modelica_metatype _st, modelica_metatype _callStr, modelica_metatype _outputFile, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_system,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_system,0}};
#define boxvar_OpenModelicaScriptingAPI_system MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_system)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_system__parallel(threadData_t *threadData, modelica_metatype _st, modelica_metatype _callStr, modelica_integer _numThreads, modelica_metatype *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_system__parallel(threadData_t *threadData, modelica_metatype _st, modelica_metatype _callStr, modelica_metatype _numThreads, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_system__parallel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_system__parallel,0}};
#define boxvar_OpenModelicaScriptingAPI_system__parallel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_system__parallel)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_saveAll(threadData_t *threadData, modelica_metatype _st, modelica_string _fileName, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_saveAll(threadData_t *threadData, modelica_metatype _st, modelica_metatype _fileName, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_saveAll,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_saveAll,0}};
#define boxvar_OpenModelicaScriptingAPI_saveAll MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_saveAll)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_help(threadData_t *threadData, modelica_metatype _st, modelica_string _topic, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_help omc_OpenModelicaScriptingAPI_help
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_help,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_help,0}};
#define boxvar_OpenModelicaScriptingAPI_help MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_help)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_clear(threadData_t *threadData, modelica_metatype _st, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_clear(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clear,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_clear,0}};
#define boxvar_OpenModelicaScriptingAPI_clear MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clear)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_clearProgram(threadData_t *threadData, modelica_metatype _st, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_clearProgram(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearProgram,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_clearProgram,0}};
#define boxvar_OpenModelicaScriptingAPI_clearProgram MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearProgram)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_clearVariables(threadData_t *threadData, modelica_metatype _st, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_clearVariables(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearVariables,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_clearVariables,0}};
#define boxvar_OpenModelicaScriptingAPI_clearVariables MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearVariables)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_generateHeader(threadData_t *threadData, modelica_metatype _st, modelica_string _fileName, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_generateHeader(threadData_t *threadData, modelica_metatype _st, modelica_metatype _fileName, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateHeader,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateHeader,0}};
#define boxvar_OpenModelicaScriptingAPI_generateHeader MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateHeader)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_generateSeparateCode(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_boolean _cleanCache, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_generateSeparateCode(threadData_t *threadData, modelica_metatype _st, modelica_metatype _className, modelica_metatype _cleanCache, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateSeparateCode,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateSeparateCode,0}};
#define boxvar_OpenModelicaScriptingAPI_generateSeparateCode MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateSeparateCode)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_generateSeparateCodeDependencies(threadData_t *threadData, modelica_metatype _st, modelica_string _stampSuffix, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_generateSeparateCodeDependencies omc_OpenModelicaScriptingAPI_generateSeparateCodeDependencies
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateSeparateCodeDependencies,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateSeparateCodeDependencies,0}};
#define boxvar_OpenModelicaScriptingAPI_generateSeparateCodeDependencies MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateSeparateCodeDependencies)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_generateSeparateCodeDependenciesMakefile(threadData_t *threadData, modelica_metatype _st, modelica_string _filename, modelica_string _directory, modelica_string _suffix, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_generateSeparateCodeDependenciesMakefile(threadData_t *threadData, modelica_metatype _st, modelica_metatype _filename, modelica_metatype _directory, modelica_metatype _suffix, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateSeparateCodeDependenciesMakefile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateSeparateCodeDependenciesMakefile,0}};
#define boxvar_OpenModelicaScriptingAPI_generateSeparateCodeDependenciesMakefile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateSeparateCodeDependenciesMakefile)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getLinker(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getLinker omc_OpenModelicaScriptingAPI_getLinker
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLinker,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getLinker,0}};
#define boxvar_OpenModelicaScriptingAPI_getLinker MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLinker)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setLinker(threadData_t *threadData, modelica_metatype _st, modelica_string _linker, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setLinker(threadData_t *threadData, modelica_metatype _st, modelica_metatype _linker, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setLinker,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setLinker,0}};
#define boxvar_OpenModelicaScriptingAPI_setLinker MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setLinker)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getLinkerFlags(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getLinkerFlags omc_OpenModelicaScriptingAPI_getLinkerFlags
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLinkerFlags,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getLinkerFlags,0}};
#define boxvar_OpenModelicaScriptingAPI_getLinkerFlags MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLinkerFlags)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setLinkerFlags(threadData_t *threadData, modelica_metatype _st, modelica_string _linkerFlags, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setLinkerFlags(threadData_t *threadData, modelica_metatype _st, modelica_metatype _linkerFlags, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setLinkerFlags,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setLinkerFlags,0}};
#define boxvar_OpenModelicaScriptingAPI_setLinkerFlags MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setLinkerFlags)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getCompiler(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getCompiler omc_OpenModelicaScriptingAPI_getCompiler
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCompiler,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getCompiler,0}};
#define boxvar_OpenModelicaScriptingAPI_getCompiler MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCompiler)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setCompiler(threadData_t *threadData, modelica_metatype _st, modelica_string _compiler, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setCompiler(threadData_t *threadData, modelica_metatype _st, modelica_metatype _compiler, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCompiler,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setCompiler,0}};
#define boxvar_OpenModelicaScriptingAPI_setCompiler MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCompiler)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setCFlags(threadData_t *threadData, modelica_metatype _st, modelica_string _inString, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setCFlags(threadData_t *threadData, modelica_metatype _st, modelica_metatype _inString, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCFlags,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setCFlags,0}};
#define boxvar_OpenModelicaScriptingAPI_setCFlags MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCFlags)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getCFlags(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getCFlags omc_OpenModelicaScriptingAPI_getCFlags
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCFlags,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getCFlags,0}};
#define boxvar_OpenModelicaScriptingAPI_getCFlags MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCFlags)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getCXXCompiler(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getCXXCompiler omc_OpenModelicaScriptingAPI_getCXXCompiler
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCXXCompiler,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getCXXCompiler,0}};
#define boxvar_OpenModelicaScriptingAPI_getCXXCompiler MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCXXCompiler)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setCXXCompiler(threadData_t *threadData, modelica_metatype _st, modelica_string _compiler, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setCXXCompiler(threadData_t *threadData, modelica_metatype _st, modelica_metatype _compiler, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCXXCompiler,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setCXXCompiler,0}};
#define boxvar_OpenModelicaScriptingAPI_setCXXCompiler MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCXXCompiler)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_verifyCompiler(threadData_t *threadData, modelica_metatype _st, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_verifyCompiler(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_verifyCompiler,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_verifyCompiler,0}};
#define boxvar_OpenModelicaScriptingAPI_verifyCompiler MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_verifyCompiler)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setCompilerPath(threadData_t *threadData, modelica_metatype _st, modelica_string _compilerPath, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setCompilerPath(threadData_t *threadData, modelica_metatype _st, modelica_metatype _compilerPath, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCompilerPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setCompilerPath,0}};
#define boxvar_OpenModelicaScriptingAPI_setCompilerPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCompilerPath)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getCompileCommand(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getCompileCommand omc_OpenModelicaScriptingAPI_getCompileCommand
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCompileCommand,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getCompileCommand,0}};
#define boxvar_OpenModelicaScriptingAPI_getCompileCommand MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCompileCommand)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setCompileCommand(threadData_t *threadData, modelica_metatype _st, modelica_string _compileCommand, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setCompileCommand(threadData_t *threadData, modelica_metatype _st, modelica_metatype _compileCommand, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCompileCommand,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setCompileCommand,0}};
#define boxvar_OpenModelicaScriptingAPI_setCompileCommand MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCompileCommand)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setPlotCommand(threadData_t *threadData, modelica_metatype _st, modelica_string _plotCommand, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setPlotCommand(threadData_t *threadData, modelica_metatype _st, modelica_metatype _plotCommand, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setPlotCommand,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setPlotCommand,0}};
#define boxvar_OpenModelicaScriptingAPI_setPlotCommand MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setPlotCommand)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setTempDirectoryPath(threadData_t *threadData, modelica_metatype _st, modelica_string _tempDirectoryPath, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setTempDirectoryPath(threadData_t *threadData, modelica_metatype _st, modelica_metatype _tempDirectoryPath, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setTempDirectoryPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setTempDirectoryPath,0}};
#define boxvar_OpenModelicaScriptingAPI_setTempDirectoryPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setTempDirectoryPath)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getTempDirectoryPath(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getTempDirectoryPath omc_OpenModelicaScriptingAPI_getTempDirectoryPath
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getTempDirectoryPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getTempDirectoryPath,0}};
#define boxvar_OpenModelicaScriptingAPI_getTempDirectoryPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getTempDirectoryPath)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getEnvironmentVar(threadData_t *threadData, modelica_metatype _st, modelica_string _var, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getEnvironmentVar omc_OpenModelicaScriptingAPI_getEnvironmentVar
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getEnvironmentVar,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getEnvironmentVar,0}};
#define boxvar_OpenModelicaScriptingAPI_getEnvironmentVar MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getEnvironmentVar)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setEnvironmentVar(threadData_t *threadData, modelica_metatype _st, modelica_string _var, modelica_string _value, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setEnvironmentVar(threadData_t *threadData, modelica_metatype _st, modelica_metatype _var, modelica_metatype _value, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setEnvironmentVar,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setEnvironmentVar,0}};
#define boxvar_OpenModelicaScriptingAPI_setEnvironmentVar MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setEnvironmentVar)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setInstallationDirectoryPath(threadData_t *threadData, modelica_metatype _st, modelica_string _installationDirectoryPath, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setInstallationDirectoryPath(threadData_t *threadData, modelica_metatype _st, modelica_metatype _installationDirectoryPath, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setInstallationDirectoryPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setInstallationDirectoryPath,0}};
#define boxvar_OpenModelicaScriptingAPI_setInstallationDirectoryPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setInstallationDirectoryPath)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getInstallationDirectoryPath(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getInstallationDirectoryPath omc_OpenModelicaScriptingAPI_getInstallationDirectoryPath
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInstallationDirectoryPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getInstallationDirectoryPath,0}};
#define boxvar_OpenModelicaScriptingAPI_getInstallationDirectoryPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInstallationDirectoryPath)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setModelicaPath(threadData_t *threadData, modelica_metatype _st, modelica_string _modelicaPath, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setModelicaPath(threadData_t *threadData, modelica_metatype _st, modelica_metatype _modelicaPath, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setModelicaPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setModelicaPath,0}};
#define boxvar_OpenModelicaScriptingAPI_setModelicaPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setModelicaPath)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getModelicaPath(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getModelicaPath omc_OpenModelicaScriptingAPI_getModelicaPath
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getModelicaPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getModelicaPath,0}};
#define boxvar_OpenModelicaScriptingAPI_getModelicaPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getModelicaPath)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setCompilerFlags(threadData_t *threadData, modelica_metatype _st, modelica_string _compilerFlags, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setCompilerFlags(threadData_t *threadData, modelica_metatype _st, modelica_metatype _compilerFlags, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCompilerFlags,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setCompilerFlags,0}};
#define boxvar_OpenModelicaScriptingAPI_setCompilerFlags MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCompilerFlags)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_clearDebugFlags(threadData_t *threadData, modelica_metatype _st, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_clearDebugFlags(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearDebugFlags,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_clearDebugFlags,0}};
#define boxvar_OpenModelicaScriptingAPI_clearDebugFlags MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearDebugFlags)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getMatchingAlgorithm(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getMatchingAlgorithm omc_OpenModelicaScriptingAPI_getMatchingAlgorithm
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getMatchingAlgorithm,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getMatchingAlgorithm,0}};
#define boxvar_OpenModelicaScriptingAPI_getMatchingAlgorithm MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getMatchingAlgorithm)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getAvailableMatchingAlgorithms(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res1, modelica_metatype *out_res2);
#define boxptr_OpenModelicaScriptingAPI_getAvailableMatchingAlgorithms omc_OpenModelicaScriptingAPI_getAvailableMatchingAlgorithms
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableMatchingAlgorithms,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAvailableMatchingAlgorithms,0}};
#define boxvar_OpenModelicaScriptingAPI_getAvailableMatchingAlgorithms MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableMatchingAlgorithms)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getIndexReductionMethod(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getIndexReductionMethod omc_OpenModelicaScriptingAPI_getIndexReductionMethod
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getIndexReductionMethod,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getIndexReductionMethod,0}};
#define boxvar_OpenModelicaScriptingAPI_getIndexReductionMethod MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getIndexReductionMethod)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getAvailableIndexReductionMethods(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res1, modelica_metatype *out_res2);
#define boxptr_OpenModelicaScriptingAPI_getAvailableIndexReductionMethods omc_OpenModelicaScriptingAPI_getAvailableIndexReductionMethods
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableIndexReductionMethods,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAvailableIndexReductionMethods,0}};
#define boxvar_OpenModelicaScriptingAPI_getAvailableIndexReductionMethods MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableIndexReductionMethods)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getTearingMethod(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getTearingMethod omc_OpenModelicaScriptingAPI_getTearingMethod
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getTearingMethod,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getTearingMethod,0}};
#define boxvar_OpenModelicaScriptingAPI_getTearingMethod MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getTearingMethod)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getAvailableTearingMethods(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res1, modelica_metatype *out_res2);
#define boxptr_OpenModelicaScriptingAPI_getAvailableTearingMethods omc_OpenModelicaScriptingAPI_getAvailableTearingMethods
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableTearingMethods,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAvailableTearingMethods,0}};
#define boxvar_OpenModelicaScriptingAPI_getAvailableTearingMethods MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableTearingMethods)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setCommandLineOptions(threadData_t *threadData, modelica_metatype _st, modelica_string _option, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setCommandLineOptions(threadData_t *threadData, modelica_metatype _st, modelica_metatype _option, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCommandLineOptions,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setCommandLineOptions,0}};
#define boxvar_OpenModelicaScriptingAPI_setCommandLineOptions MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCommandLineOptions)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getConfigFlagValidOptions(threadData_t *threadData, modelica_metatype _st, modelica_string _flag, modelica_metatype *out_res1, modelica_string *out_res2, modelica_metatype *out_res3);
#define boxptr_OpenModelicaScriptingAPI_getConfigFlagValidOptions omc_OpenModelicaScriptingAPI_getConfigFlagValidOptions
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getConfigFlagValidOptions,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getConfigFlagValidOptions,0}};
#define boxvar_OpenModelicaScriptingAPI_getConfigFlagValidOptions MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getConfigFlagValidOptions)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_clearCommandLineOptions(threadData_t *threadData, modelica_metatype _st, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_clearCommandLineOptions(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearCommandLineOptions,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_clearCommandLineOptions,0}};
#define boxvar_OpenModelicaScriptingAPI_clearCommandLineOptions MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearCommandLineOptions)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getVersion(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getVersion omc_OpenModelicaScriptingAPI_getVersion
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getVersion,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getVersion,0}};
#define boxvar_OpenModelicaScriptingAPI_getVersion MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getVersion)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_readFile(threadData_t *threadData, modelica_metatype _st, modelica_string _fileName, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_readFile omc_OpenModelicaScriptingAPI_readFile
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_readFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_readFile,0}};
#define boxvar_OpenModelicaScriptingAPI_readFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_readFile)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_writeFile(threadData_t *threadData, modelica_metatype _st, modelica_string _fileName, modelica_string _data, modelica_boolean _append, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_writeFile(threadData_t *threadData, modelica_metatype _st, modelica_metatype _fileName, modelica_metatype _data, modelica_metatype _append, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_writeFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_writeFile,0}};
#define boxvar_OpenModelicaScriptingAPI_writeFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_writeFile)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_compareFilesAndMove(threadData_t *threadData, modelica_metatype _st, modelica_string _newFile, modelica_string _oldFile, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_compareFilesAndMove(threadData_t *threadData, modelica_metatype _st, modelica_metatype _newFile, modelica_metatype _oldFile, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_compareFilesAndMove,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_compareFilesAndMove,0}};
#define boxvar_OpenModelicaScriptingAPI_compareFilesAndMove MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_compareFilesAndMove)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_compareFiles(threadData_t *threadData, modelica_metatype _st, modelica_string _file1, modelica_string _file2, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_compareFiles(threadData_t *threadData, modelica_metatype _st, modelica_metatype _file1, modelica_metatype _file2, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_compareFiles,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_compareFiles,0}};
#define boxvar_OpenModelicaScriptingAPI_compareFiles MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_compareFiles)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_alarm(threadData_t *threadData, modelica_metatype _st, modelica_integer _seconds, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_alarm(threadData_t *threadData, modelica_metatype _st, modelica_metatype _seconds, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_alarm,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_alarm,0}};
#define boxvar_OpenModelicaScriptingAPI_alarm MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_alarm)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_readFileNoNumeric(threadData_t *threadData, modelica_metatype _st, modelica_string _fileName, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_readFileNoNumeric omc_OpenModelicaScriptingAPI_readFileNoNumeric
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_readFileNoNumeric,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_readFileNoNumeric,0}};
#define boxvar_OpenModelicaScriptingAPI_readFileNoNumeric MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_readFileNoNumeric)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getErrorString(threadData_t *threadData, modelica_metatype _st, modelica_boolean _warningsAsErrors, modelica_string *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getErrorString(threadData_t *threadData, modelica_metatype _st, modelica_metatype _warningsAsErrors, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getErrorString,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getErrorString,0}};
#define boxvar_OpenModelicaScriptingAPI_getErrorString MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getErrorString)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getMessagesString(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getMessagesString omc_OpenModelicaScriptingAPI_getMessagesString
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getMessagesString,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getMessagesString,0}};
#define boxvar_OpenModelicaScriptingAPI_getMessagesString MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getMessagesString)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_countMessages(threadData_t *threadData, modelica_metatype _st, modelica_integer *out_res1, modelica_integer *out_res2, modelica_integer *out_res3);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_countMessages(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res1, modelica_metatype *out_res2, modelica_metatype *out_res3);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_countMessages,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_countMessages,0}};
#define boxvar_OpenModelicaScriptingAPI_countMessages MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_countMessages)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_clearMessages(threadData_t *threadData, modelica_metatype _st, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_clearMessages(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearMessages,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_clearMessages,0}};
#define boxvar_OpenModelicaScriptingAPI_clearMessages MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearMessages)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_runScript(threadData_t *threadData, modelica_metatype _st, modelica_string _fileName, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_runScript omc_OpenModelicaScriptingAPI_runScript
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_runScript,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_runScript,0}};
#define boxvar_OpenModelicaScriptingAPI_runScript MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_runScript)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_echo(threadData_t *threadData, modelica_metatype _st, modelica_boolean _setEcho, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_echo(threadData_t *threadData, modelica_metatype _st, modelica_metatype _setEcho, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_echo,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_echo,0}};
#define boxvar_OpenModelicaScriptingAPI_echo MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_echo)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getClassesInModelicaPath(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getClassesInModelicaPath omc_OpenModelicaScriptingAPI_getClassesInModelicaPath
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassesInModelicaPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getClassesInModelicaPath,0}};
#define boxvar_OpenModelicaScriptingAPI_getClassesInModelicaPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassesInModelicaPath)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getAnnotationVersion(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getAnnotationVersion omc_OpenModelicaScriptingAPI_getAnnotationVersion
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAnnotationVersion,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAnnotationVersion,0}};
#define boxvar_OpenModelicaScriptingAPI_getAnnotationVersion MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAnnotationVersion)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getNoSimplify(threadData_t *threadData, modelica_metatype _st, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNoSimplify(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNoSimplify,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNoSimplify,0}};
#define boxvar_OpenModelicaScriptingAPI_getNoSimplify MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNoSimplify)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setNoSimplify(threadData_t *threadData, modelica_metatype _st, modelica_boolean _noSimplify, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setNoSimplify(threadData_t *threadData, modelica_metatype _st, modelica_metatype _noSimplify, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setNoSimplify,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setNoSimplify,0}};
#define boxvar_OpenModelicaScriptingAPI_setNoSimplify MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setNoSimplify)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getVectorizationLimit(threadData_t *threadData, modelica_metatype _st, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getVectorizationLimit(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getVectorizationLimit,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getVectorizationLimit,0}};
#define boxvar_OpenModelicaScriptingAPI_getVectorizationLimit MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getVectorizationLimit)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getDefaultOpenCLDevice(threadData_t *threadData, modelica_metatype _st, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getDefaultOpenCLDevice(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDefaultOpenCLDevice,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getDefaultOpenCLDevice,0}};
#define boxvar_OpenModelicaScriptingAPI_getDefaultOpenCLDevice MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDefaultOpenCLDevice)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setShowAnnotations(threadData_t *threadData, modelica_metatype _st, modelica_boolean _show, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setShowAnnotations(threadData_t *threadData, modelica_metatype _st, modelica_metatype _show, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setShowAnnotations,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setShowAnnotations,0}};
#define boxvar_OpenModelicaScriptingAPI_setShowAnnotations MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setShowAnnotations)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getShowAnnotations(threadData_t *threadData, modelica_metatype _st, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getShowAnnotations(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getShowAnnotations,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getShowAnnotations,0}};
#define boxvar_OpenModelicaScriptingAPI_getShowAnnotations MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getShowAnnotations)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getOrderConnections(threadData_t *threadData, modelica_metatype _st, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getOrderConnections(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getOrderConnections,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getOrderConnections,0}};
#define boxvar_OpenModelicaScriptingAPI_getOrderConnections MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getOrderConnections)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getLanguageStandard(threadData_t *threadData, modelica_metatype _st, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getLanguageStandard omc_OpenModelicaScriptingAPI_getLanguageStandard
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLanguageStandard,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getLanguageStandard,0}};
#define boxvar_OpenModelicaScriptingAPI_getLanguageStandard MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLanguageStandard)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getAstAsCorbaString(threadData_t *threadData, modelica_metatype _st, modelica_string _fileName, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getAstAsCorbaString omc_OpenModelicaScriptingAPI_getAstAsCorbaString
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAstAsCorbaString,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAstAsCorbaString,0}};
#define boxvar_OpenModelicaScriptingAPI_getAstAsCorbaString MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAstAsCorbaString)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_cd(threadData_t *threadData, modelica_metatype _st, modelica_string _newWorkingDirectory, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_cd omc_OpenModelicaScriptingAPI_cd
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_cd,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_cd,0}};
#define boxvar_OpenModelicaScriptingAPI_cd MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_cd)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_mkdir(threadData_t *threadData, modelica_metatype _st, modelica_string _newDirectory, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_mkdir(threadData_t *threadData, modelica_metatype _st, modelica_metatype _newDirectory, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_mkdir,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_mkdir,0}};
#define boxvar_OpenModelicaScriptingAPI_mkdir MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_mkdir)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_remove(threadData_t *threadData, modelica_metatype _st, modelica_string _newDirectory, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_remove(threadData_t *threadData, modelica_metatype _st, modelica_metatype _newDirectory, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_remove,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_remove,0}};
#define boxvar_OpenModelicaScriptingAPI_remove MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_remove)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_checkModel(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_checkModel omc_OpenModelicaScriptingAPI_checkModel
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_checkModel,0}};
#define boxvar_OpenModelicaScriptingAPI_checkModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkModel)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_checkAllModelsRecursive(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_boolean _checkProtected, modelica_string *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_checkAllModelsRecursive(threadData_t *threadData, modelica_metatype _st, modelica_metatype _className, modelica_metatype _checkProtected, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkAllModelsRecursive,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_checkAllModelsRecursive,0}};
#define boxvar_OpenModelicaScriptingAPI_checkAllModelsRecursive MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkAllModelsRecursive)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_instantiateModel(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_instantiateModel omc_OpenModelicaScriptingAPI_instantiateModel
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_instantiateModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_instantiateModel,0}};
#define boxvar_OpenModelicaScriptingAPI_instantiateModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_instantiateModel)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_buildOpenTURNSInterface(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_string _pythonTemplateFile, modelica_boolean _showFlatModelica, modelica_string *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_buildOpenTURNSInterface(threadData_t *threadData, modelica_metatype _st, modelica_metatype _className, modelica_metatype _pythonTemplateFile, modelica_metatype _showFlatModelica, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_buildOpenTURNSInterface,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_buildOpenTURNSInterface,0}};
#define boxvar_OpenModelicaScriptingAPI_buildOpenTURNSInterface MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_buildOpenTURNSInterface)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_runOpenTURNSPythonScript(threadData_t *threadData, modelica_metatype _st, modelica_string _pythonScriptFile, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_runOpenTURNSPythonScript omc_OpenModelicaScriptingAPI_runOpenTURNSPythonScript
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_runOpenTURNSPythonScript,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_runOpenTURNSPythonScript,0}};
#define boxvar_OpenModelicaScriptingAPI_runOpenTURNSPythonScript MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_runOpenTURNSPythonScript)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_generateCode(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_generateCode(threadData_t *threadData, modelica_metatype _st, modelica_metatype _className, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateCode,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateCode,0}};
#define boxvar_OpenModelicaScriptingAPI_generateCode MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateCode)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_loadModel(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_metatype _priorityVersion, modelica_boolean _notify, modelica_string _languageStandard, modelica_boolean _requireExactVersion, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_loadModel(threadData_t *threadData, modelica_metatype _st, modelica_metatype _className, modelica_metatype _priorityVersion, modelica_metatype _notify, modelica_metatype _languageStandard, modelica_metatype _requireExactVersion, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_loadModel,0}};
#define boxvar_OpenModelicaScriptingAPI_loadModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadModel)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_deleteFile(threadData_t *threadData, modelica_metatype _st, modelica_string _fileName, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_deleteFile(threadData_t *threadData, modelica_metatype _st, modelica_metatype _fileName, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_deleteFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_deleteFile,0}};
#define boxvar_OpenModelicaScriptingAPI_deleteFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_deleteFile)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_saveModel(threadData_t *threadData, modelica_metatype _st, modelica_string _fileName, modelica_string _className, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_saveModel(threadData_t *threadData, modelica_metatype _st, modelica_metatype _fileName, modelica_metatype _className, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_saveModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_saveModel,0}};
#define boxvar_OpenModelicaScriptingAPI_saveModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_saveModel)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_saveTotalModel(threadData_t *threadData, modelica_metatype _st, modelica_string _fileName, modelica_string _className, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_saveTotalModel(threadData_t *threadData, modelica_metatype _st, modelica_metatype _fileName, modelica_metatype _className, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_saveTotalModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_saveTotalModel,0}};
#define boxvar_OpenModelicaScriptingAPI_saveTotalModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_saveTotalModel)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_save(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_save(threadData_t *threadData, modelica_metatype _st, modelica_metatype _className, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_save,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_save,0}};
#define boxvar_OpenModelicaScriptingAPI_save MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_save)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_translateGraphics(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_translateGraphics omc_OpenModelicaScriptingAPI_translateGraphics
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_translateGraphics,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_translateGraphics,0}};
#define boxvar_OpenModelicaScriptingAPI_translateGraphics MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_translateGraphics)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_dumpXMLDAE(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_string _translationLevel, modelica_boolean _addOriginalIncidenceMatrix, modelica_boolean _addSolvingInfo, modelica_boolean _addMathMLCode, modelica_boolean _dumpResiduals, modelica_string _fileNamePrefix, modelica_string _rewriteRulesFile, modelica_boolean *out_res1, modelica_string *out_res2);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_dumpXMLDAE(threadData_t *threadData, modelica_metatype _st, modelica_metatype _className, modelica_metatype _translationLevel, modelica_metatype _addOriginalIncidenceMatrix, modelica_metatype _addSolvingInfo, modelica_metatype _addMathMLCode, modelica_metatype _dumpResiduals, modelica_metatype _fileNamePrefix, modelica_metatype _rewriteRulesFile, modelica_metatype *out_res1, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_dumpXMLDAE,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_dumpXMLDAE,0}};
#define boxvar_OpenModelicaScriptingAPI_dumpXMLDAE MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_dumpXMLDAE)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_convertUnits(threadData_t *threadData, modelica_metatype _st, modelica_string _s1, modelica_string _s2, modelica_boolean *out_res1, modelica_real *out_res2, modelica_real *out_res3, modelica_real *out_res4, modelica_real *out_res5);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_convertUnits(threadData_t *threadData, modelica_metatype _st, modelica_metatype _s1, modelica_metatype _s2, modelica_metatype *out_res1, modelica_metatype *out_res2, modelica_metatype *out_res3, modelica_metatype *out_res4, modelica_metatype *out_res5);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_convertUnits,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_convertUnits,0}};
#define boxvar_OpenModelicaScriptingAPI_convertUnits MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_convertUnits)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_listVariables(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_listVariables omc_OpenModelicaScriptingAPI_listVariables
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_listVariables,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_listVariables,0}};
#define boxvar_OpenModelicaScriptingAPI_listVariables MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_listVariables)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_strtok(threadData_t *threadData, modelica_metatype _st, modelica_string _string, modelica_string _token, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_strtok omc_OpenModelicaScriptingAPI_strtok
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_strtok,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_strtok,0}};
#define boxvar_OpenModelicaScriptingAPI_strtok MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_strtok)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_stringReplace(threadData_t *threadData, modelica_metatype _st, modelica_string _str, modelica_string _source, modelica_string _target, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_stringReplace omc_OpenModelicaScriptingAPI_stringReplace
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_stringReplace,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_stringReplace,0}};
#define boxvar_OpenModelicaScriptingAPI_stringReplace MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_stringReplace)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_exportToFigaro(threadData_t *threadData, modelica_metatype _st, modelica_string _path, modelica_string _directory, modelica_string _database, modelica_string _mode, modelica_string _options, modelica_string _processor, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_exportToFigaro(threadData_t *threadData, modelica_metatype _st, modelica_metatype _path, modelica_metatype _directory, modelica_metatype _database, modelica_metatype _mode, modelica_metatype _options, modelica_metatype _processor, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_exportToFigaro,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_exportToFigaro,0}};
#define boxvar_OpenModelicaScriptingAPI_exportToFigaro MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_exportToFigaro)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_rewriteBlockCall(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_string _inDefs, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_rewriteBlockCall(threadData_t *threadData, modelica_metatype _st, modelica_metatype _className, modelica_metatype _inDefs, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_rewriteBlockCall,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_rewriteBlockCall,0}};
#define boxvar_OpenModelicaScriptingAPI_rewriteBlockCall MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_rewriteBlockCall)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getLoadedLibraries(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_getLoadedLibraries omc_OpenModelicaScriptingAPI_getLoadedLibraries
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLoadedLibraries,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getLoadedLibraries,0}};
#define boxvar_OpenModelicaScriptingAPI_getLoadedLibraries MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLoadedLibraries)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_importFMU(threadData_t *threadData, modelica_metatype _st, modelica_string _filename, modelica_string _workdir, modelica_integer _loglevel, modelica_boolean _fullPath, modelica_boolean _debugLogging, modelica_boolean _generateInputConnectors, modelica_boolean _generateOutputConnectors, modelica_string *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_importFMU(threadData_t *threadData, modelica_metatype _st, modelica_metatype _filename, modelica_metatype _workdir, modelica_metatype _loglevel, modelica_metatype _fullPath, modelica_metatype _debugLogging, modelica_metatype _generateInputConnectors, modelica_metatype _generateOutputConnectors, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_importFMU,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_importFMU,0}};
#define boxvar_OpenModelicaScriptingAPI_importFMU MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_importFMU)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_translateModelFMU(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_string _version, modelica_string _fmuType, modelica_string _fileNamePrefix, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_translateModelFMU omc_OpenModelicaScriptingAPI_translateModelFMU
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_translateModelFMU,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_translateModelFMU,0}};
#define boxvar_OpenModelicaScriptingAPI_translateModelFMU MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_translateModelFMU)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_moveClass(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_string _direction, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_moveClass(threadData_t *threadData, modelica_metatype _st, modelica_metatype _className, modelica_metatype _direction, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_moveClass,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_moveClass,0}};
#define boxvar_OpenModelicaScriptingAPI_moveClass MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_moveClass)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_copyClass(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_string _newClassName, modelica_string _withIn, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_copyClass(threadData_t *threadData, modelica_metatype _st, modelica_metatype _className, modelica_metatype _newClassName, modelica_metatype _withIn, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_copyClass,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_copyClass,0}};
#define boxvar_OpenModelicaScriptingAPI_copyClass MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_copyClass)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getSourceFile(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getSourceFile omc_OpenModelicaScriptingAPI_getSourceFile
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getSourceFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getSourceFile,0}};
#define boxvar_OpenModelicaScriptingAPI_getSourceFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getSourceFile)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setSourceFile(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_string _filename, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setSourceFile(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype _filename, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setSourceFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setSourceFile,0}};
#define boxvar_OpenModelicaScriptingAPI_setSourceFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setSourceFile)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isShortDefinition(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isShortDefinition(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isShortDefinition,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isShortDefinition,0}};
#define boxvar_OpenModelicaScriptingAPI_isShortDefinition MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isShortDefinition)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setClassComment(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_string _filename, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setClassComment(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype _filename, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setClassComment,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setClassComment,0}};
#define boxvar_OpenModelicaScriptingAPI_setClassComment MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setClassComment)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getClassNames(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_boolean _recursive, modelica_boolean _qualified, modelica_boolean _sort, modelica_boolean _builtin, modelica_boolean _showProtected, modelica_metatype *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getClassNames(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype _recursive, modelica_metatype _qualified, modelica_metatype _sort, modelica_metatype _builtin, modelica_metatype _showProtected, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getClassNames,0}};
#define boxvar_OpenModelicaScriptingAPI_getClassNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassNames)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getUsedClassNames(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_getUsedClassNames omc_OpenModelicaScriptingAPI_getUsedClassNames
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getUsedClassNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getUsedClassNames,0}};
#define boxvar_OpenModelicaScriptingAPI_getUsedClassNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getUsedClassNames)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getPackages(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_getPackages omc_OpenModelicaScriptingAPI_getPackages
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getPackages,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getPackages,0}};
#define boxvar_OpenModelicaScriptingAPI_getPackages MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getPackages)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getPlotSilent(threadData_t *threadData, modelica_metatype _st, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getPlotSilent(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getPlotSilent,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getPlotSilent,0}};
#define boxvar_OpenModelicaScriptingAPI_getPlotSilent MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getPlotSilent)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_plotAll(threadData_t *threadData, modelica_metatype _st, modelica_boolean _externalWindow, modelica_string _fileName, modelica_string _title, modelica_string _grid, modelica_boolean _logX, modelica_boolean _logY, modelica_string _xLabel, modelica_string _yLabel, modelica_metatype _xRange, modelica_metatype _yRange, modelica_real _curveWidth, modelica_integer _curveStyle, modelica_string _legendPosition, modelica_string _footer, modelica_boolean *out_res1, modelica_metatype *out_res2);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_plotAll(threadData_t *threadData, modelica_metatype _st, modelica_metatype _externalWindow, modelica_metatype _fileName, modelica_metatype _title, modelica_metatype _grid, modelica_metatype _logX, modelica_metatype _logY, modelica_metatype _xLabel, modelica_metatype _yLabel, modelica_metatype _xRange, modelica_metatype _yRange, modelica_metatype _curveWidth, modelica_metatype _curveStyle, modelica_metatype _legendPosition, modelica_metatype _footer, modelica_metatype *out_res1, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_plotAll,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_plotAll,0}};
#define boxvar_OpenModelicaScriptingAPI_plotAll MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_plotAll)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_visualize(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_boolean _externalWindow, modelica_string _fileName, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_visualize(threadData_t *threadData, modelica_metatype _st, modelica_metatype _className, modelica_metatype _externalWindow, modelica_metatype _fileName, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_visualize,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_visualize,0}};
#define boxvar_OpenModelicaScriptingAPI_visualize MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_visualize)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_readSimulationResultSize(threadData_t *threadData, modelica_metatype _st, modelica_string _fileName, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_readSimulationResultSize(threadData_t *threadData, modelica_metatype _st, modelica_metatype _fileName, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_readSimulationResultSize,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_readSimulationResultSize,0}};
#define boxvar_OpenModelicaScriptingAPI_readSimulationResultSize MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_readSimulationResultSize)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_readSimulationResultVars(threadData_t *threadData, modelica_metatype _st, modelica_string _fileName, modelica_boolean _readParameters, modelica_metatype *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_readSimulationResultVars(threadData_t *threadData, modelica_metatype _st, modelica_metatype _fileName, modelica_metatype _readParameters, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_readSimulationResultVars,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_readSimulationResultVars,0}};
#define boxvar_OpenModelicaScriptingAPI_readSimulationResultVars MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_readSimulationResultVars)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_compareSimulationResults(threadData_t *threadData, modelica_metatype _st, modelica_string _filename, modelica_string _reffilename, modelica_string _logfilename, modelica_real _relTol, modelica_real _absTol, modelica_metatype _vars, modelica_metatype *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_compareSimulationResults(threadData_t *threadData, modelica_metatype _st, modelica_metatype _filename, modelica_metatype _reffilename, modelica_metatype _logfilename, modelica_metatype _relTol, modelica_metatype _absTol, modelica_metatype _vars, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_compareSimulationResults,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_compareSimulationResults,0}};
#define boxvar_OpenModelicaScriptingAPI_compareSimulationResults MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_compareSimulationResults)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_diffSimulationResults(threadData_t *threadData, modelica_metatype _st, modelica_string _actualFile, modelica_string _expectedFile, modelica_string _diffPrefix, modelica_real _relTol, modelica_real _relTolDiffMinMax, modelica_real _rangeDelta, modelica_metatype _vars, modelica_boolean _keepEqualResults, modelica_boolean *out_res1, modelica_metatype *out_res2);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_diffSimulationResults(threadData_t *threadData, modelica_metatype _st, modelica_metatype _actualFile, modelica_metatype _expectedFile, modelica_metatype _diffPrefix, modelica_metatype _relTol, modelica_metatype _relTolDiffMinMax, modelica_metatype _rangeDelta, modelica_metatype _vars, modelica_metatype _keepEqualResults, modelica_metatype *out_res1, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_diffSimulationResults,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_diffSimulationResults,0}};
#define boxvar_OpenModelicaScriptingAPI_diffSimulationResults MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_diffSimulationResults)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_diffSimulationResultsHtml(threadData_t *threadData, modelica_metatype _st, modelica_string _var, modelica_string _actualFile, modelica_string _expectedFile, modelica_real _relTol, modelica_real _relTolDiffMinMax, modelica_real _rangeDelta, modelica_string *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_diffSimulationResultsHtml(threadData_t *threadData, modelica_metatype _st, modelica_metatype _var, modelica_metatype _actualFile, modelica_metatype _expectedFile, modelica_metatype _relTol, modelica_metatype _relTolDiffMinMax, modelica_metatype _rangeDelta, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_diffSimulationResultsHtml,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_diffSimulationResultsHtml,0}};
#define boxvar_OpenModelicaScriptingAPI_diffSimulationResultsHtml MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_diffSimulationResultsHtml)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_checkTaskGraph(threadData_t *threadData, modelica_metatype _st, modelica_string _filename, modelica_string _reffilename, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_checkTaskGraph omc_OpenModelicaScriptingAPI_checkTaskGraph
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkTaskGraph,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_checkTaskGraph,0}};
#define boxvar_OpenModelicaScriptingAPI_checkTaskGraph MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkTaskGraph)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_checkCodeGraph(threadData_t *threadData, modelica_metatype _st, modelica_string _graphfile, modelica_string _codefile, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_checkCodeGraph omc_OpenModelicaScriptingAPI_checkCodeGraph
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkCodeGraph,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_checkCodeGraph,0}};
#define boxvar_OpenModelicaScriptingAPI_checkCodeGraph MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkCodeGraph)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_closeSimulationResultFile(threadData_t *threadData, modelica_metatype _st, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_closeSimulationResultFile(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_closeSimulationResultFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_closeSimulationResultFile,0}};
#define boxvar_OpenModelicaScriptingAPI_closeSimulationResultFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_closeSimulationResultFile)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getParameterNames(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_getParameterNames omc_OpenModelicaScriptingAPI_getParameterNames
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getParameterNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getParameterNames,0}};
#define boxvar_OpenModelicaScriptingAPI_getParameterNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getParameterNames)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getParameterValue(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_string _parameterName, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getParameterValue omc_OpenModelicaScriptingAPI_getParameterValue
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getParameterValue,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getParameterValue,0}};
#define boxvar_OpenModelicaScriptingAPI_getParameterValue MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getParameterValue)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getComponentModifierNames(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_string _componentName, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_getComponentModifierNames omc_OpenModelicaScriptingAPI_getComponentModifierNames
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getComponentModifierNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getComponentModifierNames,0}};
#define boxvar_OpenModelicaScriptingAPI_getComponentModifierNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getComponentModifierNames)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getAlgorithmCount(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getAlgorithmCount(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAlgorithmCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAlgorithmCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getAlgorithmCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAlgorithmCount)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getNthAlgorithm(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer _index, modelica_string *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthAlgorithm(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype _index, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthAlgorithm,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthAlgorithm,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthAlgorithm MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthAlgorithm)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getInitialAlgorithmCount(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getInitialAlgorithmCount(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialAlgorithmCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getInitialAlgorithmCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getInitialAlgorithmCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialAlgorithmCount)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getNthInitialAlgorithm(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer _index, modelica_string *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthInitialAlgorithm(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype _index, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialAlgorithm,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthInitialAlgorithm,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthInitialAlgorithm MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialAlgorithm)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getAlgorithmItemsCount(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getAlgorithmItemsCount(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAlgorithmItemsCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAlgorithmItemsCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getAlgorithmItemsCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAlgorithmItemsCount)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getNthAlgorithmItem(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer _index, modelica_string *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthAlgorithmItem(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype _index, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthAlgorithmItem,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthAlgorithmItem,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthAlgorithmItem MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthAlgorithmItem)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getInitialAlgorithmItemsCount(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getInitialAlgorithmItemsCount(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialAlgorithmItemsCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getInitialAlgorithmItemsCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getInitialAlgorithmItemsCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialAlgorithmItemsCount)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getNthInitialAlgorithmItem(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer _index, modelica_string *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthInitialAlgorithmItem(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype _index, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialAlgorithmItem,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthInitialAlgorithmItem,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthInitialAlgorithmItem MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialAlgorithmItem)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getEquationCount(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getEquationCount(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getEquationCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getEquationCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getEquationCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getEquationCount)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getNthEquation(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer _index, modelica_string *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthEquation(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype _index, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthEquation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthEquation,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthEquation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthEquation)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getInitialEquationCount(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getInitialEquationCount(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialEquationCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getInitialEquationCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getInitialEquationCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialEquationCount)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getNthInitialEquation(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer _index, modelica_string *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthInitialEquation(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype _index, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialEquation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthInitialEquation,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthInitialEquation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialEquation)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getEquationItemsCount(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getEquationItemsCount(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getEquationItemsCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getEquationItemsCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getEquationItemsCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getEquationItemsCount)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getNthEquationItem(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer _index, modelica_string *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthEquationItem(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype _index, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthEquationItem,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthEquationItem,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthEquationItem MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthEquationItem)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getInitialEquationItemsCount(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getInitialEquationItemsCount(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialEquationItemsCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getInitialEquationItemsCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getInitialEquationItemsCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialEquationItemsCount)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getNthInitialEquationItem(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer _index, modelica_string *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthInitialEquationItem(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype _index, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialEquationItem,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthInitialEquationItem,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthInitialEquationItem MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialEquationItem)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getAnnotationCount(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getAnnotationCount(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAnnotationCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAnnotationCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getAnnotationCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAnnotationCount)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getNthAnnotationString(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer _index, modelica_string *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthAnnotationString(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype _index, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthAnnotationString,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthAnnotationString,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthAnnotationString MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthAnnotationString)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getImportCount(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getImportCount(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getImportCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getImportCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getImportCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getImportCount)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getNthImport(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_integer _index, modelica_metatype *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthImport(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype _index, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthImport,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthImport,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthImport MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthImport)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_iconv(threadData_t *threadData, modelica_metatype _st, modelica_string _string, modelica_string _from, modelica_string _to, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_iconv omc_OpenModelicaScriptingAPI_iconv
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_iconv,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_iconv,0}};
#define boxvar_OpenModelicaScriptingAPI_iconv MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_iconv)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getDocumentationAnnotation(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_getDocumentationAnnotation omc_OpenModelicaScriptingAPI_getDocumentationAnnotation
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDocumentationAnnotation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getDocumentationAnnotation,0}};
#define boxvar_OpenModelicaScriptingAPI_getDocumentationAnnotation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDocumentationAnnotation)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_setDocumentationAnnotation(threadData_t *threadData, modelica_metatype _st, modelica_string _class_, modelica_string _info, modelica_string _revisions, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_setDocumentationAnnotation(threadData_t *threadData, modelica_metatype _st, modelica_metatype _class_, modelica_metatype _info, modelica_metatype _revisions, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setDocumentationAnnotation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setDocumentationAnnotation,0}};
#define boxvar_OpenModelicaScriptingAPI_setDocumentationAnnotation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setDocumentationAnnotation)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getTimeStamp(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_real *out_res1, modelica_string *out_res2);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getTimeStamp(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res1, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getTimeStamp,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getTimeStamp,0}};
#define boxvar_OpenModelicaScriptingAPI_getTimeStamp MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getTimeStamp)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_stringTypeName(threadData_t *threadData, modelica_metatype _st, modelica_string _str, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_stringTypeName omc_OpenModelicaScriptingAPI_stringTypeName
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_stringTypeName,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_stringTypeName,0}};
#define boxvar_OpenModelicaScriptingAPI_stringTypeName MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_stringTypeName)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_typeNameString(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_typeNameString omc_OpenModelicaScriptingAPI_typeNameString
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_typeNameString,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_typeNameString,0}};
#define boxvar_OpenModelicaScriptingAPI_typeNameString MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_typeNameString)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_typeNameStrings(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_typeNameStrings omc_OpenModelicaScriptingAPI_typeNameStrings
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_typeNameStrings,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_typeNameStrings,0}};
#define boxvar_OpenModelicaScriptingAPI_typeNameStrings MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_typeNameStrings)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getClassComment(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getClassComment omc_OpenModelicaScriptingAPI_getClassComment
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassComment,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getClassComment,0}};
#define boxvar_OpenModelicaScriptingAPI_getClassComment MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassComment)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_dirname(threadData_t *threadData, modelica_metatype _st, modelica_string _path, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_dirname omc_OpenModelicaScriptingAPI_dirname
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_dirname,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_dirname,0}};
#define boxvar_OpenModelicaScriptingAPI_dirname MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_dirname)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_basename(threadData_t *threadData, modelica_metatype _st, modelica_string _path, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_basename omc_OpenModelicaScriptingAPI_basename
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_basename,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_basename,0}};
#define boxvar_OpenModelicaScriptingAPI_basename MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_basename)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getClassRestriction(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getClassRestriction omc_OpenModelicaScriptingAPI_getClassRestriction
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassRestriction,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getClassRestriction,0}};
#define boxvar_OpenModelicaScriptingAPI_getClassRestriction MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassRestriction)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isType(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isType(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isType,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isType,0}};
#define boxvar_OpenModelicaScriptingAPI_isType MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isType)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isPackage(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isPackage(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isPackage,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isPackage,0}};
#define boxvar_OpenModelicaScriptingAPI_isPackage MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isPackage)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isClass(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isClass(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isClass,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isClass,0}};
#define boxvar_OpenModelicaScriptingAPI_isClass MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isClass)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isRecord(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isRecord(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isRecord,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isRecord,0}};
#define boxvar_OpenModelicaScriptingAPI_isRecord MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isRecord)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isBlock(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isBlock(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isBlock,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isBlock,0}};
#define boxvar_OpenModelicaScriptingAPI_isBlock MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isBlock)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isFunction(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isFunction(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isFunction,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isFunction,0}};
#define boxvar_OpenModelicaScriptingAPI_isFunction MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isFunction)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isPartial(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isPartial(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isPartial,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isPartial,0}};
#define boxvar_OpenModelicaScriptingAPI_isPartial MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isPartial)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isModel(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isModel(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isModel,0}};
#define boxvar_OpenModelicaScriptingAPI_isModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isModel)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isConnector(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isConnector(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isConnector,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isConnector,0}};
#define boxvar_OpenModelicaScriptingAPI_isConnector MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isConnector)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isOptimization(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isOptimization(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOptimization,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isOptimization,0}};
#define boxvar_OpenModelicaScriptingAPI_isOptimization MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOptimization)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isEnumeration(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isEnumeration(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isEnumeration,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isEnumeration,0}};
#define boxvar_OpenModelicaScriptingAPI_isEnumeration MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isEnumeration)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isOperator(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isOperator(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOperator,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isOperator,0}};
#define boxvar_OpenModelicaScriptingAPI_isOperator MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOperator)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isOperatorRecord(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isOperatorRecord(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOperatorRecord,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isOperatorRecord,0}};
#define boxvar_OpenModelicaScriptingAPI_isOperatorRecord MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOperatorRecord)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isOperatorFunction(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isOperatorFunction(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOperatorFunction,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isOperatorFunction,0}};
#define boxvar_OpenModelicaScriptingAPI_isOperatorFunction MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOperatorFunction)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isProtectedClass(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_string _c2, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isProtectedClass(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype _c2, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isProtectedClass,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isProtectedClass,0}};
#define boxvar_OpenModelicaScriptingAPI_isProtectedClass MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isProtectedClass)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getBuiltinType(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getBuiltinType omc_OpenModelicaScriptingAPI_getBuiltinType
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getBuiltinType,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getBuiltinType,0}};
#define boxvar_OpenModelicaScriptingAPI_getBuiltinType MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getBuiltinType)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_isExperiment(threadData_t *threadData, modelica_metatype _st, modelica_string _name, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_isExperiment(threadData_t *threadData, modelica_metatype _st, modelica_metatype _name, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isExperiment,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isExperiment,0}};
#define boxvar_OpenModelicaScriptingAPI_isExperiment MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isExperiment)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getSimulationOptions(threadData_t *threadData, modelica_metatype _st, modelica_string _name, modelica_real _defaultStartTime, modelica_real _defaultStopTime, modelica_real _defaultTolerance, modelica_integer _defaultNumberOfIntervals, modelica_real _defaultInterval, modelica_real *out_res1, modelica_real *out_res2, modelica_real *out_res3, modelica_integer *out_res4, modelica_real *out_res5);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getSimulationOptions(threadData_t *threadData, modelica_metatype _st, modelica_metatype _name, modelica_metatype _defaultStartTime, modelica_metatype _defaultStopTime, modelica_metatype _defaultTolerance, modelica_metatype _defaultNumberOfIntervals, modelica_metatype _defaultInterval, modelica_metatype *out_res1, modelica_metatype *out_res2, modelica_metatype *out_res3, modelica_metatype *out_res4, modelica_metatype *out_res5);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getSimulationOptions,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getSimulationOptions,0}};
#define boxvar_OpenModelicaScriptingAPI_getSimulationOptions MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getSimulationOptions)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_classAnnotationExists(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_string _annotationName, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_classAnnotationExists(threadData_t *threadData, modelica_metatype _st, modelica_metatype _className, modelica_metatype _annotationName, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_classAnnotationExists,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_classAnnotationExists,0}};
#define boxvar_OpenModelicaScriptingAPI_classAnnotationExists MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_classAnnotationExists)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getBooleanClassAnnotation(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_string _annotationName, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getBooleanClassAnnotation(threadData_t *threadData, modelica_metatype _st, modelica_metatype _className, modelica_metatype _annotationName, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getBooleanClassAnnotation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getBooleanClassAnnotation,0}};
#define boxvar_OpenModelicaScriptingAPI_getBooleanClassAnnotation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getBooleanClassAnnotation)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_extendsFrom(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_string _baseClassName, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_extendsFrom(threadData_t *threadData, modelica_metatype _st, modelica_metatype _className, modelica_metatype _baseClassName, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_extendsFrom,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_extendsFrom,0}};
#define boxvar_OpenModelicaScriptingAPI_extendsFrom MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_extendsFrom)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_searchClassNames(threadData_t *threadData, modelica_metatype _st, modelica_string _searchText, modelica_boolean _findInText, modelica_metatype *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_searchClassNames(threadData_t *threadData, modelica_metatype _st, modelica_metatype _searchText, modelica_metatype _findInText, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_searchClassNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_searchClassNames,0}};
#define boxvar_OpenModelicaScriptingAPI_searchClassNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_searchClassNames)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getAvailableLibraries(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_getAvailableLibraries omc_OpenModelicaScriptingAPI_getAvailableLibraries
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableLibraries,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAvailableLibraries,0}};
#define boxvar_OpenModelicaScriptingAPI_getAvailableLibraries MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableLibraries)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getUses(threadData_t *threadData, modelica_metatype _st, modelica_string _pack, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_getUses omc_OpenModelicaScriptingAPI_getUses
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getUses,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getUses,0}};
#define boxvar_OpenModelicaScriptingAPI_getUses MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getUses)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getDerivedClassModifierNames(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_metatype *out_res);
#define boxptr_OpenModelicaScriptingAPI_getDerivedClassModifierNames omc_OpenModelicaScriptingAPI_getDerivedClassModifierNames
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDerivedClassModifierNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getDerivedClassModifierNames,0}};
#define boxvar_OpenModelicaScriptingAPI_getDerivedClassModifierNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDerivedClassModifierNames)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getDerivedClassModifierValue(threadData_t *threadData, modelica_metatype _st, modelica_string _className, modelica_string _modifierName, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_getDerivedClassModifierValue omc_OpenModelicaScriptingAPI_getDerivedClassModifierValue
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDerivedClassModifierValue,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getDerivedClassModifierValue,0}};
#define boxvar_OpenModelicaScriptingAPI_getDerivedClassModifierValue MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDerivedClassModifierValue)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_generateEntryPoint(threadData_t *threadData, modelica_metatype _st, modelica_string _fileName, modelica_string _entryPoint, modelica_string _url);
#define boxptr_OpenModelicaScriptingAPI_generateEntryPoint omc_OpenModelicaScriptingAPI_generateEntryPoint
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateEntryPoint,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateEntryPoint,0}};
#define boxvar_OpenModelicaScriptingAPI_generateEntryPoint MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateEntryPoint)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_numProcessors(threadData_t *threadData, modelica_metatype _st, modelica_integer *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_numProcessors(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_numProcessors,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_numProcessors,0}};
#define boxvar_OpenModelicaScriptingAPI_numProcessors MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_numProcessors)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_runScriptParallel(threadData_t *threadData, modelica_metatype _st, modelica_metatype _scripts, modelica_integer _numThreads, modelica_boolean _useThreads, modelica_metatype *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_runScriptParallel(threadData_t *threadData, modelica_metatype _st, modelica_metatype _scripts, modelica_metatype _numThreads, modelica_metatype _useThreads, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_runScriptParallel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_runScriptParallel,0}};
#define boxvar_OpenModelicaScriptingAPI_runScriptParallel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_runScriptParallel)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_exit(threadData_t *threadData, modelica_metatype _st, modelica_integer _status);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_exit(threadData_t *threadData, modelica_metatype _st, modelica_metatype _status);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_exit,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_exit,0}};
#define boxvar_OpenModelicaScriptingAPI_exit MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_exit)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_threadWorkFailed(threadData_t *threadData, modelica_metatype _st);
#define boxptr_OpenModelicaScriptingAPI_threadWorkFailed omc_OpenModelicaScriptingAPI_threadWorkFailed
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_threadWorkFailed,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_threadWorkFailed,0}};
#define boxvar_OpenModelicaScriptingAPI_threadWorkFailed MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_threadWorkFailed)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getMemorySize(threadData_t *threadData, modelica_metatype _st, modelica_real *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getMemorySize(threadData_t *threadData, modelica_metatype _st, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getMemorySize,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getMemorySize,0}};
#define boxvar_OpenModelicaScriptingAPI_getMemorySize MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getMemorySize)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_GC__gcollect__and__unmap(threadData_t *threadData, modelica_metatype _st);
#define boxptr_OpenModelicaScriptingAPI_GC__gcollect__and__unmap omc_OpenModelicaScriptingAPI_GC__gcollect__and__unmap
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_GC__gcollect__and__unmap,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_GC__gcollect__and__unmap,0}};
#define boxvar_OpenModelicaScriptingAPI_GC__gcollect__and__unmap MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_GC__gcollect__and__unmap)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_GC__expand__hp(threadData_t *threadData, modelica_metatype _st, modelica_integer _size, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_GC__expand__hp(threadData_t *threadData, modelica_metatype _st, modelica_metatype _size, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_GC__expand__hp,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_GC__expand__hp,0}};
#define boxvar_OpenModelicaScriptingAPI_GC__expand__hp MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_GC__expand__hp)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_checkInterfaceOfPackages(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_metatype _dependencyMatrix, modelica_boolean *out_res);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_checkInterfaceOfPackages(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype _dependencyMatrix, modelica_metatype *out_res);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkInterfaceOfPackages,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_checkInterfaceOfPackages,0}};
#define boxvar_OpenModelicaScriptingAPI_checkInterfaceOfPackages MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkInterfaceOfPackages)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_sortStrings(threadData_t *threadData, modelica_metatype _st, modelica_metatype _arr, modelica_string *out_res);
#define boxptr_OpenModelicaScriptingAPI_sortStrings omc_OpenModelicaScriptingAPI_sortStrings
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_sortStrings,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_sortStrings,0}};
#define boxvar_OpenModelicaScriptingAPI_sortStrings MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_sortStrings)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_getClassInformation(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_string *out_res1, modelica_string *out_res2, modelica_boolean *out_res3, modelica_boolean *out_res4, modelica_boolean *out_res5, modelica_string *out_res6, modelica_boolean *out_res7, modelica_integer *out_res8, modelica_integer *out_res9, modelica_integer *out_res10, modelica_integer *out_res11, modelica_metatype *out_res12);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_getClassInformation(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype *out_res1, modelica_metatype *out_res2, modelica_metatype *out_res3, modelica_metatype *out_res4, modelica_metatype *out_res5, modelica_metatype *out_res6, modelica_metatype *out_res7, modelica_metatype *out_res8, modelica_metatype *out_res9, modelica_metatype *out_res10, modelica_metatype *out_res11, modelica_metatype *out_res12);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassInformation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getClassInformation,0}};
#define boxvar_OpenModelicaScriptingAPI_getClassInformation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassInformation)

DLLExport
modelica_metatype omc_OpenModelicaScriptingAPI_generateScriptingAPI(threadData_t *threadData, modelica_metatype _st, modelica_string _cl, modelica_string _name, modelica_boolean *out_res1, modelica_string *out_res2, modelica_string *out_res3, modelica_string *out_res4);
DLLExport
modelica_metatype boxptr_OpenModelicaScriptingAPI_generateScriptingAPI(threadData_t *threadData, modelica_metatype _st, modelica_metatype _cl, modelica_metatype _name, modelica_metatype *out_res1, modelica_metatype *out_res2, modelica_metatype *out_res3, modelica_metatype *out_res4);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateScriptingAPI,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateScriptingAPI,0}};
#define boxvar_OpenModelicaScriptingAPI_generateScriptingAPI MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateScriptingAPI)

#ifdef __cplusplus
}
#endif
#endif
