/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.test;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AbstractGraph;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.graph.implementations.SingleGraph;
import org.junit.Ignore;

@Ignore
public class BenchPerformance {
    Graph g;
    Runtime r = Runtime.getRuntime();
    List<String> nodeIds;
    List<String> edgeIds;
    long start;
    long end;
    EnumMap<Measures, Long> measureValues;

    static void forceGC() {
        int i = 0;
        while (i < 10) {
            System.gc();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(0);
            }
            ++i;
        }
    }

    public BenchPerformance(String fileName, Graph graph) {
        BenchPerformance.forceGC();
        long used1 = this.r.totalMemory() - this.r.freeMemory();
        this.g = graph;
        try {
            this.g.read(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        System.out.println("Graph read: " + this.g.getNodeCount() + " nodes and " + this.g.getEdgeCount() + " edges");
        for (Node n : this.g) {
            n.clearAttributes();
        }
        for (Edge e : this.g.getEachEdge()) {
            e.clearAttributes();
        }
        BenchPerformance.forceGC();
        long used2 = this.r.totalMemory() - this.r.freeMemory();
        this.measureValues = new EnumMap(Measures.class);
        this.measureValues.put(Measures.MEMORY, used2 - used1);
        this.nodeIds = new ArrayList<String>(this.g.getNodeCount());
        for (Node n : this.g) {
            this.nodeIds.add(n.getId());
        }
        Collections.sort(this.nodeIds);
        this.edgeIds = new ArrayList<String>(this.g.getEdgeCount());
        for (Edge e : this.g.getEachEdge()) {
            this.edgeIds.add(e.getId());
        }
        Collections.sort(this.edgeIds);
    }

    public int testAccessById() {
        int foo = 0;
        this.start = System.currentTimeMillis();
        for (String id : this.nodeIds) {
            Object n = this.g.getNode(id);
            if (!n.hasAttribute("foo")) continue;
            ++foo;
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.NODE_BY_ID, this.end - this.start);
        this.start = System.currentTimeMillis();
        for (String id : this.edgeIds) {
            Object e = this.g.getEdge(id);
            if (!e.hasAttribute("foo")) continue;
            ++foo;
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.EDGE_BY_ID, this.end - this.start);
        return foo;
    }

    public int testGraphIterators() {
        int foo = 0;
        this.start = System.currentTimeMillis();
        Iterator nodeIt = this.g.getNodeIterator();
        while (nodeIt.hasNext()) {
            Node n = (Node)nodeIt.next();
            if (!n.hasAttribute("foo")) continue;
            ++foo;
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.GRAPH_NODE_IT, this.end - this.start);
        this.start = System.currentTimeMillis();
        Iterator edgeIt = this.g.getEdgeIterator();
        while (edgeIt.hasNext()) {
            Edge e = (Edge)edgeIt.next();
            if (!e.hasAttribute("foo")) continue;
            ++foo;
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.GRAPH_EDGE_IT, this.end - this.start);
        return foo;
    }

    public int testNodeIterators() {
        Edge e;
        Iterator edgeIt;
        Node n;
        int foo = 0;
        this.start = System.currentTimeMillis();
        Iterator nodeIt = this.g.getNodeIterator();
        while (nodeIt.hasNext()) {
            n = (Node)nodeIt.next();
            edgeIt = n.getEdgeIterator();
            while (edgeIt.hasNext()) {
                e = (Edge)edgeIt.next();
                if (!e.hasAttribute("foo")) continue;
                ++foo;
            }
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.NODE_EDGE_IT, this.end - this.start);
        this.start = System.currentTimeMillis();
        nodeIt = this.g.getNodeIterator();
        while (nodeIt.hasNext()) {
            n = (Node)nodeIt.next();
            edgeIt = n.getEnteringEdgeIterator();
            while (edgeIt.hasNext()) {
                e = (Edge)edgeIt.next();
                if (!e.hasAttribute("foo")) continue;
                ++foo;
            }
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.NODE_ENTERING_EDGE_IT, this.end - this.start);
        this.start = System.currentTimeMillis();
        nodeIt = this.g.getNodeIterator();
        while (nodeIt.hasNext()) {
            n = (Node)nodeIt.next();
            edgeIt = n.getLeavingEdgeIterator();
            while (edgeIt.hasNext()) {
                e = (Edge)edgeIt.next();
                if (!e.hasAttribute("foo")) continue;
                ++foo;
            }
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.NODE_LEAVING_EDGE_IT, this.end - this.start);
        this.start = System.currentTimeMillis();
        nodeIt = this.g.getNodeIterator();
        while (nodeIt.hasNext()) {
            n = (Node)nodeIt.next();
            Iterator neighborIt = n.getNeighborNodeIterator();
            while (neighborIt.hasNext()) {
                Node neighbor = (Node)neighborIt.next();
                if (!neighbor.hasAttribute("foo")) continue;
                ++foo;
            }
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.NODE_NEIGHBOR_IT, this.end - this.start);
        this.start = System.currentTimeMillis();
        nodeIt = this.g.getNodeIterator();
        while (nodeIt.hasNext()) {
            n = (Node)nodeIt.next();
            int i = 0;
            while (i < n.getDegree()) {
                e = n.getEdge(i);
                if (e.hasAttribute("foo")) {
                    ++foo;
                }
                ++i;
            }
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.NODE_GET_EDGE, this.end - this.start);
        return foo;
    }

    public int testBfsDfs() {
        Node node;
        int foo = 0;
        this.start = System.currentTimeMillis();
        int i = 0;
        while (i < 1000) {
            Iterator bfsIt = this.g.getNode(this.nodeIds.get(i)).getBreadthFirstIterator();
            while (bfsIt.hasNext()) {
                node = (Node)bfsIt.next();
                if (!node.hasAttribute("foo")) continue;
                ++foo;
            }
            ++i;
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.BFS_IT, this.end - this.start);
        this.start = System.currentTimeMillis();
        if (this.g instanceof AbstractGraph) {
            i = 0;
            while (i < 1000) {
                Iterator dfsIt = this.g.getNode(this.nodeIds.get(i)).getDepthFirstIterator();
                while (dfsIt.hasNext()) {
                    node = (Node)dfsIt.next();
                    if (!node.hasAttribute("foo")) continue;
                    ++foo;
                }
                ++i;
            }
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.DFS_IT, this.end - this.start);
        return foo;
    }

    public int testTriangleCount() {
        this.start = System.currentTimeMillis();
        int count = 0;
        for (Node n0 : this.g) {
            int d = n0.getDegree();
            int i = 0;
            while (i < d) {
                Object n1 = n0.getEdge(i).getOpposite(n0);
                String n1id = n1.getId();
                int j = i + 1;
                while (j < d) {
                    Object n2 = n0.getEdge(j).getOpposite(n0);
                    if (n2.hasEdgeBetween(n1id)) {
                        ++count;
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.TRIANGLE, this.end - this.start);
        return count / 3;
    }

    public int testTriangleCountIndex() {
        this.start = System.currentTimeMillis();
        int count = 0;
        for (Node n0 : this.g) {
            int d = n0.getDegree();
            int i = 0;
            while (i < d) {
                Object n1 = n0.getEdge(i).getOpposite(n0);
                if (n0.getIndex() < n1.getIndex()) {
                    int j = i + 1;
                    while (j < d) {
                        Object n2 = n0.getEdge(j).getOpposite(n0);
                        if (n1.getIndex() < n2.getIndex() && n2.hasEdgeBetween((Node)n1)) {
                            ++count;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.TRIANGLE, this.end - this.start);
        return count;
    }

    public int testFindEdge() {
        Object e;
        Object n1;
        int foo = 0;
        long start = System.currentTimeMillis();
        for (String id1 : this.nodeIds) {
            n1 = this.g.getNode(id1);
            for (String id2 : this.nodeIds) {
                e = n1.getEdgeBetween(id2);
                if (e == null || !e.hasAttribute("foo")) continue;
                ++foo;
            }
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.EDGE_BETWEEN, this.end - start);
        start = System.currentTimeMillis();
        for (String id1 : this.nodeIds) {
            n1 = this.g.getNode(id1);
            for (String id2 : this.nodeIds) {
                e = n1.getEdgeToward(id2);
                if (e == null || !e.hasAttribute("foo")) continue;
                ++foo;
            }
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.EDGE_TOWARD, this.end - start);
        start = System.currentTimeMillis();
        for (String id1 : this.nodeIds) {
            n1 = this.g.getNode(id1);
            for (String id2 : this.nodeIds) {
                e = n1.getEdgeFrom(id2);
                if (e == null || !e.hasAttribute("foo")) continue;
                ++foo;
            }
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.EDGE_FROM, this.end - start);
        return foo;
    }

    public void testAddRemove() {
        this.start = System.currentTimeMillis();
        int i = 0;
        while (i < 10000) {
            this.g.addNode("__newnode__" + i);
            ++i;
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.ADD_NODE, this.end - this.start);
        this.start = System.currentTimeMillis();
        int current = 0;
        int edgeId = 0;
        int i2 = 0;
        while (i2 < 10000) {
            String id = "__newnode__" + i2;
            int j = 0;
            while (j < 100) {
                this.g.addEdge("__newedge__" + edgeId, id, this.nodeIds.get(current));
                ++edgeId;
                if (++current == this.nodeIds.size()) {
                    current = 0;
                }
                ++j;
            }
            ++i2;
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.ADD_EDGE, this.end - this.start);
        this.start = System.currentTimeMillis();
        i2 = 0;
        while (i2 < 10000) {
            this.g.removeNode("__newnode__" + i2);
            ++i2;
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.REMOVE_NODE, this.end - this.start);
        this.start = System.currentTimeMillis();
        i2 = 0;
        while (i2 < 10000) {
            this.g.removeEdge(this.edgeIds.get(i2));
            ++i2;
        }
        this.end = System.currentTimeMillis();
        this.measureValues.put(Measures.REMOVE_EDGE, this.end - this.start);
    }

    public static void latexOutput(BenchPerformance[] tests, PrintStream ps) {
        String header = "\\begin{tabular}{|l|";
        int i = 0;
        while (i < tests.length) {
            header = String.valueOf(header) + "r";
            ++i;
        }
        header = String.valueOf(header) + "|}";
        ps.println(header);
        ps.println("\\hline");
        ps.printf("%35s ", "measure");
        Object[] objectArray = tests;
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            BenchPerformance t = objectArray[n2];
            ps.printf("& %10s ", t.g.getId());
            ++n2;
        }
        ps.println("\\\\");
        ps.println("\\hline");
        objectArray = Measures.values();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            BenchPerformance m = objectArray[n2];
            if (tests[0].measureValues.containsKey(m)) {
                ps.printf("%35s ", "\\lstinline~" + ((Enum)((Object)m)).name() + "~");
                BenchPerformance[] benchPerformanceArray = tests;
                int n3 = tests.length;
                int n4 = 0;
                while (n4 < n3) {
                    BenchPerformance t = benchPerformanceArray[n4];
                    double val = t.measureValues.get(m).longValue();
                    val = m == Measures.MEMORY ? (val /= 1048576.0) : (val /= 1000.0);
                    ps.printf("& %10.3f ", val);
                    ++n4;
                }
                ps.println("\\\\");
            }
            ++n2;
        }
        ps.println("\\hline");
        ps.println("\\end{tabular}");
    }

    public static void main(String[] args) {
        String fileName = args[0];
        int gCount = 2;
        Graph[] graphs = new Graph[gCount];
        graphs[0] = new SingleGraph("Single");
        graphs[2] = new AdjacencyListGraph("Adj");
        BenchPerformance[] tests = new BenchPerformance[gCount];
        int i = 0;
        while (i < gCount) {
            System.out.println("Loading graph " + graphs[i].getId());
            tests[i] = new BenchPerformance(fileName, graphs[i]);
            System.out.println("  Testing access by id");
            tests[i].testAccessById();
            System.out.println("  Testing graph iterators");
            tests[i].testGraphIterators();
            System.out.println("  Testing node iterators");
            tests[i].testNodeIterators();
            System.out.println("  Testing BFS and DFS iterators");
            tests[i].testBfsDfs();
            System.out.println("  Testing finding edges");
            tests[i].testFindEdge();
            System.out.println("  Testing triangles");
            tests[i].testTriangleCount();
            System.out.println("  Testing add / remove");
            tests[i].testAddRemove();
            tests[i].g.clear();
            tests[i].nodeIds.clear();
            tests[i].nodeIds = null;
            tests[i].edgeIds.clear();
            tests[i].edgeIds = null;
            ++i;
        }
        BenchPerformance.latexOutput(tests, System.out);
    }

    static enum Measures {
        MEMORY,
        NODE_BY_ID,
        EDGE_BY_ID,
        GRAPH_NODE_IT,
        GRAPH_EDGE_IT,
        NODE_EDGE_IT,
        NODE_ENTERING_EDGE_IT,
        NODE_LEAVING_EDGE_IT,
        NODE_NEIGHBOR_IT,
        NODE_GET_EDGE,
        BFS_IT,
        DFS_IT,
        EDGE_BETWEEN,
        EDGE_FROM,
        EDGE_TOWARD,
        TRIANGLE,
        ADD_NODE,
        ADD_EDGE,
        REMOVE_NODE,
        REMOVE_EDGE;

    }
}

