/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.stream.SourceBase;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphPosLengthUtils;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.stylesheet.Selector;

public class GraphicNode
extends GraphicElement
implements Node {
    public double x;
    public double y;
    public double z;
    public boolean positionned = false;

    public GraphicNode(GraphicGraph graph, String id, HashMap<String, Object> attributes) {
        super(id, graph);
        if (attributes != null) {
            this.addAttributes(attributes);
        }
    }

    @Override
    public Selector.Type getSelectorType() {
        return Selector.Type.NODE;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    protected Point3 getPosition() {
        return new Point3(this.x, this.y, this.z);
    }

    protected void moveFromEvent(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        if (!this.positionned) {
            this.positionned = true;
        }
        this.mygraph.graphChanged = true;
        this.mygraph.boundsChanged = true;
    }

    @Override
    public void move(double x, double y, double z) {
        this.moveFromEvent(x, y, z);
        if (this.mygraph.feedbackXYZ) {
            this.setAttribute("xyz", x, y, z);
        }
    }

    @Override
    protected void attributeChanged(AbstractElement.AttributeChangeEvent event, String attribute, Object oldValue, Object newValue) {
        super.attributeChanged(event, attribute, oldValue, newValue);
        char c = attribute.charAt(0);
        if (attribute.length() > 2 && c == 'u' && attribute.charAt(1) == 'i' && attribute.startsWith("ui.sprite.")) {
            this.mygraph.spriteAttribute(event, this, attribute, newValue);
        } else if (event == AbstractElement.AttributeChangeEvent.ADD || event == AbstractElement.AttributeChangeEvent.CHANGE) {
            if (attribute.length() == 1) {
                switch (c) {
                    case 'x': {
                        this.moveFromEvent(this.numberAttribute(newValue), this.y, this.z);
                        break;
                    }
                    case 'y': {
                        this.moveFromEvent(this.x, this.numberAttribute(newValue), this.z);
                        break;
                    }
                    case 'z': {
                        this.moveFromEvent(this.x, this.y, this.numberAttribute(newValue));
                        break;
                    }
                }
            } else if (c == 'x' && attribute.length() > 1 && attribute.charAt(1) == 'y' && (attribute.length() == 2 || attribute.length() == 3 && attribute.charAt(2) == 'z')) {
                double[] pos = GraphPosLengthUtils.nodePosition(this);
                this.moveFromEvent(pos[0], pos[1], pos[2]);
            }
        }
        this.mygraph.listeners.sendAttributeChangedEvent(this.getId(), SourceBase.ElementType.NODE, attribute, event, oldValue, newValue);
    }

    protected double numberAttribute(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (value instanceof CharSequence) {
            try {
                return Double.parseDouble(((CharSequence)value).toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    @Override
    protected void removed() {
    }

    public Iterator<Node> getBreadthFirstIterator() {
        throw new RuntimeException("not implemented !");
    }

    public Iterator<Node> getBreadthFirstIterator(boolean directed) {
        throw new RuntimeException("not implemented !");
    }

    public Iterator<Node> getDepthFirstIterator() {
        throw new RuntimeException("not implemented !");
    }

    public Iterator<Node> getDepthFirstIterator(boolean directed) {
        throw new RuntimeException("not implemented !");
    }

    @Override
    public int getDegree() {
        ArrayList<GraphicEdge> edges = this.mygraph.connectivity.get(this);
        if (edges != null) {
            return edges.size();
        }
        return 0;
    }

    @Override
    public <T extends Edge> T getEdge(int i) {
        ArrayList<GraphicEdge> edges = this.mygraph.connectivity.get(this);
        if (edges != null && i >= 0 && i < edges.size()) {
            return (T)edges.get(i);
        }
        return null;
    }

    @Override
    public <T extends Edge> T getEdgeBetween(String id) {
        if (this.hasEdgeToward(id)) {
            return this.getEdgeToward(id);
        }
        return this.getEdgeFrom(id);
    }

    @Override
    public <T extends Edge> T getEdgeFrom(String id) {
        return null;
    }

    @Override
    public <T extends Edge> Iterator<T> getEdgeIterator() {
        ArrayList<GraphicEdge> edges = this.mygraph.connectivity.get(this);
        if (edges != null) {
            return edges.iterator();
        }
        return null;
    }

    @Override
    public Iterator<Edge> iterator() {
        return this.getEdgeIterator();
    }

    @Override
    public <T extends Edge> Iterable<T> getEachEdge() {
        return this.mygraph.connectivity.get(this);
    }

    @Override
    public <T extends Edge> Collection<T> getEdgeSet() {
        return Collections.unmodifiableCollection((Collection)this.mygraph.connectivity.get(this));
    }

    @Override
    public <T extends Edge> T getEdgeToward(String id) {
        ArrayList<GraphicEdge> edges = this.mygraph.connectivity.get(this);
        for (Edge edge : edges) {
            if (!edge.getOpposite(this).getId().equals(id)) continue;
            return (T)edge;
        }
        return null;
    }

    @Override
    public <T extends Edge> Iterator<T> getEnteringEdgeIterator() {
        return this.getEdgeIterator();
    }

    @Override
    public <T extends Edge> Iterable<T> getEachEnteringEdge() {
        return this.getEdgeSet();
    }

    @Override
    public <T extends Edge> Collection<T> getEnteringEdgeSet() {
        return Collections.unmodifiableCollection(this.getEdgeSet());
    }

    @Override
    public Graph getGraph() {
        return this.mygraph;
    }

    public String getGraphName() {
        throw new RuntimeException("impossible with GraphicGraph");
    }

    public String getHost() {
        throw new RuntimeException("impossible with GraphicGraph");
    }

    @Override
    public int getInDegree() {
        return this.getDegree();
    }

    @Override
    public <T extends Edge> Iterator<T> getLeavingEdgeIterator() {
        return this.getEdgeIterator();
    }

    @Override
    public <T extends Edge> Iterable<T> getEachLeavingEdge() {
        return this.getEdgeSet();
    }

    @Override
    public <T extends Edge> Collection<T> getLeavingEdgeSet() {
        return Collections.unmodifiableCollection(this.getEdgeSet());
    }

    public Iterator<Node> getNeighborNodeIterator() {
        return null;
    }

    @Override
    public int getOutDegree() {
        return this.getDegree();
    }

    @Override
    public boolean hasEdgeBetween(String id) {
        return this.hasEdgeToward(id) || this.hasEdgeFrom(id);
    }

    @Override
    public boolean hasEdgeFrom(String id) {
        return false;
    }

    @Override
    public boolean hasEdgeToward(String id) {
        return false;
    }

    public boolean isDistributed() {
        return false;
    }

    public void setGraph(Graph graph) {
        throw new RuntimeException("impossible with GraphicGraph");
    }

    public void setGraphName(String newHost) {
        throw new RuntimeException("impossible with GraphicGraph");
    }

    public void setHost(String newHost) {
        throw new RuntimeException("impossible with GraphicGraph");
    }

    @Override
    public <T extends Edge> T getEdgeBetween(Node Node2) {
        return null;
    }

    @Override
    public <T extends Edge> T getEdgeBetween(int index) {
        return null;
    }

    @Override
    public <T extends Edge> T getEdgeFrom(Node Node2) {
        return null;
    }

    @Override
    public <T extends Edge> T getEdgeFrom(int index) {
        return null;
    }

    @Override
    public <T extends Edge> T getEdgeToward(Node Node2) {
        return null;
    }

    @Override
    public <T extends Edge> T getEdgeToward(int index) {
        return null;
    }

    @Override
    public boolean hasEdgeBetween(Node node) {
        return false;
    }

    @Override
    public boolean hasEdgeBetween(int index) {
        return false;
    }

    @Override
    public boolean hasEdgeFrom(Node node) {
        return false;
    }

    @Override
    public boolean hasEdgeFrom(int index) {
        return false;
    }

    @Override
    public boolean hasEdgeToward(Node node) {
        return false;
    }

    @Override
    public boolean hasEdgeToward(int index) {
        return false;
    }

    @Override
    public <T extends Edge> T getEnteringEdge(int i) {
        return null;
    }

    @Override
    public <T extends Edge> T getLeavingEdge(int i) {
        return null;
    }
}

