/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.dgs.test;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.stream.SinkAdapter;
import org.graphstream.stream.file.FileSourceDGS;
import org.graphstream.util.VerboseSink;
import org.graphstream.util.parser.ParseException;
import org.junit.Assert;
import org.junit.Test;

public class TestDGSParser {
    protected File newTemporaryFile(String suffix) throws IOException {
        return File.createTempFile(this.getClass().getSimpleName(), suffix);
    }

    protected Graph getGraph(String resource) throws IOException {
        AdjacencyListGraph g = new AdjacencyListGraph("test");
        FileSourceDGS in = new FileSourceDGS();
        in.addSink(g);
        in.readAll(this.getClass().getResourceAsStream(resource));
        in.removeSink(g);
        return g;
    }

    @Test
    public void testArrayAttribute() throws IOException {
        Graph g = this.getGraph("data/attributes_array.dgs");
        Object n = g.getNode(0);
        if (!n.hasArray("a1")) {
            Assert.fail();
        }
        if (!n.hasArray("a2")) {
            Assert.fail();
        }
        Object[] a1 = n.getArray("a1");
        Object[] a2 = n.getArray("a2");
        Object[] expected = new Object[]{"A", "B", "C"};
        Assert.assertArrayEquals((Object[])expected, (Object[])a1);
        Assert.assertArrayEquals((Object[])expected, (Object[])a2);
    }

    @Test
    public void testAttributes() throws IOException {
        Graph g = this.getGraph("data/attributes.dgs");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", 1);
        map.put("b", 2);
        map.put("c", 3);
        Object[][] aoa = new Object[][]{{1, 2}, {3}, {4, 5}};
        Attribute[] attributes = new Attribute[]{new Attribute("int", Integer.class, 123), new Attribute("double", Double.class, 123.321), new Attribute("string", String.class, "a string"), new Attribute("word", String.class, "aWord"), new Attribute("color", Color.class, Color.RED), new Attribute("map", Map.class, map), new Attribute("array", Integer.class, new Object[]{1, 2, 3}), new Attribute("aoa", Object[].class, aoa), new Attribute("big_sci", Double.class, Double.valueOf("1.27E+07")), new Attribute("small_sci", Double.class, Double.valueOf("1.27E-07")), new Attribute("neg_sci", Double.class, Double.valueOf("-1.27E-07"))};
        for (Node n : g) {
            Attribute[] attributeArray = attributes;
            int n2 = attributes.length;
            int n3 = 0;
            while (n3 < n2) {
                Attribute a = attributeArray[n3];
                a.check(n);
                ++n3;
            }
        }
    }

    @Test
    public void testElements() throws IOException {
        Graph g = this.getGraph("data/elements.dgs");
        Object A = g.getNode("A");
        Object B = g.getNode("B");
        Object C = g.getNode("C");
        Assert.assertEquals((long)g.getNodeCount(), (long)3L);
        Assert.assertNotNull(A);
        Assert.assertNotNull(B);
        Assert.assertNotNull(C);
        Object AB = g.getEdge("AB");
        Object AC = g.getEdge("AC");
        Object BC = g.getEdge("BC");
        Assert.assertEquals((long)g.getEdgeCount(), (long)3L);
        Assert.assertNotNull(AB);
        Assert.assertNotNull(AC);
        Assert.assertNotNull(BC);
        Assert.assertFalse((boolean)AB.isDirected());
        Assert.assertTrue((boolean)AC.isDirected());
        Assert.assertTrue((boolean)BC.isDirected());
        Assert.assertEquals(A, AB.getNode0());
        Assert.assertEquals(B, AB.getNode1());
        Assert.assertEquals(A, AC.getSourceNode());
        Assert.assertEquals(C, AC.getTargetNode());
        Assert.assertEquals(B, BC.getSourceNode());
        Assert.assertEquals(C, BC.getTargetNode());
    }

    @Test
    public void testBadExamples() throws IOException {
        String[] data = new String[]{"bad1.dgs", "bad2.dgs"};
        int i = 0;
        while (i < data.length) {
            block4: {
                try {
                    this.getGraph("data/" + data[i]);
                    Assert.fail();
                }
                catch (Exception e) {
                    if (e.getCause() instanceof ParseException) break block4;
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    Assert.fail();
                }
            }
            ++i;
        }
    }

    @Test
    public void testEOL() throws IOException {
        String base = "DGS004%neol 0 0%n%nan A%n";
        String[] eols = new String[]{"\n", "\r\n"};
        FileSourceDGS source = new FileSourceDGS();
        AdjacencyListGraph g = new AdjacencyListGraph("eol");
        source.addSink(g);
        String[] stringArray = eols;
        int n = eols.length;
        int n2 = 0;
        while (n2 < n) {
            String eol = stringArray[n2];
            String dgs = base.replace("%n", eol);
            StringReader in = new StringReader(dgs);
            try {
                source.readAll(in);
                Assert.assertNotNull(g.getNode("A"));
                g.clear();
            }
            catch (IOException e) {
                if (e.getCause() instanceof ParseException) {
                    Assert.fail();
                }
                throw e;
            }
            ++n2;
        }
    }

    @Test
    public void testAttributeRemoved() throws IOException {
        FileSourceDGS source = new FileSourceDGS();
        AdjacencyListGraph g = new AdjacencyListGraph("eol");
        source.addSink(g);
        g.addSink(new TestAttributeRemoved("A", g));
        g.addSink(new VerboseSink());
        source.begin(this.getClass().getResourceAsStream("data/removeAttribute.dgs"));
        while (source.nextStep()) {
        }
        source.end();
    }

    private static class Attribute {
        String key;
        Class<?> clazz;
        Object expected;

        Attribute(String key, Class<?> clazz, Object expected) {
            this.key = key;
            this.clazz = clazz;
            this.expected = expected;
        }

        void check(Element e) {
            Object obj = e.getAttribute(this.key);
            if (this.expected.getClass().isArray()) {
                Object[] objArray = (Object[])obj;
                Assert.assertTrue((boolean)this.clazz.isAssignableFrom(objArray[0].getClass()));
                Assert.assertArrayEquals((Object[])((Object[])this.expected), (Object[])objArray);
            } else {
                Assert.assertTrue((boolean)this.clazz.isAssignableFrom(obj.getClass()));
                Assert.assertEquals((Object)this.expected, obj);
            }
        }
    }

    private static class TestAttributeRemoved
    extends SinkAdapter {
        String nodeId;
        boolean added = false;
        boolean changed = false;
        boolean removed = false;
        Object value = null;
        Graph g;

        TestAttributeRemoved(String nodeId, Graph g) {
            this.nodeId = nodeId;
            this.g = g;
        }

        @Override
        public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attributeId, Object value) {
            if (this.nodeId.equals(nodeId)) {
                Assert.assertFalse((boolean)this.added);
                Assert.assertFalse((boolean)this.changed);
                Assert.assertFalse((boolean)this.removed);
                this.added = true;
                this.value = value;
            }
        }

        @Override
        public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attributeId, Object oldValue, Object newValue) {
            if (this.nodeId.equals(nodeId)) {
                Assert.assertTrue((boolean)this.added);
                Assert.assertFalse((boolean)this.changed);
                Assert.assertFalse((boolean)this.removed);
                Assert.assertEquals((Object)this.value, (Object)oldValue);
                this.changed = true;
                this.value = newValue;
            }
        }

        @Override
        public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attributeId) {
            if (this.nodeId.equals(nodeId)) {
                Assert.assertTrue((boolean)this.added);
                Assert.assertTrue((boolean)this.changed);
                Assert.assertFalse((boolean)this.removed);
                Assert.assertEquals((Object)this.value, this.g.getNode(nodeId).getAttribute(attributeId));
                this.removed = true;
                this.value = null;
            }
        }
    }
}

