/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.netstream;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.graphstream.stream.netstream.DefaultNetStreamDecoder;
import org.graphstream.stream.netstream.NetStreamDecoder;
import org.graphstream.stream.netstream.packing.NetStreamUnpacker;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.miv.mbox.net.PositionableByteArrayInputStream;

public class NetStreamReceiver
extends Thread
implements NetStreamDecoder {
    private String hostname;
    private int port;
    protected ServerSocketChannel server;
    protected Selector selector;
    protected SelectionKey key;
    protected boolean loop = true;
    protected boolean debug = true;
    protected String lastError = null;
    protected ThreadProxyPipe currentStream;
    protected NetStreamDecoder decoder;
    protected HashMap<SelectionKey, IncomingBuffer> incoming = new HashMap();
    private NetStreamUnpacker unpacker;
    protected static final String LIGHT_YELLOW = "\u001b[33;1m";
    protected static final String RESET = "\u001b[0m";

    public NetStreamReceiver(String hostname, int port) throws IOException, UnknownHostException {
        this(hostname, port, false);
    }

    public NetStreamReceiver(int port) throws IOException, UnknownHostException {
        this("localhost", port, false);
    }

    public NetStreamReceiver(String hostname, int port, boolean debug) throws IOException, UnknownHostException {
        this.hostname = hostname;
        this.port = port;
        this.unpacker = new DefaultUnpacker();
        this.decoder = new DefaultNetStreamDecoder();
        this.setDebugOn(debug);
        this.init();
        this.start();
    }

    public synchronized boolean isRunning() {
        return this.loop;
    }

    protected void init() throws IOException, UnknownHostException {
        this.selector = Selector.open();
        this.server = ServerSocketChannel.open();
        this.server.configureBlocking(false);
        InetAddress ia = InetAddress.getByName(this.hostname);
        InetSocketAddress isa = new InetSocketAddress(ia, this.port);
        this.server.socket().bind(isa);
        if (this.debug) {
            this.debug("bound to socket %s:%d", this.server.socket().getInetAddress(), this.server.socket().getLocalPort());
        }
        this.key = this.server.register(this.selector, 16);
    }

    @Override
    public void setDebugOn(boolean on) {
        this.debug = on;
        this.decoder.setDebugOn(on);
    }

    public synchronized void quit() {
        this.loop = false;
        this.key.selector().wakeup();
        if (this.debug) {
            this.debug("stopped", new Object[0]);
        }
    }

    public synchronized boolean hasActiveConnections() {
        return !this.incoming.isEmpty();
    }

    public void setUnpacker(NetStreamUnpacker unpaker) {
        this.unpacker = unpaker;
    }

    public void removeUnpacker() {
        this.unpacker = new DefaultUnpacker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        var2_1 = this;
        synchronized (var2_1) {
            l = this.loop;
            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl5 : MonitorExitStatement: MONITOREXIT : var2_1
            if (true) ** GOTO lbl18
        }
        do {
            this.poll();
            var2_1 = this;
            synchronized (var2_1) {
                l = this.loop;
            }
lbl18:
            // 2 sources

        } while (l);
        try {
            this.server.close();
        }
        catch (IOException e) {
            this.error("cannot close the server socket: " + e.getMessage(), new Object[]{e});
        }
        if (this.debug) {
            this.debug("receiver //" + this.hostname + ":" + this.port + " finished", new Object[0]);
        }
    }

    public void poll() {
        try {
            if (this.key.selector().select() > 0) {
                Set<SelectionKey> readyKeys = this.selector.selectedKeys();
                Iterator<SelectionKey> i = readyKeys.iterator();
                while (i.hasNext()) {
                    SelectionKey akey = i.next();
                    i.remove();
                    if (akey.isAcceptable()) {
                        ServerSocketChannel ssocket = (ServerSocketChannel)akey.channel();
                        SocketChannel socket = ssocket.accept();
                        if (this.debug) {
                            this.debug("accepting socket %s:%d", socket.socket().getInetAddress(), socket.socket().getPort());
                        }
                        socket.configureBlocking(false);
                        socket.finishConnect();
                        socket.register(this.selector, 1);
                        continue;
                    }
                    if (akey.isReadable()) {
                        this.readDataChunk(akey);
                        continue;
                    }
                    if (!akey.isWritable()) continue;
                    throw new RuntimeException("should not happen");
                }
            }
        }
        catch (IOException e) {
            this.error(e, "I/O error in receiver //%s:%d thread: aborting: %s", this.hostname, this.port, e.getMessage());
            this.loop = false;
        }
        catch (Throwable e) {
            this.error(e, "Unknown error: %s", e.getMessage());
            this.loop = false;
        }
    }

    protected void readDataChunk(SelectionKey key) throws IOException {
        IncomingBuffer buf = this.incoming.get(key);
        if (buf == null) {
            buf = new IncomingBuffer();
            this.incoming.put(key, buf);
            SocketChannel socket = (SocketChannel)key.channel();
            if (this.debug) {
                this.debug("creating buffer for new connection from %s:%d", socket.socket().getInetAddress(), socket.socket().getPort());
            }
        }
        try {
            buf.readDataChunk(key);
        }
        catch (IOException e) {
            this.incoming.remove(key);
            e.printStackTrace();
            this.error(e, "receiver //%s:%d cannot read object socket channel (I/O error): %s", this.hostname, this.port, e.getMessage());
            this.loop = false;
        }
        if (!buf.active) {
            this.incoming.remove(key);
            if (this.debug) {
                this.debug("removing buffer %s from incoming for geting inactive. %d left", key.toString(), this.incoming.size());
            }
        }
    }

    protected void error(String message, Object ... data) {
        this.error(null, message, data);
    }

    protected void error(Throwable e, String message, Object ... data) {
        System.err.print("[");
        System.err.printf(message, data);
        System.err.printf("]%n", new Object[0]);
        if (e != null) {
            e.printStackTrace();
        }
    }

    protected void debug(String message, Object ... data) {
        System.err.printf("[//%s:%d | ", this.hostname, this.port);
        System.err.printf(message, data);
        System.err.printf("]%n", new Object[0]);
    }

    @Override
    public ThreadProxyPipe getStream(String name) {
        return this.decoder.getStream(name);
    }

    @Override
    public ThreadProxyPipe getDefaultStream() {
        return this.decoder.getDefaultStream();
    }

    @Override
    public void register(String name, ThreadProxyPipe stream) throws Exception {
        this.decoder.register(name, stream);
    }

    @Override
    public void decodeMessage(InputStream in) throws IOException {
        this.decoder.decodeMessage(in);
    }

    class DefaultUnpacker
    extends NetStreamUnpacker {
        DefaultUnpacker() {
        }

        @Override
        public ByteBuffer unpackMessage(ByteBuffer buffer, int startIndex, int endIndex) {
            return buffer;
        }

        @Override
        public int unpackMessageSize(ByteBuffer buffer) {
            return buffer.getInt();
        }

        @Override
        public int sizeOfInt() {
            return 4;
        }
    }

    protected class IncomingBuffer {
        protected static final int BUFFER_INITIAL_SIZE = 8192;
        protected ByteBuffer buf = ByteBuffer.allocate(8192);
        protected int end = -1;
        protected int beg = 0;
        protected int pos = 0;
        PositionableByteArrayInputStream in;
        PositionableByteArrayInputStream bin;
        protected boolean active = true;

        public void readDataChunk(SelectionKey key) throws IOException {
            int limit = 0;
            int nbytes = 0;
            SocketChannel socket = (SocketChannel)key.channel();
            int sizeOfInt = NetStreamReceiver.this.unpacker.sizeOfInt();
            nbytes = this.bufferize(this.pos, socket);
            limit = this.pos + nbytes;
            if (nbytes <= 0) {
                return;
            }
            if (NetStreamReceiver.this.debug) {
                NetStreamReceiver.this.debug("<chunk (%d bytes) from " + socket.socket().getInetAddress() + ":" + socket.socket().getPort() + ">", nbytes);
                int at = this.buf.position();
                int i = 0;
                while (i < nbytes) {
                    System.err.printf("%d ", this.buf.get(at + i));
                    ++i;
                }
                System.err.println();
                this.buf.position(at);
            }
            if (this.end < 0) {
                if (limit - this.beg >= sizeOfInt) {
                    this.buf.position(0);
                    int size = NetStreamReceiver.this.unpacker.unpackMessageSize(this.buf);
                    this.end = size + sizeOfInt;
                    this.beg = sizeOfInt;
                    if (NetStreamReceiver.this.debug) {
                        NetStreamReceiver.this.debug("start to bufferize a %d byte long messsage", size);
                    }
                } else {
                    this.pos = limit;
                }
            }
            if (this.end > 0) {
                while (this.end < limit) {
                    ByteBuffer unpackedBuffer = NetStreamReceiver.this.unpacker.unpackMessage(this.buf, this.beg, this.end);
                    this.in = unpackedBuffer == this.buf ? new PositionableByteArrayInputStream(this.buf.array(), this.beg, this.end - this.beg) : new PositionableByteArrayInputStream(unpackedBuffer.array(), 0, unpackedBuffer.capacity());
                    NetStreamReceiver.this.decoder.decodeMessage((InputStream)this.in);
                    this.buf.position(this.end);
                    if (this.end + sizeOfInt <= limit) {
                        this.beg = this.end + sizeOfInt;
                        this.end = this.end + NetStreamReceiver.this.unpacker.unpackMessageSize(this.buf) + sizeOfInt;
                        continue;
                    }
                    assert (this.beg >= sizeOfInt);
                    this.beg = this.end;
                    int p = sizeOfInt - (this.end + sizeOfInt - limit);
                    this.compactBuffer();
                    this.pos = p;
                    this.beg = 0;
                    this.end = -1;
                    break;
                }
                if (this.end == limit) {
                    ByteBuffer unpackedBuffer = NetStreamReceiver.this.unpacker.unpackMessage(this.buf, this.beg, this.end);
                    this.in = unpackedBuffer == this.buf ? new PositionableByteArrayInputStream(this.buf.array(), this.beg, this.end - this.beg) : new PositionableByteArrayInputStream(unpackedBuffer.array(), 0, unpackedBuffer.capacity());
                    NetStreamReceiver.this.decoder.decodeMessage((InputStream)this.in);
                    this.buf.clear();
                    this.pos = 0;
                    this.beg = 0;
                    this.end = -1;
                } else if (this.end > limit) {
                    this.pos = limit;
                    if (this.end > this.buf.capacity()) {
                        this.compactBuffer();
                    }
                }
            }
        }

        protected int bufferize(int at, SocketChannel socket) throws IOException {
            int nbytes = 0;
            try {
                this.buf.position(at);
                nbytes = socket.read(this.buf);
                if (nbytes < 0) {
                    this.active = false;
                    if (this.in != null) {
                        this.in.close();
                    }
                    socket.close();
                    if (NetStreamReceiver.this.debug) {
                        NetStreamReceiver.this.debug("socket from %s:%d closed", socket.socket().getInetAddress(), socket.socket().getPort());
                    }
                    return nbytes;
                }
                if (nbytes == 0) {
                    throw new RuntimeException("should not happen: buffer to small, 0 bytes read: compact does not function? messages is larger than " + this.buf.capacity() + "?");
                }
                this.buf.position(at);
                return nbytes;
            }
            catch (IOException e) {
                if (NetStreamReceiver.this.debug) {
                    NetStreamReceiver.this.debug("socket from %s:%d I/O error: %s", socket.socket().getInetAddress(), socket.socket().getPort(), e.getMessage());
                }
                this.active = false;
                if (this.in != null) {
                    this.in.close();
                }
                socket.close();
                throw e;
            }
        }

        protected int compactBuffer() {
            if (this.beg > NetStreamReceiver.this.unpacker.sizeOfInt()) {
                int off = this.beg;
                this.buf.position(this.beg);
                this.buf.limit(this.buf.capacity());
                this.buf.compact();
                this.pos -= this.beg;
                this.end -= this.beg;
                this.beg = 0;
                return off;
            }
            return 0;
        }

        protected void enlargeBuffer() {
            ByteBuffer tmp = ByteBuffer.allocate(this.buf.capacity() * 2);
            this.buf.position(0);
            this.buf.limit(this.buf.capacity());
            tmp.put(this.buf);
            tmp.position(this.pos);
            this.buf = tmp;
            if (this.bin != null) {
                this.bin.changeBuffer(this.buf.array());
            }
        }
    }
}

