encapsulated package VisualXMLTpl
"
  file:        VisualXMLTpl.mo
  package:     VisualXMLTpl
  description: Generated by Susan.
"

public import Tpl;

public import Util;
public import VisualXML;
public import ExpressionDump;
public import DAE;
public import Absyn;

public function dumpVisXML
  input Tpl.Text txt;
  input array<VisualXML.Visualization> a_vis;
  input String a_fileName;

  output Tpl.Text out_txt;
protected
  Tpl.Text txt_0;
algorithm
  txt_0 := dumpVisXML1(Tpl.emptyTxt, a_vis);
  Tpl.textFile(txt_0, a_fileName);
  out_txt := txt;
end dumpVisXML;

protected function lm_8
  input Tpl.Text in_txt;
  input list<VisualXML.Visualization> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<VisualXML.Visualization> rest;
      VisualXML.Visualization i_vis;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_vis :: rest )
      equation
        txt = dumpVisualization(txt, i_vis);
        txt = Tpl.nextIter(txt);
        txt = lm_8(txt, rest);
      then txt;
  end match;
end lm_8;

public function dumpVisXML1
  input Tpl.Text txt;
  input array<VisualXML.Visualization> a_visArr;

  output Tpl.Text out_txt;
protected
  list<VisualXML.Visualization> ret_1;
  Tpl.Text l_visDump;
algorithm
  ret_1 := arrayList(a_visArr);
  l_visDump := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_visDump := lm_8(l_visDump, ret_1);
  l_visDump := Tpl.popIter(l_visDump);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n",
                                   "<visualization>\n"
                               }, true));
  out_txt := Tpl.writeText(out_txt, l_visDump);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("</visualization>"));
end dumpVisXML1;

protected function lm_10
  input Tpl.Text in_txt;
  input list<list<DAE.Exp>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<DAE.Exp>> rest;
      list<DAE.Exp> i_T0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_T0 :: rest )
      equation
        txt = dumpVecExp(txt, i_T0);
        txt = Tpl.nextIter(txt);
        txt = lm_10(txt, rest);
      then txt;
  end match;
end lm_10;

public function dumpVisualization
  input Tpl.Text in_txt;
  input VisualXML.Visualization in_a_vis;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vis)
    local
      Tpl.Text txt;
      DAE.Exp i_specularCoeff;
      DAE.Exp i_extra;
      DAE.Exp i_height;
      DAE.Exp i_width;
      DAE.Exp i_length;
      String i_shapeType;
      String i_ident;
      array<DAE.Exp> i_color;
      array<DAE.Exp> i_widthDir;
      array<DAE.Exp> i_lengthDir;
      array<DAE.Exp> i_r__shape;
      array<DAE.Exp> i_r;
      array<list<DAE.Exp>> i_T;
      list<DAE.Exp> ret_11;
      Tpl.Text l_colorDump;
      list<DAE.Exp> ret_9;
      Tpl.Text l_wDirDump;
      list<DAE.Exp> ret_7;
      Tpl.Text l_lDirDump;
      list<DAE.Exp> ret_5;
      Tpl.Text l_r__shapeDump;
      list<DAE.Exp> ret_3;
      Tpl.Text l_rDump;
      list<list<DAE.Exp>> ret_1;
      Tpl.Text l_TDump;

    case ( txt,
           VisualXML.SHAPE(T = i_T, r = i_r, r_shape = i_r__shape, lengthDir = i_lengthDir, widthDir = i_widthDir, color = i_color, ident = i_ident, shapeType = i_shapeType, length = i_length, width = i_width, height = i_height, extra = i_extra, specularCoeff = i_specularCoeff) )
      equation
        ret_1 = arrayList(i_T);
        l_TDump = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_TDump = lm_10(l_TDump, ret_1);
        l_TDump = Tpl.popIter(l_TDump);
        ret_3 = arrayList(i_r);
        l_rDump = dumpVecExp(Tpl.emptyTxt, ret_3);
        ret_5 = arrayList(i_r__shape);
        l_r__shapeDump = dumpVecExp(Tpl.emptyTxt, ret_5);
        ret_7 = arrayList(i_lengthDir);
        l_lDirDump = dumpVecExp(Tpl.emptyTxt, ret_7);
        ret_9 = arrayList(i_widthDir);
        l_wDirDump = dumpVecExp(Tpl.emptyTxt, ret_9);
        ret_11 = arrayList(i_color);
        l_colorDump = dumpVecExp(Tpl.emptyTxt, ret_11);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  <shape>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<ident>"));
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</ident>\n",
                                    "<type>"
                                }, false));
        txt = Tpl.writeStr(txt, i_shapeType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</type>\n",
                                    "<T>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_TDump);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</T>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<r>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_rDump);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</r>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<r_shape>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_r__shapeDump);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</r_shape>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<lengthDir>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, l_lDirDump);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</lengthDir>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<widthDir>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_wDirDump);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</widthDir>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<length>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = dumpExp(txt, i_length);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</length>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<width>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = dumpExp(txt, i_width);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</width>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<height>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = dumpExp(txt, i_height);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</height>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<extra>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = dumpExp(txt, i_extra);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</extra>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<color>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_colorDump);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</color>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<specCoeff>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = dumpExp(txt, i_specularCoeff);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</specCoeff>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  </shape>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVisualization;

protected function lm_12
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_vec;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_vec :: rest )
      equation
        txt = dumpExp(txt, i_vec);
        txt = Tpl.nextIter(txt);
        txt = lm_12(txt, rest);
      then txt;
  end match;
end lm_12;

public function dumpVecExp
  input Tpl.Text txt;
  input list<DAE.Exp> a_vector;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_vecDump;
algorithm
  l_vecDump := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_vecDump := lm_12(l_vecDump, a_vector);
  l_vecDump := Tpl.popIter(l_vecDump);
  out_txt := Tpl.writeText(txt, l_vecDump);
end dumpVecExp;

protected function lm_14
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpExp(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_14(txt, rest);
      then txt;
  end match;
end lm_14;

public function dumpExp
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      Absyn.Path i_path;
      list<DAE.Exp> i_expLst;
      DAE.Exp i_expElse;
      DAE.Exp i_expThen;
      DAE.Exp i_expCond;
      DAE.Exp i_exp;
      DAE.Exp i_exp2;
      DAE.Operator i_operator;
      DAE.Exp i_exp1;
      DAE.Exp i_CREF;
      String ret_3;
      String ret_2;
      Tpl.Text l_elist;
      String ret_0;

    case ( txt,
           (i_CREF as DAE.CREF(componentRef = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<cref>"));
        ret_0 = ExpressionDump.printExpStr(i_CREF);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</cref>"));
      then txt;

    case ( txt,
           DAE.BINARY(exp1 = i_exp1, operator = i_operator, exp2 = i_exp2) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<binary>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = dumpExp(txt, i_exp1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<op>"));
        txt = dumpOperator(txt, i_operator);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</op>\n"));
        txt = dumpExp(txt, i_exp2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</binary>"));
      then txt;

    case ( txt,
           (i_exp as DAE.UNARY(operator = i_operator)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<unary>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<op>"));
        txt = dumpOperator(txt, i_operator);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</op>\n",
                                    "<exp>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = dumpExp(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</exp>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</unary>"));
      then txt;

    case ( txt,
           DAE.LBINARY(exp1 = i_exp1, operator = i_operator, exp2 = i_exp2) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<lbinary>\n",
                                    "    <exp>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = dumpExp(txt, i_exp1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</exp>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<op>"));
        txt = dumpOperator(txt, i_operator);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</op>\n",
                                    "<exp>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = dumpExp(txt, i_exp2);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</exp>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</lbinary>"));
      then txt;

    case ( txt,
           (i_exp as DAE.LUNARY(operator = i_operator)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<lunary>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<op>"));
        txt = dumpOperator(txt, i_operator);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</op>\n",
                                    "<exp>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = dumpExp(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</exp>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</lunary>"));
      then txt;

    case ( txt,
           DAE.RELATION(exp1 = i_exp1, operator = i_operator, exp2 = i_exp2) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<relation>\n",
                                    "    <exp1>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = dumpExp(txt, i_exp1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</exp1>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<op>"));
        txt = dumpOperator(txt, i_operator);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</op>\n",
                                    "<exp2>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = dumpExp(txt, i_exp2);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</exp2>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</relation>"));
      then txt;

    case ( txt,
           DAE.IFEXP(expCond = i_expCond, expThen = i_expThen, expElse = i_expElse) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<ifexp>\n",
                                    "    <cond>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = dumpExp(txt, i_expCond);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</cond>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("    <then>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = dumpExp(txt, i_expThen);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</then>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("    <else>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = dumpExp(txt, i_expElse);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</else>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</ifexp>"));
      then txt;

    case ( txt,
           DAE.CALL(expLst = i_expLst, path = i_path) )
      equation
        l_elist = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_elist = lm_14(l_elist, i_expLst);
        l_elist = Tpl.popIter(l_elist);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<call>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<path>"));
        ret_2 = Absyn.pathString(i_path);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</path>\n",
                                    "<expLst>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_elist);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</expLst>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</call>"));
      then txt;

    case ( txt,
           i_exp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp>"));
        ret_3 = ExpressionDump.printExpStr(i_exp);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp>"));
      then txt;
  end match;
end dumpExp;

public function dumpOperator
  input Tpl.Text in_txt;
  input DAE.Operator in_a_op;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_op)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ADD(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("add"));
      then txt;

    case ( txt,
           DAE.SUB(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("sub"));
      then txt;

    case ( txt,
           DAE.MUL(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mul"));
      then txt;

    case ( txt,
           DAE.DIV(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("div"));
      then txt;

    case ( txt,
           DAE.POW(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pow"));
      then txt;

    case ( txt,
           DAE.UMINUS(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("uminus"));
      then txt;

    case ( txt,
           DAE.UMINUS_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("uminus_arr"));
      then txt;

    case ( txt,
           DAE.ADD_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("add_arr"));
      then txt;

    case ( txt,
           DAE.SUB_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("sub_arr"));
      then txt;

    case ( txt,
           DAE.MUL_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mul_arr"));
      then txt;

    case ( txt,
           DAE.DIV_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("siv_arr"));
      then txt;

    case ( txt,
           DAE.MUL_ARRAY_SCALAR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mul_array_scalar"));
      then txt;

    case ( txt,
           DAE.ADD_ARRAY_SCALAR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("add_array_scalar"));
      then txt;

    case ( txt,
           DAE.SUB_SCALAR_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("sub_scalar_array"));
      then txt;

    case ( txt,
           DAE.MUL_SCALAR_PRODUCT(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mul_scalar_product"));
      then txt;

    case ( txt,
           DAE.MUL_MATRIX_PRODUCT(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mul_matrix_product"));
      then txt;

    case ( txt,
           DAE.DIV_ARRAY_SCALAR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("div_array_scalar"));
      then txt;

    case ( txt,
           DAE.DIV_SCALAR_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("siv_scalar_array"));
      then txt;

    case ( txt,
           DAE.POW_ARRAY_SCALAR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pow_array_scalar"));
      then txt;

    case ( txt,
           DAE.POW_SCALAR_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pow_scalar_array"));
      then txt;

    case ( txt,
           DAE.POW_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pow_arr"));
      then txt;

    case ( txt,
           DAE.POW_ARR2(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("por_arr2"));
      then txt;

    case ( txt,
           DAE.AND(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("and"));
      then txt;

    case ( txt,
           DAE.OR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("or"));
      then txt;

    case ( txt,
           DAE.NOT(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("not"));
      then txt;

    case ( txt,
           DAE.LESS(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("less"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("lesseq"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("greater"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("greatereq"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equal"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("nequal"));
      then txt;

    case ( txt,
           DAE.USERDEFINED(fqName = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("userdefined"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-unknown operator-"));
      then txt;
  end match;
end dumpOperator;

annotation(__OpenModelica_Interface="backend");
end VisualXMLTpl;