/*
 * This file is part of OpenModelica.
 *
 * Copyright (c) 1998-CurrentYear, Linkoping University,
 * Department of Computer and Information Science,
 * SE-58183 Linkoping, Sweden.
 *
 * All rights reserved.
 *
 * THIS PROGRAM IS PROVIDED UNDER THE TERMS OF GPL VERSION 3
 * AND THIS OSMC PUBLIC LICENSE (OSMC-PL).
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS PROGRAM CONSTITUTES RECIPIENT'S
 * ACCEPTANCE OF THE OSMC PUBLIC LICENSE.
 *
 * The OpenModelica software and the Open Source Modelica
 * Consortium (OSMC) Public License (OSMC-PL) are obtained
 * from Linkoping University, either from the above address,
 * from the URLs: http://www.ida.liu.se/projects/OpenModelica or
 * http://www.openmodelica.org, and in the OpenModelica distribution.
 * GNU version 3 is obtained from: http://www.gnu.org/copyleft/gpl.html.
 *
 * This program is distributed WITHOUT ANY WARRANTY; without
 * even the implied warranty of  MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE, EXCEPT AS EXPRESSLY SET FORTH
 * IN THE BY RECIPIENT SELECTED SUBSIDIARY LICENSE CONDITIONS
 * OF OSMC-PL.
 *
 * See the full OSMC Public License conditions for more details.
 *
 * Main Author 2011: Adeel Asghar
 *
 */

#include "VisualizeWindowContainer.h"

using namespace OMVisualize;

VisualizeWindowContainer::VisualizeWindowContainer(VisualizeMainWindow *pParent)
  : QMdiArea(pParent)
{
  mpVisualizeMainWindow = pParent;
  setActivationOrder(QMdiArea::CreationOrder);
  setHorizontalScrollBarPolicy(Qt::ScrollBarAsNeeded);
  setVerticalScrollBarPolicy(Qt::ScrollBarAsNeeded);
  setViewMode(QMdiArea::TabbedView);
}

VisualizeMainWindow* VisualizeWindowContainer::getVisualizeMainWindow()
{
  return mpVisualizeMainWindow;
}

QString VisualizeWindowContainer::getUniqueName(QString name, int number)
{
  QString newName;
  newName = name + QString::number(number);

  foreach (QMdiSubWindow *pWindow, subWindowList())
  {
    VisualizeWindow *pVisualizeWindow = qobject_cast<VisualizeWindow*>(pWindow->widget());
    if (pVisualizeWindow->windowTitle().compare(newName) == 0)
    {
      newName = getUniqueName(name, ++number);
      break;
    }
  }
  return newName;
}

VisualizeWindow* VisualizeWindowContainer::getCurrentWindow()
{
  if (subWindowList(QMdiArea::ActivationHistoryOrder).size() == 0)
    return 0;
  else
    return qobject_cast<VisualizeWindow*>(subWindowList(QMdiArea::ActivationHistoryOrder).last()->widget());
}

void VisualizeWindowContainer::addVisualizeWindow(QStringList arguments)
{
  VisualizeWindow *pVisualizeWindow = new VisualizeWindow(arguments, this);
  pVisualizeWindow->setWindowTitle(getUniqueName());
  connect(pVisualizeWindow, SIGNAL(closingDown()), SLOT(checkSubWindows()));
  setActiveSubWindow(addSubWindow(pVisualizeWindow));
  if (viewMode() == QMdiArea::TabbedView)
    pVisualizeWindow->showMaximized();
  else
    pVisualizeWindow->show();
  getVisualizeMainWindow()->activateWindow();
}

void VisualizeWindowContainer::updateCurrentWindow(QStringList arguments)
{
    VisualizeWindow *tempVisualizeWindow = getCurrentWindow();
    VisualizeWindow *pVisualizeWindow = new VisualizeWindow(arguments, this);
    pVisualizeWindow->setWindowTitle(getCurrentWindow()->windowTitle());
    connect(pVisualizeWindow, SIGNAL(closingDown()), SLOT(checkSubWindows()));
    setActiveSubWindow(addSubWindow(pVisualizeWindow));
    tempVisualizeWindow->nativeParentWidget()->close();
    if (viewMode() == QMdiArea::TabbedView)
      pVisualizeWindow->showMaximized();
    else
    {
        pVisualizeWindow->show();
    }
    getVisualizeMainWindow()->activateWindow();
}

void VisualizeWindowContainer::checkSubWindows()
{
  if (subWindowList().size() < 2)
    getVisualizeMainWindow()->close();
}
