/*
<queenEval.h>
Copyright (C) DOLPHIN Project-Team, INRIA Lille - Nord Europe, 2006-2010

Sébastien Verel, Arnaud Liefooghe, Jérémie Humeau

This software is governed by the CeCILL license under French law and
abiding by the rules of distribution of free software.  You can  ue,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.
The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

ParadisEO WebSite : http://paradiseo.gforge.inria.fr
Contact: paradiseo-help@lists.gforge.inria.fr
*/

#ifndef _queenEval_h
#define _queenEval_h

#include <eoEvalFunc.h>

/**
 * Full evaluation function for QUEEN problem
 */
template< class EOT >
class queenEval : public eoEvalFunc<EOT>
{
public:

	/**
	 * Count number of threat
	 * @param _queen a solution
	 */
    void operator()(EOT& _queen){
    	  unsigned int fit=0;
    	  for(unsigned int i=0; i<_queen.size()-1; i++)
    		  for(unsigned int j=i+1; j< _queen.size(); j++)
    			  if(((unsigned int)_queen[i]+j-i == (unsigned int)_queen[j]) || ((unsigned int)_queen[i]+i-j == (unsigned int)_queen[j]))
    				  fit++;
    	  _queen.fitness(fit);
    }
};

#endif
