within QCalc.UsersGuide;
class GettingStarted "Getting started"
  extends Icons.Information;
  annotation (preferredView="info", Documentation(info="<html>
  <p>There are some points to note besides those in the \"Usage\"
  section of the <a href=\"modelica://QCalc\">top-level documentation</a>:</p>
    <ol>
        <li>Turn off unit checking in Dymola:
        <pre>
    Advanced.CheckUnits = false;</pre>
        This is automatic if
        <a href=\"modelica://QCalc\">QCalc</a> is loaded via
        <a href=\"modelica://QCalc/../load.mos\">load.mos</a>.</li>

        <li>Call <a href=\"modelica://QCalc.Units.setup\">QCalc.Units.setup</a>() to
        establish the display units in Dymola.  This is automatic if
        <a href=\"modelica://QCalc\">QCalc</a> is loaded via
        <a href=\"modelica://QCalc/../load.mos\">load.mos</a>.</li>

<li>Note that angle is explicit in the definitions of quantities,
        units, and constants. This helps to identify dimensional inconsistencies
        and provide insight into the physical equations.
        Sometimes it is necessary to include factors
        of <code>U.rad</code>, <code>U.cyc</code>, etc. (where <code>U</code> is
        <a href=\"modelica://QCalc.Units\">QCalc.Units</a>), but usually
        those units cancel.  See <a href=\"modelica://QCalc.Units\">QCalc.Units</a>
        for details on where this is important.</li>

        <li>The global variable <code>time</code> is in seconds.  It is not a
        quantity, so it must be multiplied by the
        <a href=\"https://en.wikipedia.org/wiki/Second\">unit second</a>
        (<code>U.s</code>) when used with other quantities.
        When writing a derivative, it is important to divide the result of
        the <code>der</code> operator by the
        <a href=\"https://en.wikipedia.org/wiki/Second\">unit second</a>: <code>der(x)/U.s</code>.
        By default, the <a href=\"https://en.wikipedia.org/wiki/Second\">second</a>
        has a value of one, but this will not be the case if the base constants
        are changed.</li>

        <li>When using results based on <a href=\"modelica://QCalc\">QCalc</a>
        in an external tool, note that the values
        of the <a href=\"https://en.wikipedia.org/wiki/International_System_of_Units\">SI</a>
        base and coherently derived units are not necessarily one.  The values
        can be loaded from the \"units.mos\" file that is automatically
        generated by <a href=\"modelica://QCalc/../load.mos\">load.mos</a>
        in the working directory.</li>

        <li>If you wish to introduce new quantities, it may help to use
        the <a href=\"modelica://QCalc/Resources/quantities.xlsx\">quantities.xlsx</a> spreadsheet.</li>

        <li>There are more details about the implementation in
        <a href=\"modelica://QCalc.Units\">QCalc.Units</a>.</li>
    </ol>
    </html>"));
end GettingStarted;
