within ModPowerSystems.Base.Interfaces.RealValue.SinglePhase;
partial model OnePort
  "Shell model for models with two electrical three-phase connectors"

  ModPowerSystems.Base.Interfaces.RealValue.SinglePhase.Pin Pin1
    annotation (Placement(transformation(extent={{-110,-10},{-90,10}})));
  ModPowerSystems.Base.Interfaces.RealValue.SinglePhase.Pin Pin2
    annotation (Placement(transformation(extent={{90,-10},{110,10}})));

  // port voltage and current
  SI.Voltage v "Voltage between Pin1 and Pin2";
  SI.Current i "Current flowing from Pin1 to Pin2";

  // port potentials
  SI.Voltage v1;
  SI.Voltage v2;

equation
  v = v1 - v2;
  v1 = Pin1.v;
  v2 = Pin2.v;
  i = Pin1.i;
  i = -Pin2.i;
  annotation (
    Icon(
      coordinateSystem(
        preserveAspectRatio=false,
        extent={{-100,-100},{100,100}}),
        graphics={Text(
          extent={{74,24},{94,4}},
          lineColor={0,0,0},
          textString="+")}),
    Documentation(info="<html>
      <p>The model represents a one port with the following definitions:</p>
      <p><img src=\"modelica://ModPowerSystems/Resources/Images/OnePort.png\"/></p>
      <p>Note, that a one port must meet the port condition: input and output current must be equal.</p>
      </html>"));
end OnePort;
