within ModPowerSystems.EmtThreePhase.Basics;
model Inductor
  extends ModPowerSystems.Base.Interfaces.RealValue.ThreePhase.OnePort;

  parameter SI.Inductance L[3] = {1e-3, 1e-3, 1e-3};
  parameter SI.Current i_0[3] = {0, 0, 0};

initial equation
  i[:] = i_0[:];

equation
    v[:] = L[:].*der(i[:]);
  annotation (Icon(graphics={
        Line(points={{-40,0},{-98,0}},
                                     color={0,0,0}),
        Line(points={{8,58}}, color={0,0,0}),
        Line(points={{96,0},{38,0}}, color={0,0,0}),
        Rectangle(
          extent={{-40,20},{40,-20}},
          lineColor={0,0,0},
          fillColor={0,0,0},
          fillPattern=FillPattern.Solid)}));
end Inductor;
