within Soltermica.ThermoFluidSystems.HeatExchangers;

model PlateEffectiveness
  extends Soltermica.BaseClasses.Icons.NameIcon;
  Modelica.Thermal.FluidHeatFlow.Interfaces.FlowPort_b flowPort_b_1(final medium = medium1) annotation(
    Placement(visible = true, transformation(origin = {-100, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {-100, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Thermal.FluidHeatFlow.Interfaces.FlowPort_a flowPort_a_2(final medium = medium2) annotation(
    Placement(visible = true, transformation(origin = {100, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {100, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Thermal.FluidHeatFlow.Interfaces.FlowPort_b flowPort_b_2(final medium = medium2) annotation(
    Placement(visible = true, transformation(origin = {100, 80}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {100, 80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Thermal.FluidHeatFlow.Interfaces.FlowPort_a flowPort_a_1(final medium = medium1) annotation(
    Placement(visible = true, transformation(origin = {-100, 80}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {-100, 80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));

  Soltermica.BaseClasses.ControlVolumes.Cuboid cuboid1(
  length=specs.S_int/specs.L_int,
  height=specs.L_int,
  width=specs.V_1/specs.S_int,
  V_flowNominal=specs.V_flow_nom_1,
  dpNominal= specs.dp_nom_1,
  medium = medium1)
    annotation(
    Placement(visible = true, transformation(origin = {-70, 0}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Soltermica.BaseClasses.ControlVolumes.Cuboid cuboid2(
    length=specs.S_int/specs.L_int,
    height=specs.L_int,
    width=specs.V_2/specs.S_int,
    V_flowNominal=specs.V_flow_nom_2,
    dpNominal= specs.dp_nom_2,
    medium = medium2)
    annotation(
    Placement(visible = true, transformation(origin = {70, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  Soltermica.ThermoFluidSystems.HeatExchangers.BaseClasses.ExchangedHeatEffectiveness exchangedHeatEffectiveness(
  medium1=medium1,
  medium2=medium2,
  heatExchangeArea=specs.S_int,
  U=specs.U_int,
  fixedEffectiveness=fixedEffectiveness,
  heatExchangeEffectivenessFixed=heatExchangeEffectivenessFixed)
  annotation(
    Placement(visible = true, transformation(origin = {0, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Thermal.FluidHeatFlow.Sensors.TemperatureSensor temperatureSensor1(
    medium=medium1)
    annotation(
    Placement(visible = true, transformation(origin = {-50, 80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Thermal.FluidHeatFlow.Sensors.TemperatureSensor temperatureSensor2(
    medium=medium2)
    annotation(
    Placement(visible = true, transformation(origin = {50, -80}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Thermal.FluidHeatFlow.Sensors.MassFlowSensor massFlowSensor1(
    medium=medium1)
    annotation(
    Placement(visible = true, transformation(origin = {-70, 50}, extent = {{-10, 10}, {10, -10}}, rotation = -90)));
  Modelica.Thermal.FluidHeatFlow.Sensors.MassFlowSensor massFlowSensor2(
    medium=medium2)
    annotation(
    Placement(visible = true, transformation(origin = {70, -50}, extent = {{-10, 10}, {10, -10}}, rotation = 90)));

  //Model parameters
  parameter Modelica.Thermal.FluidHeatFlow.Media.Medium medium1 = Modelica.Thermal.FluidHeatFlow.Media.Medium();
  parameter Modelica.Thermal.FluidHeatFlow.Media.Medium medium2 = Modelica.Thermal.FluidHeatFlow.Media.Medium();
  parameter Soltermica.ThermoFluidSystems.HeatExchangers.Catalogue.TechnicalSpecifications specs = Soltermica.ThermoFluidSystems.HeatExchangers.Catalogue.TechnicalSpecifications();
  parameter Boolean fixedEffectiveness=true;
  parameter Real heatExchangeEffectivenessFixed(start=0.6) if fixedEffectiveness;
  parameter Modelica.SIunits.Temperature T0(start = 293.15);
equation
  connect(massFlowSensor1.flowPort_b, cuboid1.flowPort_a) annotation(
    Line(points = {{-70, 40}, {-70, 10}}, color = {255, 0, 0}));
  connect(cuboid1.innerPort, exchangedHeatEffectiveness.port_a1) annotation(
    Line(points = {{-60, 0}, {-10, 0}}, color = {191, 0, 0}));
  connect(flowPort_b_1, cuboid1.flowPort_b) annotation(
    Line(points = {{-100, -80}, {-70, -80}, {-70, -10}}, color = {255, 0, 0}));
  connect(massFlowSensor2.y, exchangedHeatEffectiveness.massFlow2) annotation(
    Line(points = {{58, -50}, {36, -50}, {36, -6}, {10, -6}, {10, -4}}, color = {0, 0, 127}));
  connect(massFlowSensor2.flowPort_b, cuboid2.flowPort_a) annotation(
    Line(points = {{70, -40}, {70, -40}, {70, -10}, {70, -10}}, color = {255, 0, 0}));
  connect(flowPort_a_2, massFlowSensor2.flowPort_a) annotation(
    Line(points = {{100, -80}, {70, -80}, {70, -60}, {70, -60}}, color = {255, 0, 0}));
  connect(massFlowSensor1.y, exchangedHeatEffectiveness.massFlow1) annotation(
    Line(points = {{-58, 50}, {-36, 50}, {-36, -6}, {-10, -6}, {-10, -4}}, color = {0, 0, 127}));
  connect(flowPort_a_1, massFlowSensor1.flowPort_a) annotation(
    Line(points = {{-100, 80}, {-70, 80}, {-70, 60}, {-70, 60}}, color = {255, 0, 0}));
  connect(temperatureSensor1.y, exchangedHeatEffectiveness.temperatureIn1) annotation(
    Line(points = {{-38, 80}, {-30, 80}, {-30, 4}, {-10, 4}, {-10, 6}}, color = {0, 0, 127}));
  connect(flowPort_a_1, temperatureSensor1.flowPort) annotation(
    Line(points = {{-100, 80}, {-60, 80}}, color = {255, 0, 0}));
  connect(temperatureSensor2.y, exchangedHeatEffectiveness.temperatureIn2) annotation(
    Line(points = {{38, -80}, {30, -80}, {30, 4}, {10, 4}, {10, 6}}, color = {0, 0, 127}));
  connect(flowPort_a_2, temperatureSensor2.flowPort) annotation(
    Line(points = {{100, -80}, {60, -80}, {60, -80}, {60, -80}}, color = {255, 0, 0}));
  connect(exchangedHeatEffectiveness.port_a2, cuboid2.innerPort) annotation(
    Line(points = {{10, 0}, {60, 0}}, color = {191, 0, 0}));
  connect(cuboid2.flowPort_b, flowPort_b_2) annotation(
    Line(points = {{70, 10}, {70, 80}, {100, 80}}, color = {255, 0, 0}));
  annotation(
    Icon(graphics = {Rectangle(fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-40, 100}, {40, -100}}), Line(points = {{-40, 80}, {40, -80}}), Line(points = {{-40, -80}, {40, 80}}), Line(origin = {0, 60}, points = {{-38, 0}, {38, 0}}), Line(origin = {0, 20}, points = {{-38, 0}, {38, 0}}), Line(origin = {0, -20}, points = {{-38, 0}, {38, 0}}), Line(origin = {0, -60}, points = {{-38, 0}, {38, 0}}), Line(origin = {-70, 80}, points = {{-30, 0}, {30, 0}}), Line(origin = {70, 80}, points = {{-30, 0}, {30, 0}}), Line(origin = {-70, -80}, points = {{-30, 0}, {30, 0}}), Line(origin = {69, -80}, points = {{-29, 0}, {29, 0}})}, coordinateSystem(initialScale = 0.1)));
end PlateEffectiveness;
