/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.netstream;

import java.io.IOException;
import java.net.UnknownHostException;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.netstream.NetStreamReceiver;
import org.graphstream.stream.netstream.NetStreamSender;
import org.graphstream.stream.netstream.packing.Base64Packer;
import org.graphstream.stream.netstream.packing.Base64Unpacker;
import org.graphstream.stream.thread.ThreadProxyPipe;

public class ExampleWithViewer {
    public static void main(String[] args) throws UnknownHostException, IOException, InterruptedException {
        MultiGraph g = new MultiGraph("G");
        g.display();
        NetStreamReceiver net = new NetStreamReceiver(2001);
        net.setUnpacker(new Base64Unpacker());
        net.setDebugOn(false);
        ThreadProxyPipe pipe = net.getDefaultStream();
        pipe.addSink(g);
        new Thread(){

            @Override
            public void run() {
                MultiGraph g = new MultiGraph("G");
                NetStreamSender nsc = null;
                try {
                    nsc = new NetStreamSender(2001);
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                nsc.setPacker(new Base64Packer());
                g.addSink(nsc);
                String style = "node{fill-mode:plain;fill-color:#567;size:6px;}";
                g.addAttribute("stylesheet", style);
                g.addAttribute("ui.antialias", true);
                g.addAttribute("layout.stabilization-limit", 0);
                int i = 0;
                while (i < 5000) {
                    g.addNode(String.valueOf(i));
                    if (i > 0) {
                        g.addEdge(String.valueOf(i) + "-" + (i - 1), String.valueOf(i), String.valueOf(i - 1));
                        g.addEdge(String.valueOf(i) + "--" + i / 2, String.valueOf(i), String.valueOf(i / 2));
                    }
                    ++i;
                }
            }
        }.start();
        while (true) {
            pipe.pump();
            Thread.sleep(100L);
        }
    }
}

