/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.netstream;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.graphstream.stream.SinkAdapter;
import org.graphstream.stream.netstream.NetStreamReceiver;
import org.graphstream.stream.thread.ThreadProxyPipe;

public class ExampleTypesReceiver {
    public static void main(String[] args) throws InterruptedException {
        NetStreamReceiver net = null;
        try {
            net = new NetStreamReceiver("localhost", 2001, true);
        }
        catch (UnknownHostException e1) {
            System.err.println(e1.toString());
        }
        catch (IOException e1) {
            System.err.println(e1.toString());
        }
        ThreadProxyPipe pipe = net.getDefaultStream();
        pipe.addSink(new SinkAdapter(){

            @Override
            public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
                this.validate(attribute, value);
            }

            @Override
            public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
                this.validate(attribute, newValue);
            }

            private void validate(String attribute, Object value) {
                String valueType = null;
                Class<?> valueClass = value.getClass();
                boolean isArray = valueClass.isArray();
                if (isArray) {
                    valueClass = ((Object[])value)[0].getClass();
                }
                if (valueClass.equals(Boolean.class)) {
                    if (isArray) {
                        valueType = "booleanArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Boolean[])value)));
                    } else {
                        valueType = "boolean";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                } else if (valueClass.equals(Byte.class)) {
                    if (isArray) {
                        valueType = "byteArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Byte[])value)));
                    } else {
                        valueType = "byte";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                } else if (valueClass.equals(Short.class)) {
                    if (isArray) {
                        valueType = "shortArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Short[])value)));
                    } else {
                        valueType = "short";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                } else if (valueClass.equals(Integer.class)) {
                    if (isArray) {
                        valueType = "intArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Integer[])value)));
                    } else {
                        valueType = "int";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                } else if (valueClass.equals(Long.class)) {
                    if (isArray) {
                        valueType = "longArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Long[])value)));
                    } else {
                        valueType = "long";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                } else if (valueClass.equals(Float.class)) {
                    if (isArray) {
                        valueType = "floatArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Float[])value)));
                    } else {
                        valueType = "float";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                } else if (valueClass.equals(Double.class)) {
                    if (isArray) {
                        valueType = "doubleArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Double[])value)));
                    } else {
                        valueType = "double";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                } else if (valueClass.equals(String.class)) {
                    if (isArray) {
                        valueType = "typeArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Boolean[])value)));
                    } else {
                        valueType = "string";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                }
                System.err.println(valueType.equals(attribute));
            }
        });
        while (true) {
            pipe.pump();
            Thread.sleep(100L);
        }
    }
}

