/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.graphstream.graph.Graph;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.file.FileSink;
import org.graphstream.stream.file.FileSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class TestFileSinkBase {
    protected Graph outGraph;
    protected Graph inGraph;
    protected FileSource input;
    protected FileSink output;
    protected boolean formatHandlesEdgesIDs = true;
    protected boolean formatHandlesAttributes = true;
    protected boolean formatHandleDynamics = true;

    @Before
    public abstract void setup();

    protected abstract String aTemporaryGraphFileName();

    @Before
    public void setup2() {
        this.outGraph = new MultiGraph("out");
        this.inGraph = new MultiGraph("in");
    }

    @Test
    public void test_UndirectedTriangle_WriteAll_FileName() {
        this.createUndirectedTriangle();
        try {
            this.output.writeAll(this.outGraph, this.aTemporaryGraphFileName());
            this.input.addSink(this.inGraph);
            this.input.readAll(this.aTemporaryGraphFileName());
            this.removeFile(this.aTemporaryGraphFileName());
            this.testUndirectedTriangle();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((String)"Should not happen !", (boolean)false);
        }
    }

    @Test
    public void test_UndirectedTriangle_WriteAll_Stream() {
        this.createUndirectedTriangle();
        try {
            this.output.writeAll(this.outGraph, new FileOutputStream(this.aTemporaryGraphFileName()));
            this.input.addSink(this.inGraph);
            this.input.readAll(this.aTemporaryGraphFileName());
            this.removeFile(this.aTemporaryGraphFileName());
            this.testUndirectedTriangle();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((String)"Should not happen !", (boolean)false);
        }
    }

    @Test
    public void test_UndirectedTriangle_ByEvent() {
        try {
            this.output.begin(this.aTemporaryGraphFileName());
            this.output.nodeAdded("?", 1L, "A");
            this.output.nodeAdded("?", 2L, "B");
            this.output.nodeAdded("?", 3L, "C");
            this.output.edgeAdded("?", 4L, "AB", "A", "B", false);
            this.output.edgeAdded("?", 5L, "BC", "B", "C", false);
            this.output.edgeAdded("?", 6L, "CA", "C", "A", false);
            this.output.end();
            this.input.addSink(this.inGraph);
            this.input.readAll(this.aTemporaryGraphFileName());
            this.removeFile(this.aTemporaryGraphFileName());
            this.testUndirectedTriangle();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((String)"Should not happen !", (boolean)false);
        }
    }

    @Test
    public void test_DirectedTriangle() {
        this.createDirectedTriangle();
        try {
            this.output.writeAll(this.outGraph, new FileOutputStream(this.aTemporaryGraphFileName()));
            this.input.addSink(this.inGraph);
            this.input.readAll(this.aTemporaryGraphFileName());
            this.removeFile(this.aTemporaryGraphFileName());
            this.testDirectedTriangle();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((String)"Should not happen !", (boolean)false);
        }
    }

    @Test
    public void test_Attributes() {
        if (this.formatHandlesAttributes) {
            this.createAttributedTriangle();
            try {
                this.output.writeAll(this.outGraph, new FileOutputStream(this.aTemporaryGraphFileName()));
                this.input.addSink(this.inGraph);
                this.input.readAll(this.aTemporaryGraphFileName());
                this.testAttributedTriangle();
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)"Should not happen !");
            }
        }
    }

    @Test
    public void test_Dynamic() {
        if (this.formatHandleDynamics) {
            try {
                this.output.begin(new FileOutputStream(this.aTemporaryGraphFileName()));
                this.outGraph.addSink(this.output);
                this.outGraph.stepBegins(0.0);
                this.outGraph.addNode("A");
                this.outGraph.addNode("B");
                this.outGraph.addNode("C");
                this.outGraph.stepBegins(1.0);
                this.outGraph.addEdge("AB", "A", "B");
                this.outGraph.addEdge("BC", "B", "C");
                this.outGraph.addEdge("CA", "C", "A");
                this.outGraph.stepBegins(2.0);
                this.outGraph.addAttribute("a", 1);
                this.outGraph.addAttribute("b", "foo");
                this.outGraph.getNode("A").addAttribute("a", 1);
                this.outGraph.getNode("B").addAttribute("b", "foo");
                this.outGraph.getNode("C").addAttribute("c", "bar");
                this.outGraph.stepBegins(3.0);
                this.outGraph.removeNode("A");
                this.outGraph.stepBegins(4.0);
                this.outGraph.removeEdge("BC");
                this.output.end();
                this.input.addSink(this.inGraph);
                this.input.begin(this.aTemporaryGraphFileName());
                this.testDynamicTriangleStep0();
                this.input.nextStep();
                this.testDynamicTriangleStep0_1();
                this.input.nextStep();
                this.testDynamicTriangleStep1_2();
                this.input.nextStep();
                this.testDynamicTriangleStep2_3();
                this.input.nextStep();
                this.testDynamicTriangleStep3_4();
                this.input.nextStep();
                this.testDynamicTriangleStep4();
                this.input.end();
                this.removeFile(this.aTemporaryGraphFileName());
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.assertTrue((String)"Should not happen !", (boolean)false);
            }
        }
    }

    protected void createUndirectedTriangle() {
        this.outGraph.addNode("A");
        this.outGraph.addNode("B");
        this.outGraph.addNode("C");
        this.outGraph.addEdge("AB", "A", "B", false);
        this.outGraph.addEdge("BC", "B", "C", false);
        this.outGraph.addEdge("CA", "C", "A", false);
    }

    protected void createDirectedTriangle() {
        this.outGraph.addNode("A");
        this.outGraph.addNode("B");
        this.outGraph.addNode("C");
        this.outGraph.addEdge("AB", "A", "B", true);
        this.outGraph.addEdge("BC", "B", "C", false);
        this.outGraph.addEdge("CA", "A", "C", true);
    }

    protected void createAttributedTriangle() {
        this.outGraph.addNode("A");
        this.outGraph.addNode("B");
        this.outGraph.addNode("C");
        this.outGraph.addEdge("AB", "A", "B", true);
        this.outGraph.addEdge("BC", "B", "C", false);
        this.outGraph.addEdge("CA", "A", "C", true);
        this.outGraph.addAttribute("a", 1);
        this.outGraph.addAttribute("b", "foo");
        this.outGraph.getNode("A").addAttribute("a", 1);
        this.outGraph.getNode("B").addAttribute("b", "foo");
        this.outGraph.getNode("C").addAttribute("c", "bar");
    }

    protected void testUndirectedTriangle() {
        Assert.assertEquals((long)3L, (long)this.inGraph.getNodeCount());
        Assert.assertEquals((long)3L, (long)this.inGraph.getEdgeCount());
        Object A = this.inGraph.getNode("A");
        Object B = this.inGraph.getNode("B");
        Object C = this.inGraph.getNode("C");
        Assert.assertNotNull(A);
        Assert.assertNotNull(B);
        Assert.assertNotNull(C);
        if (this.formatHandlesEdgesIDs) {
            Assert.assertNotNull(this.inGraph.getEdge("AB"));
            Assert.assertNotNull(this.inGraph.getEdge("BC"));
            Assert.assertNotNull(this.inGraph.getEdge("CA"));
        }
        Assert.assertTrue((boolean)A.hasEdgeToward("B"));
        Assert.assertTrue((boolean)B.hasEdgeToward("C"));
        Assert.assertTrue((boolean)C.hasEdgeToward("A"));
        Assert.assertTrue((boolean)A.hasEdgeToward("C"));
        Assert.assertTrue((boolean)B.hasEdgeToward("A"));
        Assert.assertTrue((boolean)C.hasEdgeToward("B"));
    }

    protected void testDirectedTriangle() {
        Assert.assertEquals((long)3L, (long)this.inGraph.getNodeCount());
        Assert.assertEquals((long)3L, (long)this.inGraph.getEdgeCount());
        Object A = this.inGraph.getNode("A");
        Object B = this.inGraph.getNode("B");
        Object C = this.inGraph.getNode("C");
        Assert.assertNotNull(A);
        Assert.assertNotNull(B);
        Assert.assertNotNull(C);
        Assert.assertTrue((boolean)A.hasEdgeToward("B"));
        Assert.assertTrue((boolean)A.hasEdgeToward("C"));
        Assert.assertFalse((boolean)B.hasEdgeToward("A"));
        Assert.assertTrue((boolean)B.hasEdgeToward("C"));
        Assert.assertFalse((boolean)C.hasEdgeToward("A"));
        Assert.assertTrue((boolean)C.hasEdgeToward("B"));
        Object AB = A.getEdgeToward("B");
        Object BC = B.getEdgeToward("C");
        Object CA = A.getEdgeToward("C");
        Assert.assertTrue((boolean)AB.isDirected());
        Assert.assertFalse((boolean)BC.isDirected());
        Assert.assertTrue((boolean)CA.isDirected());
    }

    protected void testAttributedTriangle() {
        Assert.assertEquals((long)3L, (long)this.inGraph.getNodeCount());
        Assert.assertEquals((long)3L, (long)this.inGraph.getEdgeCount());
        Object A = this.inGraph.getNode("A");
        Object B = this.inGraph.getNode("B");
        Object C = this.inGraph.getNode("C");
        Assert.assertNotNull(A);
        Assert.assertNotNull(B);
        Assert.assertNotNull(C);
        Assert.assertEquals((Object)1, this.inGraph.getAttribute("a"));
        Assert.assertEquals((Object)"foo", this.inGraph.getAttribute("b"));
        Assert.assertEquals((Object)1, A.getAttribute("a"));
        Assert.assertEquals((Object)"foo", B.getAttribute("b"));
        Assert.assertEquals((Object)"bar", C.getAttribute("c"));
    }

    protected void testDynamicTriangleStep0() {
        Assert.assertEquals((long)0L, (long)this.inGraph.getNodeCount());
        Assert.assertEquals((long)0L, (long)this.inGraph.getEdgeCount());
    }

    protected void testDynamicTriangleStep0_1() {
        Assert.assertEquals((long)3L, (long)this.inGraph.getNodeCount());
        Assert.assertEquals((long)0L, (long)this.inGraph.getEdgeCount());
        Object A = this.inGraph.getNode("A");
        Object B = this.inGraph.getNode("B");
        Object C = this.inGraph.getNode("C");
        Assert.assertNotNull(A);
        Assert.assertNotNull(B);
        Assert.assertNotNull(C);
        Assert.assertEquals((long)0L, (long)A.getAttributeCount());
        Assert.assertEquals((long)0L, (long)B.getAttributeCount());
        Assert.assertEquals((long)0L, (long)C.getAttributeCount());
    }

    protected void testDynamicTriangleStep1_2() {
        Assert.assertEquals((long)3L, (long)this.inGraph.getNodeCount());
        Assert.assertEquals((long)3L, (long)this.inGraph.getEdgeCount());
        Object A = this.inGraph.getNode("A");
        Object B = this.inGraph.getNode("B");
        Object C = this.inGraph.getNode("C");
        Assert.assertNotNull(A);
        Assert.assertNotNull(B);
        Assert.assertNotNull(C);
        Assert.assertTrue((boolean)A.hasEdgeToward("B"));
        Assert.assertTrue((boolean)A.hasEdgeToward("C"));
        Assert.assertTrue((boolean)B.hasEdgeToward("A"));
        Assert.assertTrue((boolean)B.hasEdgeToward("C"));
        Assert.assertTrue((boolean)C.hasEdgeToward("A"));
        Assert.assertTrue((boolean)C.hasEdgeToward("B"));
    }

    protected void testDynamicTriangleStep2_3() {
        Assert.assertEquals((long)3L, (long)this.inGraph.getNodeCount());
        Assert.assertEquals((long)3L, (long)this.inGraph.getEdgeCount());
        Object A = this.inGraph.getNode("A");
        Object B = this.inGraph.getNode("B");
        Object C = this.inGraph.getNode("C");
        Assert.assertNotNull(A);
        Assert.assertNotNull(B);
        Assert.assertNotNull(C);
        Assert.assertTrue((boolean)this.inGraph.hasAttribute("a"));
        Assert.assertTrue((boolean)this.inGraph.hasAttribute("b"));
        Assert.assertTrue((boolean)A.hasAttribute("a"));
        Assert.assertTrue((boolean)B.hasAttribute("b"));
        Assert.assertTrue((boolean)C.hasAttribute("c"));
        Assert.assertEquals((Object)1, this.inGraph.getAttribute("a"));
        Assert.assertEquals((Object)"foo", this.inGraph.getAttribute("b"));
        Assert.assertEquals((Object)1, A.getAttribute("a"));
        Assert.assertEquals((Object)"foo", B.getAttribute("b"));
        Assert.assertEquals((Object)"bar", C.getAttribute("c"));
    }

    protected void testDynamicTriangleStep3_4() {
        Assert.assertEquals((long)2L, (long)this.inGraph.getNodeCount());
        Assert.assertEquals((long)1L, (long)this.inGraph.getEdgeCount());
        Object A = this.inGraph.getNode("A");
        Object B = this.inGraph.getNode("B");
        Object C = this.inGraph.getNode("C");
        Assert.assertNull(A);
        Assert.assertNotNull(B);
        Assert.assertNotNull(C);
        Assert.assertFalse((boolean)B.hasEdgeToward("A"));
        Assert.assertTrue((boolean)B.hasEdgeToward("C"));
        Assert.assertFalse((boolean)C.hasEdgeToward("A"));
        Assert.assertTrue((boolean)C.hasEdgeToward("B"));
    }

    protected void testDynamicTriangleStep4() {
        Assert.assertEquals((long)2L, (long)this.inGraph.getNodeCount());
        Assert.assertEquals((long)0L, (long)this.inGraph.getEdgeCount());
        Object A = this.inGraph.getNode("A");
        Object B = this.inGraph.getNode("B");
        Object C = this.inGraph.getNode("C");
        Assert.assertNull(A);
        Assert.assertNotNull(B);
        Assert.assertNotNull(C);
        Assert.assertFalse((boolean)B.hasEdgeToward("A"));
        Assert.assertFalse((boolean)B.hasEdgeToward("C"));
        Assert.assertFalse((boolean)C.hasEdgeToward("A"));
        Assert.assertFalse((boolean)C.hasEdgeToward("B"));
    }

    protected void removeFile(String fileName) {
        File file = new File(this.aTemporaryGraphFileName());
        boolean ok = file.delete();
        if (!ok) {
            System.err.printf("Cannot remove file %s !!%n", fileName);
        }
    }
}

